/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.task.masterslavetask;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.constant.MysqlConstUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.masterslave.util.MysqlMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLTASK_MASTER_SLAVEDataImport")
public class MysqlMsTaskDataImportVisitor
implements MysqlOperationVisitor<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsTaskDataImportVisitor.class);
    public static final String OPERATION_NAME = "MYSQLTASK_MASTER_SLAVEDataImport";

    @Override
    public void visit(MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> taskBackCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        MysqlFlowMsDataModelDTO flowMsDataModelDTO = (MysqlFlowMsDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        MysqlFlowMsDataModel flowMsDataModel = (MysqlFlowMsDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx = new MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO>();
        backCtx.setUseDataModelBase(flowMsDataModel);
        HashMap<String, MysqlFlowMsDataModelDTO> map = new HashMap<String, MysqlFlowMsDataModelDTO>();
        map.put(modelId, flowMsDataModelDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, flowMsDataModelDTO);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        for (MysqlDataModelBase mysqlDataModelBase : flowMsDataModel.getSlaveTables()) {
            MysqlDataModelBaseDTO mysqlDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(mysqlDataModelBase.getId());
            String slaveModelName = mysqlDataModelBase.getName();
            for (MysqlDataModelFieldDto mysqlDataModelFieldDto : mysqlDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(mysqlDataModelFieldDto.getFill())) continue;
                relationTagKeys.put(slaveModelName, mysqlDataModelFieldDto.getCapitalName());
            }
        }
        if (HussarUtils.isNotEmpty(relationTagKeys)) {
            controllerParams.put("relationTagKeys", relationTagKeys);
        }
        HashMap<String, Boolean> slaveTablePlusSave = new HashMap<String, Boolean>();
        for (MysqlRelationshipDTO relationshipDTO : flowMsDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        for (MysqlDataModelBase modelBase : flowMsDataModel.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((MysqlBaseDataModel)modelBase).getLogicallyDelete());
            MysqlDataModelBaseDTO mysqlDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, MysqlMasterSlaveUtil.getCapitalName(slaveModelName));
            for (MysqlDataModelField mysqlDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(mysqlDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, mysqlDataModelField.getName());
            }
            for (MysqlDataModelFieldDto mysqlDataModelFieldDto : mysqlDataModelBaseDTO.getFields()) {
                if ("primary".equals(mysqlDataModelFieldDto.getFill())) {
                    primaryKeys.put(slaveModelName, mysqlDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(mysqlDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, mysqlDataModelFieldDto.getCapitalName());
            }
        }
        this.addFormPlusSaveDto(flowMsDataModel, flowMsDataModelDTO, backCtx, slaveTablePlusSave);
        controllerParams.put("table", flowMsDataModelDTO);
        controllerParams.put("returnValue", flowMsDataModelDTO.getEntityName());
        MysqlDataModelBaseDTO mysqlDataModelBaseDTO = flowMsDataModelDTO.getDataModelDtoMap().get(flowMsDataModel.getMasterTable().getId());
        controllerParams.put("masterTable", mysqlDataModelBaseDTO);
        String controllerPath = "template/taskbackcode/masterslavetaskbackcode/templateImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, flowMsDataModelDTO.getServiceName());
        String servicePath = "template/taskbackcode/masterslavetaskbackcode/templateImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        this.masterSlaveCode(backCtx, controllerParams);
        MysqlDataModelFieldDto keyField = flowMsDataModelDTO.getKeyField();
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        String string = "template/taskbackcode/masterslavetaskbackcode/templateImport/service_impl.ftl";
        controllerParams.put("primaryField", keyField.getCapitalName());
        controllerParams.put("isPlusSave", false);
        controllerParams.put("primaryKeys", primaryKeys);
        controllerParams.put("foreignKeys", foreignKeys);
        controllerParams.put("slaveTable", MysqlMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        controllerParams.put("isLogicallyDelete", isLogicallyDelete);
        controllerParams.put("logicallyDelField", logicallyDelField);
        controllerParams.put("capitalNameList", capitalNameList);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)string, controllerParams));
        this.renderImport(backCtx, modelId, flowMsDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", flowMsDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6a21\u677f\u6253\u5370");
        backCtx.addApi(modelId, MysqlBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, String modelId, MysqlFlowMsDataModelDTO flowMsDataModelDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, flowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.template.print.utils.VerifyExcelUtil");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.model.SysExcelTask");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.constants.TaskConstants");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.service.ISysExcelTaskService");
        backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplInversion(modelId, "ISysExcelTaskService");
        backCtx.addServiceImplInversion(modelId, "HussarThreadPoolConfiguration");
        backCtx.addServiceImplImport(modelId, "java.io.IOException");
        backCtx.addServiceImplImport(modelId, "java.io.InputStream");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.SecurityUser");
        backCtx.addServiceImplImport(modelId, "java.util.concurrent.Executor");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration");
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6a21\u677f\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void masterSlaveCode(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        MysqlFlowMsDataModel flowMsDataModel = backCtx.getUseDataModelBase();
        String modelId = flowMsDataModel.getId();
        MysqlFlowMsDataModelDTO flowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<MysqlRelationshipDTO> relationshipDtoList = flowMsDataModelDTO.getRelationshipDtoList();
        MysqlDataModelBase masterTable = flowMsDataModel.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, MysqlDataModelBaseDTO> dataModelDtoMap = flowMsDataModelDTO.getDataModelDtoMap();
        MysqlDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        String masterFillCode = this.renderFillCode(backCtx, mainDataModelDto, flowMsDataModelDTO, false, mainDataModelDto);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        if (ToolUtil.isNotEmpty((Object)flowMsDataModel) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (MysqlRelationshipDTO mysqlRelationshipDTO : relationshipDtoList) {
                List<MysqlRelationshipFieldDTO> mysqlRelationshipFieldDTOS;
                String slaveTableId = mysqlRelationshipDTO.getSlaveTableId();
                String relateModelType = mysqlRelationshipDTO.getRelateModelType();
                MysqlDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
                String slaveFillCode = this.renderFillCode(backCtx, slaveModelDto, flowMsDataModelDTO, false, mainDataModelDto);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                controllerParams.put("slaveFillCodeList", slaveFillCodeList);
                if (slaveFillCode != null) {
                    mysqlRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(mysqlRelationshipFieldDTOS = mysqlRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
        }
    }

    private String renderFillCode(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelBaseDTO dataModelBaseDTO, MysqlFlowMsDataModelDTO msDataModelDTO, boolean isMs, MysqlDataModelBaseDTO mainDataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        if (isMs) {
            params.put("serviceEnName", mainDataModelDto.getServiceEnName());
        } else {
            params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        }
        boolean insertFill = false;
        boolean updateFill = false;
        for (MysqlDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "createTime": 
                case "delDefFlag": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", MysqlConstUtil.TRUE);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                }
                case "updateTime": {
                    if (field.getType().equals("date")) {
                        msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    }
                    insertFill = true;
                    params.put("insertFill", MysqlConstUtil.TRUE);
                    updateFill = true;
                    params.put("updateFill", MysqlConstUtil.TRUE);
                    break;
                }
                case "primary": {
                    insertFill = true;
                    params.put("insertFill", MysqlConstUtil.TRUE);
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.support.engine.core.util.EngineUtil");
                    params.put("primaryFill", MysqlConstUtil.TRUE);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/masterslavebackcode/templateImport/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private void addFormPlusSaveDto(MysqlFlowMsDataModel flowMsDataModel, MysqlFlowMsDataModelDTO flowMsDataModelDTO, MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, Map<String, Boolean> slaveTablePlusSave) {
        MysqlQueryDTO queryDTO = new MysqlQueryDTO();
        String modelId = flowMsDataModel.getId();
        String masterId = flowMsDataModel.getMasterTable().getId();
        queryDTO.setFtlPath("template/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", flowMsDataModelDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", MysqlMasterSlaveUtil.ofSlaveParam(flowMsDataModel, flowMsDataModelDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("queryDto", queryDTO);
        params.put("table", flowMsDataModelDTO);
        queryDTO.setParams(params);
        queryDTO.setName(flowMsDataModelDTO.getName() + "IncrementDTO");
        queryDTO.setEntityName(flowMsDataModelDTO.getEntityName() + "IncrementDTO");
        queryDTO.setPackageInfo(flowMsDataModelDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(flowMsDataModelDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importDTOPath = flowMsDataModelDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        flowMsDataModelDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }
}

