/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.constant.DataImportConstant;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.serialNumber.SerialNumRuleDTO;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.TemplateUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslate;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslateCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslateField;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.printTemplate.service.impl.PrintTemplateServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintGroupInfo;
import com.jxdinfo.hussar.template.print.model.SysTemplatePrintInfo;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintGroupInfoService;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class MysqlTemplateUtil {
    private static final PrintTemplateServiceImpl printTemplateService = (PrintTemplateServiceImpl)SpringContextHolder.getBean(PrintTemplateServiceImpl.class);
    private static final ISysTemplatePrintGroupInfoService iSysTemplatePrintGroupInfoService = (ISysTemplatePrintGroupInfoService)SpringContextHolder.getBean(ISysTemplatePrintGroupInfoService.class);
    private static final ISysTemplatePrintInfoService iSysTemplatePrintInfoService = (ISysTemplatePrintInfoService)SpringContextHolder.getBean(ISysTemplatePrintInfoService.class);

    @HussarTransactional
    public static PublishTemplateDto processTemplate(String modelBaseId, List<MysqlDataModelBase> slaveTables) throws LcdpException, CloneNotSupportedException {
        PublishTemplateDto publishTemplateDto = new PublishTemplateDto();
        DataModelBase modelBase = DataModelUtil.getDataModelBase((String)modelBaseId);
        if (ToolUtil.isNotEmpty((Object)modelBase) && ToolUtil.isNotEmpty((Object)modelBase.getId())) {
            MysqlDataModelBase dataModelBase = MysqlDataModelUtil.transfer(modelBase);
            String id = dataModelBase.getId();
            List sysTemplatePrintInfoList = iSysTemplatePrintInfoService.getTemplateListByPageId(id);
            ArrayList<Map<String, Object>> addOrUpdateList = new ArrayList<Map<String, Object>>();
            ArrayList<Long> removeList = new ArrayList<Long>();
            if (ToolUtil.isNotEmpty(dataModelBase.getImportTemplate())) {
                Object translates;
                Map<String, Map<String, Object>> importTemplate = dataModelBase.getImportTemplate();
                List<MysqlDataModelField> modelFields = dataModelBase.getFields();
                ConcurrentHashMap<String, Object> dictType = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateTable = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateServiceBeanName = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateTableProp = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> associateTablePropCode = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> organTranslate = new ConcurrentHashMap<String, Object>();
                ConcurrentHashMap<String, Object> userTranslate = new ConcurrentHashMap<String, Object>();
                if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(dataModelBase.getTranslate()) && ToolUtil.isNotEmpty((Object)(translates = dataModelBase.getTranslate()))) {
                    MysqlTemplateUtil.getTranslateInfo((List<MysqlTranslate>)translates, modelFields, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                }
                if (ToolUtil.isNotEmpty(slaveTables)) {
                    for (MysqlDataModelBase slaveTable : slaveTables) {
                        List<MysqlDataModelField> sFields = slaveTable.getFields();
                        ArrayList<MysqlTranslate> slaveTranslates = new ArrayList<MysqlTranslate>();
                        if (ToolUtil.isNotEmpty(dataModelBase.getTranslate())) {
                            block1: for (MysqlDataModelField field : sFields) {
                                for (MysqlTranslate translate : dataModelBase.getTranslate()) {
                                    if (!translate.getSourceFieldId().equals(field.getId())) continue;
                                    slaveTranslates.add(translate);
                                    continue block1;
                                }
                            }
                        }
                        if (ToolUtil.isNotEmpty(slaveTranslates)) {
                            MysqlTemplateUtil.getSlaveTranslateInfo(slaveTranslates, sFields, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                        }
                        for (MysqlDataModelField mysqlMsDataModel : modelFields) {
                            if (!HussarUtils.equals((Object)mysqlMsDataModel.getSourceDataModelId(), (Object)slaveTable.getId())) continue;
                            if (HussarUtils.equals((Object)"array", (Object)mysqlMsDataModel.getDataType())) {
                                mysqlMsDataModel.setDataType("collection");
                                mysqlMsDataModel.setProperties(sFields);
                                continue;
                            }
                            mysqlMsDataModel.setId(slaveTable.getId());
                            mysqlMsDataModel.setName(slaveTable.getName());
                            mysqlMsDataModel.setComment(slaveTable.getComment());
                            mysqlMsDataModel.setDataType("association");
                            mysqlMsDataModel.setUsage("");
                            mysqlMsDataModel.setProperties(sFields);
                        }
                    }
                }
                JSONArray fieldControlList = MysqlTemplateUtil.processFieldControl(modelBase.getComment(), modelFields, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                List sysTemplatePrintGroupInfos = printTemplateService.processParentIds(id);
                SysTemplatePrintGroupInfo sysTemplatePrintGroupInfo = (SysTemplatePrintGroupInfo)sysTemplatePrintGroupInfos.get(0);
                String groupId = String.valueOf(sysTemplatePrintGroupInfo.getGroupId());
                iSysTemplatePrintGroupInfoService.processGroups(sysTemplatePrintGroupInfos);
                ArrayList<Map> projectTemplatePrintInfos = new ArrayList<Map>();
                String entityClassPath = TemplateUtil.getModelPath((DataModelBase)dataModelBase);
                for (Object key : importTemplate.keySet()) {
                    Map map = (Map)importTemplate.get(key);
                    map.put("templateId", key);
                    map.put("pageId", id);
                    map.put("groupId", groupId);
                    map.put("entityClassPath", entityClassPath);
                    map.put("templateStatus", map.get("status"));
                    map.put("templateName", map.get("content"));
                    map.put("businessId", id);
                    map.put("type", "excel-import");
                    map.put("default", map.get("default"));
                    map.put("fieldControl", fieldControlList.toJSONString());
                    projectTemplatePrintInfos.add(map);
                }
                ArrayList<Map<String, Object>> sysTemplatePrintInfos = new ArrayList<Map<String, Object>>();
                if (ToolUtil.isNotEmpty((Object)sysTemplatePrintInfoList)) {
                    for (SysTemplatePrintInfo sysTemplatePrintInfo : sysTemplatePrintInfoList) {
                        sysTemplatePrintInfos.add((Map<String, Object>)((JSONObject)JSONObject.toJSON((Object)sysTemplatePrintInfo)));
                    }
                }
                HashMap<String, Map> tempMapA = new HashMap<String, Map>();
                HashMap<String, Map> tempMapB = new HashMap<String, Map>();
                HashMap<String, Map> tempMapC = new HashMap<String, Map>();
                for (Map map : projectTemplatePrintInfos) {
                    tempMapA.put(String.valueOf(map.get("templateId")), map);
                }
                for (Map map : sysTemplatePrintInfos) {
                    tempMapB.put(String.valueOf(map.get("templateId")), map);
                }
                for (Map map : tempMapB.values()) {
                    if (tempMapA.containsKey(String.valueOf(map.get("templateId")))) continue;
                    removeList.add(Long.valueOf(String.valueOf(map.get("templateId"))));
                    tempMapC.put(String.valueOf(map.get("templateId")), map);
                }
                for (Map map : tempMapA.values()) {
                    if (tempMapC.containsKey(String.valueOf(map.get("templateId")))) continue;
                    addOrUpdateList.add(map);
                }
                ArrayList addList = new ArrayList();
                for (Map map : tempMapA.values()) {
                    if (tempMapB.containsKey(String.valueOf(map.get("templateId")))) continue;
                    addList.add(map.get("templateId"));
                }
                if (ToolUtil.isNotEmpty(addList)) {
                    for (Map map : addOrUpdateList) {
                        String templateName;
                        if (!addList.contains(map.get("templateId"))) continue;
                        String string = templateName = map.get("content") == null ? "" : map.get("content").toString();
                        Map fileMap = iSysTemplatePrintInfoService.generateTemplate(fieldControlList.toJSONString(), templateName);
                        if (!ToolUtil.isNotEmpty((Object)fileMap)) continue;
                        map.put("fileId", String.valueOf(fileMap.get("fileId")));
                        map.put("fileName", String.valueOf(fileMap.get("fileName")));
                    }
                }
                MysqlTemplateUtil.compileFieldControl(addOrUpdateList, sysTemplatePrintInfos);
            } else if (ToolUtil.isNotEmpty((Object)sysTemplatePrintInfoList)) {
                for (SysTemplatePrintInfo sysTemplatePrintInfo : sysTemplatePrintInfoList) {
                    removeList.add(sysTemplatePrintInfo.getTemplateId());
                }
            }
            HashMap<String, ArrayList<Object>> params = new HashMap<String, ArrayList<Object>>();
            params.put("removed", removeList);
            params.put("added", addOrUpdateList);
            publishTemplateDto.setParams(params);
        }
        return publishTemplateDto;
    }

    private static Object getNestedOrDefault(Map<String, Object> outerMap, String outerKey, String innerKey, Object defaultValue) {
        if (ToolUtil.isNotEmpty((Object)outerMap.get(outerKey)) && outerMap.get(outerKey) instanceof Map) {
            Map innerMap = (Map)outerMap.get(outerKey);
            if (innerMap == null) {
                return defaultValue;
            }
            return innerMap.getOrDefault(innerKey, defaultValue);
        }
        return outerMap.getOrDefault(outerKey, defaultValue);
    }

    private static JSONArray processFieldControl(String comment, List<MysqlDataModelField> modelFields, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) {
        JSONArray fieldControlList = new JSONArray();
        ConcurrentHashMap map = new ConcurrentHashMap();
        List newModelFields = modelFields.stream().filter(e -> map.putIfAbsent(e.getId(), e) == null).collect(Collectors.toList());
        for (MysqlDataModelField objectMap : newModelFields) {
            Map<String, Object> fieldMap = MysqlTemplateUtil.createBaseFieldMap(objectMap, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate, comment);
            if (HussarUtils.equals((Object)"collection", (Object)objectMap.getDataType()) || HussarUtils.equals((Object)"association", (Object)objectMap.getDataType())) {
                List<MysqlDataModelField> properties = objectMap.getProperties();
                JSONArray children = new JSONArray();
                for (MysqlDataModelField slaveModelField : properties) {
                    Map<String, Object> slavefieldMap = MysqlTemplateUtil.createSlaveBaseFieldMap(slaveModelField, dictType, associateTable, associateServiceBeanName, associateTableProp, associateTablePropCode, organTranslate, userTranslate);
                    children.add(slavefieldMap);
                }
                fieldMap.put("children", children);
            } else {
                fieldMap.put("children", DataImportConstant.EMPTY_LIST);
            }
            List<SerialNumRuleDTO> serialNum = objectMap.getSerialNum();
            if (ToolUtil.isNotEmpty(serialNum)) {
                serialNum.stream().filter(n -> HussarUtils.equals((Object)n.getType(), (Object)"serialNumber")).forEach(n -> fieldMap.put("serialNumber", n.getConfig().getId()));
            } else {
                fieldMap.put("serialNumber", "");
            }
            if (HussarUtils.isEmpty((Object)fieldMap.get("userTranslate")) && HussarUtils.isEmpty((Object)fieldMap.get("organTranslate")) && HussarUtils.isEmpty((Object)fieldMap.get("dictType")) && HussarUtils.isEmpty((Object)fieldMap.get("associateTable"))) {
                String dataTypeKey = "dataType";
                switch (String.valueOf(fieldMap.get("propType"))) {
                    case "long": 
                    case "int": 
                    case "double": {
                        fieldMap.put(dataTypeKey, "Numeric");
                        break;
                    }
                    case "date": {
                        fieldMap.put(dataTypeKey, "LocalDateTime");
                        break;
                    }
                    case "boolean": {
                        fieldMap.put(dataTypeKey, "Boolean");
                        break;
                    }
                    case "association": {
                        fieldMap.put(dataTypeKey, "Association");
                        break;
                    }
                    case "collection": {
                        fieldMap.put(dataTypeKey, "Collection");
                        break;
                    }
                    default: {
                        fieldMap.put(dataTypeKey, "String");
                    }
                }
            }
            fieldControlList.add(fieldMap);
        }
        return fieldControlList;
    }

    private static Map<String, Object> createSlaveBaseFieldMap(MysqlDataModelField field, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("prop", field.getName());
        fieldMap.put("propName", field.getComment());
        fieldMap.put("specialPurpose", field.getUsage());
        String fieldId = field.getId();
        String fieldName = field.getName();
        MysqlTemplateUtil.putNestedValue(fieldMap, "dictType", dictType, fieldId, fieldName);
        MysqlTemplateUtil.putNestedValue(fieldMap, "associateTable", associateTable, fieldId, fieldName);
        MysqlTemplateUtil.putNestedValue(fieldMap, "associateService", associateServiceBeanName, fieldId, fieldName);
        MysqlTemplateUtil.putNestedValue(fieldMap, "associateTableProp", associateTableProp, fieldId, fieldName);
        MysqlTemplateUtil.putNestedValue(fieldMap, "associateTablePropCode", associateTablePropCode, fieldId, fieldName);
        MysqlTemplateUtil.putNestedValue(fieldMap, "organTranslate", organTranslate, fieldId, fieldName);
        MysqlTemplateUtil.putNestedValue(fieldMap, "userTranslate", userTranslate, fieldId, fieldName);
        fieldMap.put("propType", field.getDataType());
        fieldMap.put("checkOtherRule", DataImportConstant.EMPTY_LIST);
        fieldMap.put("children", DataImportConstant.EMPTY_LIST);
        for (String key : DataImportConstant.COPY_KEYS) {
            fieldMap.put(key, "");
        }
        fieldMap.put("importField", true);
        return fieldMap;
    }

    private static Map<String, Object> createBaseFieldMap(MysqlDataModelField field, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate, String comment) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("modelName", comment);
        fieldMap.put("prop", field.getName());
        fieldMap.put("propName", field.getComment());
        fieldMap.put("specialPurpose", field.getUsage());
        fieldMap.put("dictType", dictType.getOrDefault(field.getName(), ""));
        fieldMap.put("associateTable", associateTable.getOrDefault(field.getName(), ""));
        fieldMap.put("associateService", associateServiceBeanName.getOrDefault(field.getName(), ""));
        fieldMap.put("associateTableProp", associateTableProp.getOrDefault(field.getName(), ""));
        fieldMap.put("associateTablePropCode", associateTablePropCode.getOrDefault(field.getName(), ""));
        fieldMap.put("organTranslate", organTranslate.getOrDefault(field.getName(), ""));
        fieldMap.put("userTranslate", userTranslate.getOrDefault(field.getName(), ""));
        fieldMap.put("propType", field.getDataType());
        fieldMap.put("checkOtherRule", DataImportConstant.EMPTY_LIST);
        for (String key : DataImportConstant.COPY_KEYS) {
            fieldMap.put(key, "");
        }
        fieldMap.put("importField", true);
        return fieldMap;
    }

    public static void getTranslateInfo(List<MysqlTranslate> translates, List<MysqlDataModelField> modelFields, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) throws LcdpException, CloneNotSupportedException {
        for (MysqlTranslate translate : translates) {
            List<MysqlTranslateField> translateFields = translate.getTranslateFields();
            if (translateFields == null) continue;
            String translateType = translate.getTranslateType();
            if (HussarUtils.equals((Object)translateType, (Object)"dictTranslate")) {
                modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> dictType.put(String.valueOf(n.getName()), translate.getSourceId()));
                continue;
            }
            for (MysqlTranslateField translateField : translateFields) {
                if (!Boolean.parseBoolean(translateField.getTemplate())) continue;
                if (HussarUtils.equals((Object)translate.getTranslateType(), (Object)"modelTranslate")) {
                    String modelId = translate.getSourceId();
                    DataModelBase associateDataModelBase = DataModelUtil.getDataModelBase((String)modelId);
                    String modelPath = TemplateUtil.getModelPath((DataModelBase)associateDataModelBase);
                    if (ToolUtil.isNotEmpty((Object)associateDataModelBase)) {
                        modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> associateTable.put(String.valueOf(n.getName()), modelPath));
                        MysqlDataModelBase associateModelBase = MysqlDataModelUtil.transfer(associateDataModelBase);
                        List<MysqlTranslateCondition> dataModelCondition = translate.getDataModelCondition();
                        List<MysqlDataModelField> associateFields = associateModelBase.getFields();
                        if (Boolean.parseBoolean(translateField.getTemplate())) {
                            for (MysqlDataModelField associateField : associateFields) {
                                if (HussarUtils.equals((Object)translateField.getTranslateSource(), (Object)associateField.getId())) {
                                    modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> {
                                        associateTableProp.put(String.valueOf(n.getName()), associateField.getName());
                                        String serviceBeanName = MysqlTemplateUtil.getServiceBeanNameByDataModel(associateModelBase);
                                        associateServiceBeanName.put(String.valueOf(n.getName()), serviceBeanName);
                                    });
                                }
                                if (dataModelCondition.isEmpty() || !HussarUtils.equals((Object)dataModelCondition.get(0).getGoalsRowId(), (Object)associateField.getId())) continue;
                                modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)((MysqlTranslateCondition)dataModelCondition.get(0)).getFromModelField())).forEach(n -> associateTablePropCode.put(String.valueOf(n.getName()), associateField.getName()));
                            }
                        }
                    }
                }
                if (HussarUtils.equals((Object)translateType, (Object)"organTranslate")) {
                    modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> organTranslate.put(String.valueOf(n.getName()), translateField.getTranslateSource()));
                }
                if (!HussarUtils.equals((Object)translateType, (Object)"userTranslate")) continue;
                modelFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)translate.getSourceFieldId())).forEach(n -> userTranslate.put(String.valueOf(n.getName()), translateField.getTranslateSource()));
            }
        }
    }

    public static void getSlaveTranslateInfo(List<MysqlTranslate> slaveTranslates, List<MysqlDataModelField> sFields, Map<String, Object> dictType, Map<String, Object> associateTable, Map<String, Object> associateServiceBeanName, Map<String, Object> associateTableProp, Map<String, Object> associateTablePropCode, Map<String, Object> organTranslate, Map<String, Object> userTranslate) throws LcdpException, CloneNotSupportedException {
        for (MysqlTranslate slaveTranslate : slaveTranslates) {
            List<MysqlTranslateField> slaveTranslateFields = slaveTranslate.getTranslateFields();
            List<MysqlTranslateCondition> dataModelCondition = slaveTranslate.getDataModelCondition();
            if (HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"dictTranslate")) {
                sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                    ConcurrentHashMap<String, String> dictTypeValue = new ConcurrentHashMap<String, String>();
                    dictTypeValue.put(String.valueOf(n.getName()), slaveTranslate.getSourceId());
                    dictType.put(n.getId(), dictTypeValue);
                });
                continue;
            }
            for (MysqlTranslateField translateField : slaveTranslateFields) {
                if (!Boolean.parseBoolean(translateField.getTemplate())) continue;
                if (HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"modelTranslate")) {
                    ConcurrentHashMap associateTableValue = new ConcurrentHashMap();
                    ConcurrentHashMap associateServiceBeanNameValue = new ConcurrentHashMap();
                    DataModelBase associateDataModelBase = DataModelUtil.getDataModelBase((String)slaveTranslate.getSourceId());
                    if (ToolUtil.isNotEmpty((Object)associateDataModelBase)) {
                        String modelPath = TemplateUtil.getModelPath((DataModelBase)associateDataModelBase);
                        MysqlDataModelBase associateModelBase = MysqlDataModelUtil.transfer(associateDataModelBase);
                        sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                            associateTableValue.put(String.valueOf(n.getName()), modelPath);
                            associateTable.put(n.getId(), associateTableValue);
                            String serviceBeanName = MysqlTemplateUtil.getServiceBeanNameByDataModel(associateModelBase);
                            associateServiceBeanNameValue.put(String.valueOf(n.getName()), serviceBeanName);
                            associateServiceBeanName.put(n.getId(), associateServiceBeanNameValue);
                        });
                        List<MysqlDataModelField> associateFields = associateModelBase.getFields();
                        if (Boolean.parseBoolean(translateField.getTemplate())) {
                            for (MysqlDataModelField associateField : associateFields) {
                                if (HussarUtils.equals((Object)translateField.getTranslateSource(), (Object)associateField.getId())) {
                                    ConcurrentHashMap associateTablePropValue = new ConcurrentHashMap();
                                    sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                                        associateTablePropValue.put(String.valueOf(n.getName()), associateField.getName());
                                        associateTableProp.put(n.getId(), associateTablePropValue);
                                    });
                                }
                                if (dataModelCondition.isEmpty() || !HussarUtils.equals((Object)dataModelCondition.get(0).getGoalsRowId(), (Object)associateField.getId())) continue;
                                ConcurrentHashMap associateTablePropCodeValue = new ConcurrentHashMap();
                                sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)((MysqlTranslateCondition)dataModelCondition.get(0)).getFromModelField())).forEach(n -> {
                                    associateTablePropCodeValue.put(String.valueOf(n.getName()), associateField.getName());
                                    associateTablePropCode.put(n.getId(), associateTablePropCodeValue);
                                });
                            }
                        }
                    }
                }
                if (HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"organTranslate")) {
                    ConcurrentHashMap organTranslateValue = new ConcurrentHashMap();
                    sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                        organTranslateValue.put(String.valueOf(n.getName()), translateField.getTranslateSource());
                        organTranslate.put(n.getId(), organTranslateValue);
                    });
                }
                if (!HussarUtils.equals((Object)slaveTranslate.getTranslateType(), (Object)"userTranslate")) continue;
                ConcurrentHashMap associateTablePropCodeValue = new ConcurrentHashMap();
                sFields.stream().filter(n -> HussarUtils.equals((Object)n.getId(), (Object)slaveTranslate.getSourceFieldId())).forEach(n -> {
                    associateTablePropCodeValue.put(String.valueOf(n.getName()), translateField.getTranslateSource());
                    userTranslate.put(n.getId(), associateTablePropCodeValue);
                });
            }
        }
    }

    private static void compileFieldControl(List<Map<String, Object>> addOrUpdateList, List<Map<String, Object>> sysTemplatePrintInfos) {
        for (Map<String, Object> addListMap : addOrUpdateList) {
            JSONArray add = JSON.parseArray((String)String.valueOf(addListMap.get("fieldControl")));
            for (Map<String, Object> templatePrintInfo : sysTemplatePrintInfos) {
                Map templatePrintInfoContent = (Map)JSON.parseObject((String)String.valueOf(templatePrintInfo.get("content")), Map.class);
                JSONArray fieldControl = JSON.parseArray((String)String.valueOf(templatePrintInfoContent.get("fieldControl")));
                if (!addListMap.get("templateId").equals(String.valueOf(templatePrintInfo.get("templateId")))) continue;
                if (ToolUtil.isNotEmpty(templatePrintInfoContent.get("custom"))) {
                    addListMap.put("custom", templatePrintInfoContent.get("custom"));
                }
                if (ToolUtil.isNotEmpty((Object)fieldControl)) {
                    MysqlTemplateUtil.mergeFieldControl(add, fieldControl);
                }
                addListMap.put("fieldControl", add.toJSONString());
                if (!templatePrintInfoContent.containsKey("fileId")) continue;
                addListMap.put("fileId", templatePrintInfoContent.get("fileId"));
                addListMap.put("fileName", templatePrintInfoContent.get("templateFileName"));
            }
        }
    }

    public static void mergeFieldControl(JSONArray add, JSONArray fieldControl) {
        String prop;
        HashMap<String, Map> fieldControlMap = new HashMap<String, Map>();
        for (Object obj : fieldControl) {
            Map field;
            if (!(obj instanceof Map) || (prop = (String)(field = (Map)obj).get("prop")) == null) continue;
            fieldControlMap.put(prop, field);
            if (!ToolUtil.isNotEmpty(field.get("children"))) continue;
            List children = (List)field.get("children");
            for (Map child : children) {
                String childProp = (String)child.get("prop");
                if (childProp == null) continue;
                String fullProp = prop + "." + childProp;
                fieldControlMap.put(fullProp, child);
            }
        }
        for (Object o : add) {
            Map addField = (Map)o;
            prop = (String)addField.get("prop");
            Map matchedField = (Map)fieldControlMap.get(prop);
            if (matchedField != null) {
                for (String key : DataImportConstant.COPY_KEYS) {
                    Object value = matchedField.get(key);
                    if (!ToolUtil.isNotEmpty(value)) continue;
                    addField.put(key, value);
                }
                if (!ToolUtil.isNotEmpty(addField.get("children"))) continue;
                List children = (List)addField.get("children");
                for (Map child : children) {
                    String childProp = (String)child.get("prop");
                    if (!ToolUtil.isNotEmpty((Object)childProp)) continue;
                    String fullProp = prop + "." + childProp;
                    Map subMatchedField = (Map)fieldControlMap.get(fullProp);
                    if (subMatchedField != null) {
                        for (String key : DataImportConstant.COPY_KEYS) {
                            Object value = subMatchedField.get(key);
                            if (!ToolUtil.isNotEmpty(value)) continue;
                            child.put(key, value);
                        }
                        continue;
                    }
                    child.put("importField", false);
                }
                continue;
            }
            addField.put("importField", false);
        }
    }

    private static void putNestedValue(Map<String, Object> map, String key, Map<String, Object> nestedMap, String fieldId, String fieldName) {
        map.put(key, MysqlTemplateUtil.getNestedOrDefault(nestedMap, fieldId, fieldName, ""));
    }

    public static String getServiceBeanNameByDataModel(MysqlDataModelBase dataModelBase) {
        StringBuilder serviceBeanName = new StringBuilder();
        String tablePath = dataModelBase.getModelPath() + "/" + dataModelBase.getName();
        serviceBeanName.append(tablePath.toLowerCase().replace("/", "."));
        serviceBeanName.append(".");
        String entityName = NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBase.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
        try {
            if ("MASTER_SLAVE".equals(dataModelBase.getFunctionType()) || "TASK_MASTER_SLAVE".equals(dataModelBase.getFunctionType())) {
                entityName = entityName + "Master";
            } else if ("TASK".equals(dataModelBase.getFunctionType())) {
                entityName = entityName + "Task";
            }
            serviceBeanName.append(entityName + "ServiceImpl");
            return serviceBeanName.deleteCharAt(0).toString();
        }
        catch (LcdpException e) {
            throw new RuntimeException("\u83b7\u53d6\u6a21\u578b\u7c7b\u578b\u5f02\u5e38");
        }
    }
}

