/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MysqlPublicEnclosure {
    private static FormDesignProperties formDesignProperties = (FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class);

    public static void enclosure(MysqlDataModelBase dataModelBase, MysqlDataModelBaseDTO dataModelBaseDTO) throws CloneNotSupportedException, LcdpException {
        boolean ignoreStrategy = false;
        dataModelBaseDTO.setDataSourceName(dataModelBase.getDataSourceName());
        dataModelBaseDTO.setId(dataModelBase.getId());
        dataModelBaseDTO.setName(dataModelBase.getName());
        dataModelBaseDTO.setComment(dataModelBase.getComment());
        dataModelBaseDTO.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelBaseDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setVoName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelBaseDTO.getName() + "VO"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        dataModelBaseDTO.setMapperName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setXmlName(dataModelBaseDTO.getEntityName() + "Mapper");
        dataModelBaseDTO.setServiceName(dataModelBaseDTO.getEntityName() + "Service");
        dataModelBaseDTO.setServiceImplName(dataModelBaseDTO.getEntityName() + "ServiceImpl");
        dataModelBaseDTO.setControllerName(dataModelBaseDTO.getEntityName() + "Controller");
        dataModelBaseDTO.setModuleName(dataModelBase.getModelPath().replace("/", "."));
        dataModelBaseDTO.setDictName(dataModelBaseDTO.getEntityName() + NamingStrategy.capitalFirst((String)"dict"));
        dataModelBaseDTO.setTablePath(dataModelBase.getModelPath() + "/" + dataModelBase.getName());
        List<MysqlDataModelField> dataModelFieldBases = dataModelBase.getFields();
        ArrayList<MysqlDataModelFieldDto> tableFields = new ArrayList<MysqlDataModelFieldDto>();
        for (MysqlDataModelField dataModelFieldBase : dataModelFieldBases) {
            MysqlDataModelFieldDto tableField = new MysqlDataModelFieldDto();
            tableField.setKeyFlag("primary".equals(dataModelFieldBase.getUsage()));
            tableField.setVersionFlag("version".equals(dataModelFieldBase.getUsage()));
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setId(dataModelFieldBase.getId());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (!Objects.equals(Optional.of(dataModelFieldBase).map(MysqlDataModelField::getUpdateStrategy).orElse(null), "not_null")) {
                ignoreStrategy = true;
            }
            if ("date".equals(dataModelFieldBase.getDataType())) {
                ignoreStrategy = true;
            }
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFields(tableFields);
        if (ignoreStrategy) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.FieldStrategy;");
        }
        if (dataModelBaseDTO.isUseMybatisPlus()) {
            dataModelBaseDTO.addEntityImport("com.baomidou.mybatisplus.annotation.TableName");
        }
        Map packageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        dataModelBaseDTO.setPackageInfo(packageInfo);
        Map<String, String> importInfo = MysqlPublicEnclosure.getImportInfo(packageInfo, dataModelBaseDTO);
        dataModelBaseDTO.setImportInfo(importInfo);
        ArrayList<MysqlDataModelFieldDto> voFields = new ArrayList<MysqlDataModelFieldDto>();
        for (MysqlDataModelFieldDto tableField : tableFields) {
            voFields.add(tableField.clone());
        }
        VoGeneratorInfo voGeneratorInfo = new VoGeneratorInfo();
        voGeneratorInfo.setFields(voFields);
        dataModelBaseDTO.setVoGeneratorInfo(voGeneratorInfo);
        boolean enableSwaggerRender = formDesignProperties.isEnableSwaggerRender();
        if (enableSwaggerRender) {
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.Api");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiOperation");
            dataModelBaseDTO.addControllerImport("io.swagger.annotations.ApiParam");
        }
        dataModelBaseDTO.setEnableSwaggerRender(enableSwaggerRender);
    }

    public static Map<String, String> getImportInfo(Map<String, String> packageInfo, MysqlDataModelBaseDTO dataModelDto) {
        HashMap<String, String> importInfo = new HashMap<String, String>();
        importInfo.put("Entity", packageInfo.get("Entity") + "." + dataModelDto.getEntityName());
        importInfo.put("Mapper", packageInfo.get("Mapper") + "." + dataModelDto.getMapperName());
        importInfo.put("Xml", packageInfo.get("Xml") + "." + dataModelDto.getXmlName());
        importInfo.put("Service", packageInfo.get("Service") + "." + dataModelDto.getServiceName());
        importInfo.put("ServiceImpl", packageInfo.get("ServiceImpl") + "." + dataModelDto.getServiceImplName());
        importInfo.put("Controller", packageInfo.get("Controller") + "." + dataModelDto.getControllerName());
        importInfo.put("dict", packageInfo.get("dict") + "." + dataModelDto.getDictName());
        importInfo.put("dto", packageInfo.get("dto") + "." + dataModelDto.getEntityName() + "Qo");
        importInfo.put("VO", packageInfo.get("VO") + "." + dataModelDto.getVoName());
        return importInfo;
    }
}

