/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLTASKTableSave")
public class MysqlTaskTableSaveVisitor
implements MysqlOperationVisitor<MysqlTaskDataModel, MysqlTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlTaskTableSaveVisitor.class);
    public static final String OPERATION_NAME = "MYSQLTASKTableSave";

    @Override
    public void visit(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> taskBackCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        MysqlFlowDataModelDTO dataModelBaseDTO = (MysqlFlowDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        MysqlFlowDataModel useDataModelBase = (MysqlFlowDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx = new MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO>();
        backCtx.setUseDataModelBase(useDataModelBase);
        HashMap<String, MysqlFlowDataModelDTO> map = new HashMap<String, MysqlFlowDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        MysqlDataModelFieldDto keyField = dataModelBaseDTO.getKeyField();
        if (keyField == null) {
            logger.error("\u5f53\u524d\u6a21\u578b\u6ca1\u6709\u4e3b\u952e");
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        controllerParams.put("primaryField", keyField.getCapitalName());
        String controllerPath = "template/backcode/tableSave/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/backcode/tableSave/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        if (useDataModelBase.getLogicallyDelete()) {
            controllerParams.put("logicallyDelete", true);
            String logicallyFieldName = useDataModelBase.getDeleteFlag().getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("logicallyFlag", String.valueOf(chars));
        }
        String serviceImplPath = "template/taskbackcode/basetaskbackcode/tableSave/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6570\u636e\u8868\u683c\u5bfc\u5165");
        backCtx.addApi(modelId, MysqlBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, String modelId, MysqlFlowDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSONObject");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "java.time.LocalDateTime");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.core.util.ToolUtil");
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlFlowDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        List<MysqlDataModelFieldDto> businessFields = dataModelBaseDTO.getFields();
        for (MysqlDataModelFieldDto businessField : businessFields) {
            if (!ToolUtil.isNotEmpty((Object)businessField.getFill())) continue;
            if ("createTime".equals(businessField.getFill())) {
                controllerParams.put("createTime", businessField.getCapitalName());
            }
            if (!"createUser".equals(businessField.getFill())) continue;
            controllerParams.put("createUser", businessField.getCapitalName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u5bfc\u5165");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }
}

