/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlBaseRender;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLMASTER_SLAVETotalCalculate")
public class MysqlMsTotalCalculateVisitor
implements MysqlOperationVisitor<MysqlMsDataModel, MysqlMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsTotalCalculateVisitor.class);
    public static final String OPERATION_NAME = "MYSQLMASTER_SLAVETotalCalculate";

    @Override
    public void visit(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        MysqlMsDataModel mysqlBaseDataModel = backCtx.getUseDataModelBase();
        String modelId = mysqlBaseDataModel.getId();
        MysqlMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        boolean isLogicallyDelete = backCtx.getUseDataModelBase().isLogicallyDelete();
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, mysqlBaseDataModel);
        if (isLogicallyDelete) {
            String logicallyFlag = backCtx.getUseDataModelBase().getModelAliasName().get(backCtx.getUseDataModelBase().getMasterTable().getId()) + "." + backCtx.getUseDataModelBase().getDeleteFlag().getSourceFieldName();
            controllerParams.put("logicallyFlag", logicallyFlag);
        }
        this.renderTotalCalculate(backCtx, modelId, dataModelBaseDTO, controllerParams);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/masterslavebackcode/totalCalculate/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/masterslavebackcode/totalCalculate/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/masterslavebackcode/totalCalculate/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/masterslavebackcode/totalCalculate/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/masterslavebackcode/totalCalculate/xml.ftl";
        for (MysqlDataModelField mysqlDataModelField : mysqlBaseDataModel.getFields()) {
            mysqlDataModelField.setTableAlias(backCtx.getUseDataModelBase().getModelAliasName().get(mysqlDataModelField.getSourceDataModelId()));
        }
        String finalRelation = SqlReturnUtil.renderTotalCalculateRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap(), controllerParams);
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, String modelId, MysqlMsDataModelDTO dataModelBaseDTO) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (backCtx.getUseDataModelBase().isLogicallyDelete()) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "java.util.Map");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlMsDataModelDTO dataModelBaseDTO, MysqlMsDataModel mysqlBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("isSelectCondition", Boolean.FALSE);
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        boolean isLogicallyDelete = mysqlBaseDataModel.isLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            MysqlDataModelField logicallyField = mysqlBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
            controllerParams.put("deleteFlagName", logicallyField.getSourceFieldName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u603b\u8ba1\u6570\u636e");
            } else {
                dataModelOperation.setExegesis("\u603b\u8ba1\u6570\u636e");
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderTotalCalculate(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, String modelId, MysqlMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        MysqlQueryDTO totalQuery = MysqlDataModelUtil.getTotalQueryDto(dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(totalQuery);
        controllerParams.put("QueryObj", totalQuery.getEntityName());
        controllerParams.put("queryObj", totalQuery.getName());
        String importInfo = totalQuery.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderPageVo(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, String modelId, MysqlMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        MysqlDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

