/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.base;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryConditionField;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLBASEDataDisplay")
public class MysqlDataDisplayVisitor
implements MysqlOperationVisitor<MysqlBaseDataModel, MysqlBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlDataDisplayVisitor.class);
    public static final String OPERATION_NAME = "MYSQLBASEDataDisplay";

    @Override
    public void visit(MysqlBackCtx<MysqlBaseDataModel, MysqlBaseDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        MysqlBaseDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String modelId = useDataModelBase.getId();
        MysqlBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, useDataModelBase);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, useDataModelBase, dataModelBaseDTO, controllerParams);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        String relateFieldName = String.valueOf(controllerParams.get("relateField"));
        String relateField = dataModelBaseDTO.getFieldCapitalName(relateFieldName);
        List<MysqlDataModelFieldDto> fields = dataModelBaseDTO.getFields();
        for (MysqlDataModelFieldDto field : fields) {
            if (!relateFieldName.equals(field.getPropertyName())) continue;
            controllerParams.put("fieldType", field.getType());
        }
        String controllerPath = "template/backcode/datadisplay/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isSelectCondition);
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/backcode/datadisplay/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/backcode/datadisplay/service_impl.ftl";
        controllerParams.put("capitalRelateField", relateField);
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
            String mapperPath = "template/backcode/datadisplay/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/backcode/datadisplay/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", isSelectCondition ? "postJson" : "postForm", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u6570\u636e\u5c55\u793a");
        backCtx.addApi(modelId, MysqlBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(MysqlBackCtx<MysqlBaseDataModel, MysqlBaseDataModelDTO> backCtx, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, boolean isSelectCondition) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "java.util.Arrays");
            backCtx.addMapperImport(modelId, "java.util.List");
            backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        } else {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
            backCtx.addControllerImport(modelId, "java.util.Arrays");
            backCtx.addServiceImport(modelId, "java.util.List");
        }
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlBaseDataModelDTO dataModelBaseDTO, MysqlBaseDataModel mysqlBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        boolean isLogicallyDelete = mysqlBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            MysqlDataModelField logicallyField = mysqlBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u6570\u636e\u5c55\u793a");
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelect(MysqlBackCtx<MysqlBaseDataModel, MysqlBaseDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, MysqlBaseDataModel useDataModelBase, MysqlBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        String inValuesSql = this.getInValuesSql(dataModelBaseDTO, dataModelOperation);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            MysqlQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
            ArrayList<String> likeQueryFields = new ArrayList<String>();
            for (MysqlQueryConditionField queryConditionField : queryCondition.getFields()) {
                String symbol = queryConditionField.getSymbol();
                if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
                likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
            }
            controllerParams.put("likeQueryFields", likeQueryFields);
            if (Optional.ofNullable(queryCondition).map(MysqlQueryCondition::getFields).isPresent() && !queryCondition.getFields().isEmpty()) {
                DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
                if (useDataModelBase.getLogicallyDelete()) {
                    QueryConditionUtil.addLogicallyFlag(queryCondition, useDataModelBase.getDeleteFlag().getName(), useDataModelBase.getId());
                }
                MysqlQueryDTO queryDTO = MysqlDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
                dataModelBaseDTO.addQueryDto(queryDTO);
                String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>(), useDataModelBase.getDeleteFlag() == null ? "" : useDataModelBase.getDeleteFlag().getSourceFieldName());
                if (useDataModelBase.getLogicallyDelete()) {
                    QueryConditionUtil.deleteLogicallyFlag(queryCondition);
                }
                controllerParams.put("QueryObj", queryDTO.getEntityName());
                controllerParams.put("queryObj", queryDTO.getName());
                controllerParams.put("whereSql", finalWhereSql);
                isSelectCondition = true;
                controllerParams.put("isSelectCondition", true);
                String importInfo = queryDTO.getImportInfo();
                backCtx.addControllerImport(modelId, importInfo);
                backCtx.addServiceImport(modelId, importInfo);
                backCtx.addServiceImplImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, importInfo);
                backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            }
        }
        return isSelectCondition;
    }

    private void renderPageVo(MysqlBackCtx<MysqlBaseDataModel, MysqlBaseDataModelDTO> backCtx, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        MysqlDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private String getInValuesSql(MysqlBaseDataModelDTO dataModelBaseDTO, MysqlDataModelOperation dataModelOperation) {
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>\n";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        String fieldBaseName = dataModelBaseDTO.getFieldBaseName(entityAttr);
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{fieldBaseName})) {
            return template.replace("${T_ALIAS}", "t").replace("${REAL_FIELD}", fieldBaseName);
        }
        return "";
    }
}

