/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.util;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlModelFunction;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslate;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslateCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslateField;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlPublicEnclosure;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MysqlTranslateUtil {
    public static void translateMsEnclosure(List<MysqlTranslate> translates, MysqlMsDataModel dataModelBase, MysqlDataModelBaseDTO dataModelBaseDTO) throws LcdpException {
        if (ToolUtil.isNotEmpty(translates)) {
            List<Map<String, Object>> translateAnnotations;
            ArrayList<DataModelFieldBase> rightFields = new ArrayList<DataModelFieldBase>();
            rightFields.addAll(dataModelBase.getMasterTable().getFields());
            if (ToolUtil.isNotEmpty(dataModelBase.getSlaveTables())) {
                List<MysqlDataModelBase> slaveTables = dataModelBase.getSlaveTables();
                for (MysqlDataModelBase slaveTable : slaveTables) {
                    rightFields.addAll(slaveTable.getFields());
                }
            }
            if (ToolUtil.isNotEmpty(translateAnnotations = MysqlTranslateUtil.translate(translates, rightFields))) {
                List<MysqlDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                List<MysqlDataModelFieldDto> voFields = dataModelBaseDTO.getVoGeneratorInfo().getFields();
                MysqlTranslateUtil.setFieldAnnotations(translateAnnotations, fields);
                MysqlTranslateUtil.setFieldAnnotations(translateAnnotations, voFields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<MysqlDataModelFieldDto> translateShowFields = MysqlTranslateUtil.getTranslateShowFields(translates);
            for (MysqlDataModelFieldDto translateShowField : translateShowFields) {
                if (null == translateShowField.getColumnType() || null == translateShowField.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(translateShowField.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
    }

    private static void setFieldAnnotations(List<Map<String, Object>> translateAnnotations, List<MysqlDataModelFieldDto> fields) {
        block0: for (Map<String, Object> translateAnnotation : translateAnnotations) {
            if (!ToolUtil.isNotEmpty(translateAnnotation) || !ToolUtil.isNotEmpty((Object)translateAnnotation.get("fieldId"))) continue;
            for (MysqlDataModelFieldDto field : fields) {
                if (!field.getId().equals(translateAnnotation.get("fieldId").toString())) continue;
                field.setFieldAnnotation(translateAnnotation.get("fieldAnnotation").toString());
                continue block0;
            }
        }
    }

    public static List<MysqlDataModelFieldDto> getTranslateShowFields(List<MysqlTranslate> translateConfigs) {
        ArrayList<MysqlDataModelFieldDto> showFields = new ArrayList<MysqlDataModelFieldDto>();
        for (MysqlTranslate translateConfig : translateConfigs) {
            if (!ToolUtil.isNotEmpty(translateConfig.getTranslateFields())) continue;
            List<MysqlTranslateField> translateFields = translateConfig.getTranslateFields();
            for (MysqlTranslateField translateField : translateFields) {
                if (!ToolUtil.isNotEmpty((Object)translateField) || !ToolUtil.isNotEmpty((Object)translateField.getName())) continue;
                MysqlDataModelFieldDto dataModelFieldDto = new MysqlDataModelFieldDto();
                dataModelFieldDto.setId(translateField.getId());
                dataModelFieldDto.setPropertyName(translateField.getName());
                dataModelFieldDto.setComment(translateField.getComment());
                dataModelFieldDto.setType(translateField.getDataType());
                dataModelFieldDto.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)translateField.getDataType()));
                showFields.add(dataModelFieldDto);
            }
        }
        return showFields;
    }

    public static List<Map<String, Object>> translate(List<MysqlTranslate> translateConfigs, List<DataModelFieldBase> rightFields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (ToolUtil.isNotEmpty(translateConfigs)) {
            for (MysqlTranslate translate : translateConfigs) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (ToolUtil.isNotEmpty((Object)translate.getSourceFieldId()) && ToolUtil.isNotEmpty((Object)translate.getTranslateType())) {
                    map.put("fieldId", translate.getSourceFieldId());
                    switch (translate.getTranslateType()) {
                        case "dictTranslate": {
                            map.put("fieldAnnotation", MysqlTranslateUtil.dictTranslate(translate));
                            break;
                        }
                        case "userTranslate": {
                            map.put("fieldAnnotation", MysqlTranslateUtil.userTranslate(translate));
                            break;
                        }
                        case "organTranslate": {
                            map.put("fieldAnnotation", MysqlTranslateUtil.organTranslate(translate));
                            break;
                        }
                        case "modelTranslate": {
                            map.put("fieldAnnotation", MysqlTranslateUtil.modelTranslate(translate, rightFields));
                            break;
                        }
                    }
                }
                list.add(map);
            }
        }
        return list;
    }

    private static String dictTranslate(MysqlTranslate translate) {
        List<MysqlTranslateField> translateFields = translate.getTranslateFields();
        String label = translateFields.get(0).getName();
        String key = translate.getSourceId();
        String annotation = "@Trans(type = TransType.FIELD_TRANS, queryFields = { \"value\", \"type\" }, namespace = \"TranslateDict\", key = \"" + key + "\", ref = \"";
        annotation = annotation + label + "#label#\")";
        return annotation;
    }

    private static String userTranslate(MysqlTranslate translate) {
        List<MysqlTranslateField> translateFields = translate.getTranslateFields();
        String annotation = "@Trans(type = TransType.ID_TRANS, namespace = \"TranslateUser\", refs = {";
        String refs = "";
        for (int i = 0; i < translateFields.size(); ++i) {
            if (i == translateFields.size() - 1) {
                refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\"} )";
                break;
            }
            refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\",";
        }
        annotation = annotation + refs;
        return annotation;
    }

    private static String organTranslate(MysqlTranslate translate) {
        List<MysqlTranslateField> translateFields = translate.getTranslateFields();
        String annotation = "@Trans(type = TransType.ID_TRANS, namespace = \"TranslateOrganization\", refs = {";
        String refs = "";
        for (int i = 0; i < translateFields.size(); ++i) {
            if (i == translateFields.size() - 1) {
                refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\"} )";
                break;
            }
            refs = refs + " \"" + translateFields.get(i).getName() + "#" + translateFields.get(i).getTranslateSource() + "\",";
        }
        annotation = annotation + refs;
        return annotation;
    }

    private static String modelTranslate(MysqlTranslate translate, List<DataModelFieldBase> rightFields) {
        String sourceId = translate.getSourceId();
        try {
            DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)sourceId);
            MysqlModelFunction currentFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
            MysqlDataModelBase currentModelBase = MysqlDataModelUtil.transfer(dataModelBase);
            MysqlDataModelBaseDTO dataModelDto = new MysqlDataModelBaseDTO();
            MysqlPublicEnclosure.enclosure(currentModelBase, dataModelDto);
            String modulePath = dataModelDto.getTablePath().toLowerCase();
            String namespace = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
            if ("TASK".equals(dataModelBase.getFunctionType()) || "TASK_MASTER_SLAVE".equals(dataModelBase.getFunctionType())) {
                namespace = DataModelUtil.getQualifyBeanName((String)(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelDto.getName() + "Task"), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "ServiceImpl"), (String)modulePath);
            }
            List<MysqlDataModelFieldDto> leftFields = dataModelDto.getFields();
            List<MysqlTranslateCondition> dataModelCondition = translate.getDataModelCondition();
            ArrayList<String> queryFields = new ArrayList<String>();
            ArrayList<String> keyRefs = new ArrayList<String>();
            String queryField = "";
            String keyRef = "";
            if (ToolUtil.isNotEmpty(dataModelCondition)) {
                for (MysqlTranslateCondition translateCondition : dataModelCondition) {
                    String goalsRowId = translateCondition.getGoalsRowId();
                    String fromModelField = translateCondition.getFromModelField();
                    if (!ToolUtil.isNotEmpty((Object)goalsRowId) || !ToolUtil.isNotEmpty((Object)fromModelField)) continue;
                    MysqlDataModelFieldDto leftDataModelFieldDto = leftFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)goalsRowId)).findFirst().orElseGet(MysqlDataModelFieldDto::new);
                    queryFields.add(leftDataModelFieldDto.getPropertyName());
                    DataModelFieldBase dataModelFieldBase = rightFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)fromModelField)).findFirst().orElseGet(DataModelFieldBase::new);
                    keyRefs.add(dataModelFieldBase.getName());
                }
                if (queryFields.size() > 1) {
                    for (int i = 0; i < queryFields.size(); ++i) {
                        if (i == 0) {
                            queryField = queryField + "{ \"" + (String)queryFields.get(i) + "\",";
                            continue;
                        }
                        if (i == queryFields.size() - 1) {
                            queryField = queryField + " \"" + (String)queryFields.get(i) + "\" }";
                            break;
                        }
                        queryField = queryField + " \"" + (String)queryFields.get(i) + "\",";
                    }
                } else {
                    queryField = "{ \"" + (String)queryFields.get(0) + "\" }";
                }
                if (keyRefs.size() > 2) {
                    for (int i = 1; i < keyRefs.size(); ++i) {
                        if (i == 1) {
                            keyRef = keyRef + "keyRef = { \"" + (String)keyRefs.get(i) + "\",";
                            continue;
                        }
                        if (i == keyRefs.size() - 1) {
                            keyRef = keyRef + " \"" + (String)keyRefs.get(i) + "\" },";
                            break;
                        }
                        keyRef = keyRef + " \"" + (String)keyRefs.get(i) + "\",";
                    }
                } else {
                    keyRef = keyRefs.size() == 2 ? "keyRef = { \"" + (String)keyRefs.get(1) + "\" }," : "";
                }
            }
            List<MysqlTranslateField> translateFields = translate.getTranslateFields();
            ArrayList<String> refs = new ArrayList<String>();
            if (ToolUtil.isNotEmpty(translateFields)) {
                for (MysqlTranslateField translateField : translateFields) {
                    String rightTranslateSource = translateField.getTranslateSource();
                    if (!ToolUtil.isNotEmpty((Object)rightTranslateSource)) continue;
                    MysqlDataModelFieldDto rightDataModelFieldDto = leftFields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)rightTranslateSource)).findFirst().orElseGet(MysqlDataModelFieldDto::new);
                    refs.add(translateField.getName() + "#" + rightDataModelFieldDto.getPropertyName());
                }
            }
            String ref = "";
            if (refs.size() > 1) {
                for (int i = 0; i < refs.size(); ++i) {
                    if (i == 0) {
                        ref = ref + "{ \"" + (String)refs.get(i) + "\",";
                        continue;
                    }
                    if (i == refs.size() - 1) {
                        ref = ref + " \"" + (String)refs.get(i) + "\" }";
                        break;
                    }
                    ref = ref + " \"" + (String)refs.get(i) + "\",";
                }
            } else {
                ref = "{ \"" + (String)refs.get(0) + "\" }";
            }
            String annotation = "@Trans(type = TransType.FIELD_TRANS, queryFields = ";
            annotation = annotation + queryField + ", namespace = \"" + namespace + "\", " + keyRef + " refs = " + ref + " )";
            return annotation;
        }
        catch (LcdpException | CloneNotSupportedException e) {
            throw new HussarException();
        }
    }
}

