/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.element.flow;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MysqlFlowMsDataModel
extends MysqlMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(MysqlFlowMsDataModel.class);
    public static final String FUNCTION_TYPE = "FLOW_MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<MysqlDataModelField> flowFields;

    public List<MysqlDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<MysqlDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"MYSQL.FLOW_MASTER_SLAVE", MysqlFlowMsDataModel.class);
    }

    @Override
    public MysqlFlowMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        MysqlFlowMsDataModel mysqlFlowMsDataModel;
        try {
            ArrayList<MysqlDataModelField> fieldList = new ArrayList<MysqlDataModelField>();
            mysqlFlowMsDataModel = (MysqlFlowMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), MysqlFlowMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                MysqlDataModelBase master = MysqlDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(mysqlFlowMsDataModel.getName() + "Master");
                mysqlFlowMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<MysqlDataModelBase> slaveTables = new ArrayList<MysqlDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    MysqlDataModelBase slaveTable = MysqlDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (MysqlRelationshipBase relationship : mysqlFlowMsDataModel.getRelationships()) {
                    MysqlDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(MysqlBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    MysqlDataModelField mysqlDataModelField = new MysqlDataModelField();
                    mysqlDataModelField.setId(dataModelBase.getId());
                    mysqlDataModelField.setName(dataModelBase.getName());
                    mysqlDataModelField.setComment(dataModelBase.getComment());
                    mysqlDataModelField.setSourceDataModelId(dataModelBase.getId());
                    mysqlDataModelField.setDataType("array");
                    fieldList.add(mysqlDataModelField);
                }
                mysqlFlowMsDataModel.setSlaveTables(slaveTables);
            }
            mysqlFlowMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return mysqlFlowMsDataModel;
    }

    @Override
    public MysqlEnclosure<MysqlDataModelBase> enclosure() throws LcdpException {
        return MysqlModelBeanUtil.getEnclosureBean("MYSQL", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public MysqlRender<MysqlDataModelBase, MysqlDataModelBaseDTO> render() throws LcdpException {
        return MysqlModelBeanUtil.getRenderBean("MYSQL", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<MysqlDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<MysqlDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<MysqlDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.modelContrastTable((FieldsContrastParam<MysqlDataModelField>)fieldsContrastParam);
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        return super.checkTableContrast(modelId);
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        return super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

