/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlBaseRender;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.constant.MysqlConstUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.masterslave.MysqlMsConditionFilterVisitor;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLFLOW_MASTER_SLAVESlaveQuery")
public class MysqlMsFlowSlavePlusQueryVisitor
implements MysqlOperationVisitor<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsConditionFilterVisitor.class);
    public static final String OPERATION_NAME = "MYSQLFLOW_MASTER_SLAVESlaveQuery";

    @Override
    public void visit(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        if (HussarUtils.isEmpty((Object)slaveModelId)) {
            return;
        }
        String modelId = backCtx.getUseDataModelBase().getId();
        MysqlMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, MysqlDataModelBaseDTO> dataModelDtoMap = dataModelBaseDTO.getDataModelDtoMap();
        if (ToolUtil.isNotEmpty(dataModelDtoMap) && ToolUtil.isEmpty((Object)dataModelDtoMap.get(slaveModelId))) {
            return;
        }
        for (SourcePackageInfo sourcePackageInfo : dataModelBaseDTO.getSourcePackageInfos()) {
            if (!"object".equals(sourcePackageInfo.getDataType()) || !dataModelBaseDTO.getDataModelDtoMap().get(slaveModelId).getName().equals(sourcePackageInfo.getObjectEnName())) continue;
            return;
        }
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, backCtx.getUseDataModelBase(), backCtx);
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, backCtx.getUseDataModelBase());
        boolean isSortOverall = false;
        boolean isPagination = (Boolean)dataModelOperation.getParams().get("isPagination");
        this.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO);
        controllerParams.put("isSortOverall", isSortOverall);
        controllerParams.put("isPagination", isPagination);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams, dataModelOperation);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/masterslavebackcode/slavePlusQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/masterslavebackcode/slavePlusQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/masterslavebackcode/slavePlusQuery/service_impl.ftl";
        controllerParams.put("operationName", controllerParams.get("name"));
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/masterslavebackcode/slavePlusQuery/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/masterslavebackcode/slavePlusQuery/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isSortCondition);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u5b50\u8868\u5206\u9875\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, String modelId, MysqlMsDataModelDTO dataModelBaseDTO, boolean isSortCondition) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlMsDataModelDTO dataModelBaseDTO, MysqlMsDataModel msDataModel, MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        String modelId = backCtx.getUseDataModelBase().getId();
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        String slaveModelName = NamingStrategy.capitalFirst((String)String.valueOf(dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getName()));
        String aliasName = msDataModel.getModelAliasName().get(slaveModelId);
        for (MysqlDataModelField mysqlDataModelField : dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getFields()) {
            if ("foreign".equals(mysqlDataModelField.getUsage())) {
                controllerParams.put("foreignKey", mysqlDataModelField.getName());
            }
            if (!"relationTag".equals(mysqlDataModelField.getUsage())) continue;
            controllerParams.put("relationTagKey", mysqlDataModelField.getName());
            controllerParams.put("relationTagValue", dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getName());
        }
        for (MysqlDataModelFieldDto mysqlDataModelFieldDto : dataModelBaseDTO.getDataModelDtoMap().get(slaveModelId).getFields()) {
            if (!"delDefFlag".equals(mysqlDataModelFieldDto.getFill())) continue;
            controllerParams.put("flagDelete", mysqlDataModelFieldDto.getPropertyName());
            break;
        }
        controllerParams.put("slaveModelName", slaveModelName);
        controllerParams.put("aliasName", aliasName);
        controllerParams.put("tableSql", dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId));
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("slaveTable", dataModelBaseDTO.getDataModelDtoMap().get(slaveModelId));
        controllerParams.put("returnValue", slaveModelName);
        controllerParams.put("masterSlave", dataModelBaseDTO.getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u5b50\u8868\u5206\u9875\u67e5\u8be2");
                controllerParams.put("exegesis1", dataModelBaseDTO.getComment() + "\u5b50\u8868\u5206\u9875\u67e5\u8be2(\u5206\u9875)");
                controllerParams.put("exegesis2", dataModelBaseDTO.getComment() + "\u5b50\u8868\u5206\u9875\u67e5\u8be2(\u4e0d\u5206\u9875)");
            } else {
                dataModelOperation.setExegesis("\u5b50\u8868\u5206\u9875\u67e5\u8be2");
                controllerParams.put("exegesis1", "\u5b50\u8868\u5206\u9875\u67e5\u8be2(\u5206\u9875)");
                controllerParams.put("exegesis2", "\u5b50\u8868\u5206\u9875\u67e5\u8be2(\u4e0d\u5206\u9875)");
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getDataModelDtoMap().get(slaveModelId).getImportInfo().get("Entity"));
        return controllerParams;
    }

    private void renderSelect(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, MysqlMsDataModelDTO dataModelBaseDTO) {
        String queryConditionName = dataModelOperation.getEnterParam();
        ArrayList queryFieldsList = new ArrayList();
        MysqlQueryDTO queryDTO = new MysqlQueryDTO();
        queryDTO.setFtlPath("template/backcode/code/slaveDto.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("table", table);
        MysqlQueryCondition queryConditionSql = new MysqlQueryCondition();
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        if (StringUtil.isNotBlank((CharSequence)selectConditionName)) {
            List queryCondition = backCtx.getUseDataModelBase().getDataSetById(queryConditionName).getDataSetObject().getProperties();
            for (ValueObjectProperty property : queryCondition) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("queryType", property.getDataType());
                map.put("queryName", property.getName());
                queryFieldsList.add(map);
            }
            queryConditionSql = backCtx.getUseDataModelBase().getQuConBaseByName(selectConditionName);
        }
        params.put("queryFieldsList", queryFieldsList);
        params.put("queryDto", queryDTO);
        params.put("priType", dataModelBaseDTO.getKeyField().getPropertyType());
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        String slaveModelName = String.valueOf(dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getName());
        String slaveDtoImportPath = dataModelBaseDTO.getPackageInfo().get("dto") + "." + NamingStrategy.capitalFirst((String)slaveModelName) + "IncrementDTO";
        queryDTO.setParams(params);
        queryDTO.setName(slaveModelName + "IncrementDTO");
        queryDTO.setEntityName(NamingStrategy.capitalFirst((String)slaveModelName) + "IncrementDTO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        DataSet dataSet = backCtx.getUseDataModelBase().getDataSetById(queryConditionSql.getFromDataSet());
        if (ToolUtil.isNotEmpty((Object)dataSet)) {
            List<MysqlQueryFieldDTO> queryVOFields = MysqlDataModelUtil.addQueryVOField(dataSet.getDataSetObject().getProperties(), queryDTO);
            for (MysqlQueryFieldDTO queryVOField : queryVOFields) {
                queryDTO.addVOField(queryVOField);
            }
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addControllerImport(modelId, slaveDtoImportPath);
        backCtx.addServiceImplImport(modelId, slaveDtoImportPath);
        backCtx.addServiceImport(modelId, slaveDtoImportPath);
        backCtx.addMapperImport(modelId, slaveDtoImportPath);
    }

    private boolean renderSort(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, MysqlMsDataModel useDataModelBase) {
        MysqlSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && HussarUtils.isNotEmpty((Object)(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName))) && Optional.of(sortCondition).map(MysqlSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            for (MysqlSortConditionField field : sortCondition.getFields()) {
                field.setFromModelFieldSort(MysqlDataModelUtil.camelToUnderLine(field.getFromModelFieldSort()));
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", MysqlConstUtil.TRUE);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private void renderPageVo(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, String modelId, MysqlMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams, MysqlDataModelOperation dataModelOperation) {
        MysqlDataModelUtil.addSlaveQueryPageVo(dataModelBaseDTO, dataModelOperation);
        String slaveVoEntityName = dataModelBaseDTO.getEntityName() + "SlavePageVO";
        String slaveVoImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + slaveVoEntityName;
        String slaveModelId = String.valueOf(dataModelOperation.getParams().get("slaveModelId"));
        String slaveModelName = NamingStrategy.capitalFirst((String)String.valueOf(dataModelBaseDTO.getDataModelBaseMap().get(slaveModelId).getName()));
        String slaveModelImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + slaveModelName + "VO";
        String sModelImportPath = dataModelBaseDTO.getPackageInfo().get("Entity") + "." + slaveModelName;
        controllerParams.put("svo", slaveVoEntityName);
        controllerParams.put("svoPath", slaveVoImportPath);
        controllerParams.put("sPath", slaveModelImportPath);
        backCtx.addControllerImport(modelId, slaveVoImportPath);
        backCtx.addServiceImport(modelId, slaveVoImportPath);
        backCtx.addServiceImplImport(modelId, slaveVoImportPath);
        backCtx.addControllerImport(modelId, slaveModelImportPath);
        backCtx.addServiceImport(modelId, slaveModelImportPath);
        backCtx.addServiceImplImport(modelId, slaveModelImportPath);
        backCtx.addMapperImport(modelId, slaveModelImportPath);
        backCtx.addMapperImport(modelId, sModelImportPath);
        backCtx.addServiceImplImport(modelId, sModelImportPath);
    }
}

