/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.MysqlCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlMsRender;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.task.basetask.util.MysqlTaskBaseUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataSourceUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLTASKRENDER")
public class MysqlTaskRender
implements MysqlRender<MysqlTaskDataModel, MysqlTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsRender.class);
    public static final String RENDER = "MYSQLTASKRENDER";

    @Override
    public List<MysqlCodeGenerateInfo> renderCode(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> backCtx) throws LcdpException, IOException, CloneNotSupportedException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<MysqlCodeGenerateInfo> mysqlCodeGenerateInfos = new ArrayList<MysqlCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        MysqlTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        backCtx.addParam(String.format("publishTemplateDto_%s", modelId), useDataModelDTO.getPublishTemplateDto());
        Map<String, MysqlDataModelBase> dataModelBaseMap = useDataModelDTO.getDataModelBaseMap();
        Map<String, MysqlDataModelBaseDTO> dataModelDtoMap = useDataModelDTO.getDataModelDtoMap();
        if (ToolUtil.isNotEmpty(dataModelBaseMap)) {
            for (String string : dataModelBaseMap.keySet()) {
                List<MysqlCodeGenerateInfo> childGenerators;
                MysqlBackCtx mysqlBackCtx = new MysqlBackCtx();
                MysqlDataModelBase mysqlDataModelBase = dataModelBaseMap.get(string);
                MysqlDataModelBaseDTO mysqlDataModelBaseDTO = dataModelDtoMap.get(string);
                HashMap<String, MysqlDataModelBaseDTO> map = new HashMap<String, MysqlDataModelBaseDTO>();
                map.put(string, mysqlDataModelBaseDTO);
                mysqlBackCtx.setBaseFile(baseFile);
                mysqlBackCtx.setUseDataModelBase(mysqlDataModelBase);
                mysqlBackCtx.setUseDataModelDtoMap(map);
                mysqlBackCtx.setModelFunctionTye(mysqlDataModelBase.getFunctionType());
                if (HussarUtils.equals((Object)string, (Object)modelId)) {
                    MysqlTaskBaseUtil.transferControllerCode(mysqlDataModelBaseDTO, useDataModelDTO);
                }
                if (!ToolUtil.isNotEmpty(childGenerators = MysqlModelBeanUtil.getFunctionModelVisitorBean(mysqlBackCtx.getUseDataModelBase().getFunctionType()).render().renderCode(mysqlBackCtx))) continue;
                for (MysqlCodeGenerateInfo childGenerator : childGenerators) {
                    if ("controller".equals(childGenerator.getFileType()) || "js".equals(childGenerator.getFileType())) continue;
                    mysqlCodeGenerateInfos.add(childGenerator);
                }
            }
        }
        mysqlCodeGenerateInfos.add(this.genEntityCode(useDataModelDTO));
        mysqlCodeGenerateInfos.add(this.genVoCode(useDataModelDTO));
        mysqlCodeGenerateInfos.add(this.genControllerCode(useDataModelDTO));
        mysqlCodeGenerateInfos.add(this.genServiceCode(useDataModelDTO));
        mysqlCodeGenerateInfos.add(this.genServiceImplCode(useDataModelDTO));
        mysqlCodeGenerateInfos.add(this.genMapperCode(useDataModelDTO));
        mysqlCodeGenerateInfos.add(this.genXmlCode(useDataModelDTO));
        mysqlCodeGenerateInfos.add(this.genApiCode(useDataModelDTO, baseFile));
        Map<String, MysqlQueryDTO> queryDtoMap = useDataModelDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            for (Map.Entry<String, MysqlQueryDTO> entry : queryDtoMap.entrySet()) {
                MysqlQueryDTO queryDTO = entry.getValue();
                MysqlCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, useDataModelDTO);
                if (null == queryCodeGenerateInfo) continue;
                mysqlCodeGenerateInfos.add(queryCodeGenerateInfo);
            }
        }
        if (ToolUtil.isNotEmpty(useDataModelDTO.getCustomCodeGenerateInfo()) && ToolUtil.isNotEmpty((Object)((Object)useDataModelDTO.getCustomCodeGenerateInfo().get(modelId)))) {
            mysqlCodeGenerateInfos.add(useDataModelDTO.getCustomCodeGenerateInfo().get(modelId));
        }
        Map<String, AspectGenerateInfo> map = useDataModelDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(useDataModelDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(map)) {
            for (String annotationName : useDataModelDTO.getAnnotationNames()) {
                mysqlCodeGenerateInfos.add(this.genAnnotationCode(useDataModelDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(map.get(map.keySet().stream().filter(key -> HussarUtils.equals((Object)key, (Object)annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                mysqlCodeGenerateInfos.add(this.genAspectCode(useDataModelDTO, annotationName, aspectGenerateInfo));
            }
        }
        return mysqlCodeGenerateInfos;
    }

    private MysqlCodeGenerateInfo genEntityCode(MysqlTaskDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelBaseDTO.getEntityName() + ".java";
        String filePath = "template/taskbackcode/code/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelBaseDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            Set imports = Optional.ofNullable(dataModelBaseDTO.getEntityGenerateInfo().getImports()).orElseGet(HashSet::new);
            imports.add("com.baomidou.mybatisplus.annotation.TableField");
            dataModelBaseDTO.getEntityGenerateInfo().setImports(imports);
        }
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genVoCode(MysqlTaskDataModelDTO dto) throws LcdpException {
        String modulePath = dto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dto.getVoName() + ".java";
        String filePath = "template/taskbackcode/code/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dto.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dto.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dto.setVoGeneratorInfo(info);
        } else {
            dto.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("vo");
        codeGenerateInfo.setFileId(dto.getId());
        codeGenerateInfo.setFileName(dto.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genControllerCode(MysqlTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getControllerGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(dataModelDto.getImportInfo().get("Entity"));
        imports.add(dataModelDto.getImportInfo().get("Service"));
        dataModelDto.getControllerGenerateInfo().setImports(imports);
        String filePath = "template/taskbackcode/code/controller.ftl";
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genServiceCode(MysqlTaskDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "template/taskbackcode/code/service.ftl";
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genServiceImplCode(MysqlTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "template/taskbackcode/code/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(MysqlDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genMapperCode(MysqlTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "template/taskbackcode/code/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genXmlCode(MysqlTaskDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "template/masterslavebackcode/code/xml.ftl";
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genAnnotationCode(MysqlTaskDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "template/taskbackcode/code/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genApiCode(MysqlTaskDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genAspectCode(MysqlTaskDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "/template/taskbackcode/code/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    private MysqlCodeGenerateInfo dynamicModelCode(MysqlQueryDTO queryDTO, MysqlDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private MysqlCodeGenerateInfo genQueryVoCode(MysqlQueryDTO queryVODto, MysqlTaskDataModelDTO dataModelDto, String modulePath, MysqlMsDataModel mysqlMsDataModel) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryVODto)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("queryDto", queryVODto);
            params.put("model", dataModelDto);
            params.put("modelArrayWithPage", mysqlMsDataModel.getOperations().get(0).getReturnValue());
            String writePath = modulePath + File.separator + "qo" + File.separator + this.upperCase(mysqlMsDataModel.getOperations().get(0).getReturnValue()) + ".java";
            String filePath = "template/taskbackcode/code/queryVo.ftl";
            String newCode = RenderUtil.renderTemplate((String)filePath, params);
            MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(this.upperCase(mysqlMsDataModel.getOperations().get(0).getReturnValue()));
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private String upperCase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }
}

