/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.enclosure;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.ResultMapUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipBase;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipFieldBase;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.source.SourceUseItem;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslate;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlPublicEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlTemplateUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component(value="MYSQLFLOW_MASTER_SLAVEENCLOSURE")
public class MysqlFlowMsEnclosure
implements MysqlEnclosure<MysqlFlowMsDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlFlowMsEnclosure.class);
    public static final String ENCLOSURE = "MYSQLFLOW_MASTER_SLAVEENCLOSURE";

    @Override
    public MysqlDataModelBaseDTO enclosure(MysqlFlowMsDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        MysqlFlowMsDataModelDTO dataModelBaseDTO = new MysqlFlowMsDataModelDTO();
        MysqlPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        List<MysqlDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        HashMap<String, MysqlDataModelBaseDTO> dataModelDtoMap = new HashMap<String, MysqlDataModelBaseDTO>(slaveTables.size() + 1);
        HashMap<String, MysqlDataModelBase> dataModelBaseMap = new HashMap<String, MysqlDataModelBase>(slaveTables.size() + 1);
        MysqlDataModelBase masterTable = dataModelBase.getMasterTable();
        masterTable.setModelPath(dataModelBase.getModelPath());
        MysqlDataModelBaseDTO masterDTO = MysqlModelBeanUtil.getFunctionModelVisitorBean(masterTable.getFunctionType()).enclosure().enclosure(masterTable);
        Map masterPackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
        masterDTO.setPackageInfo(masterPackageInfo);
        masterDTO.setImportInfo(MysqlPublicEnclosure.getImportInfo(masterPackageInfo, masterDTO));
        masterDTO.setTablePath(dataModelBaseDTO.getTablePath());
        dataModelDtoMap.put(masterTable.getId(), masterDTO);
        dataModelBaseMap.put(masterTable.getId(), masterTable);
        List<MysqlTranslate> translates = dataModelBase.getTranslate();
        List<Object> msTranslates = new ArrayList();
        msTranslates = translates;
        ArrayList<String> slaveId = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dataModelBase.getRelationships())) {
            for (MysqlRelationshipBase relationship : dataModelBase.getRelationships()) {
                if (!"collection".equals(relationship.getRelateModelType())) continue;
                slaveId.add(relationship.getSlaveTableId());
            }
        }
        for (MysqlDataModelBase slaveTable : slaveTables) {
            slaveTable.setModelPath(dataModelBase.getModelPath());
            MysqlDataModelBaseDTO slaveDTO = MysqlModelBeanUtil.getFunctionModelVisitorBean(slaveTable.getFunctionType()).enclosure().enclosure(slaveTable);
            if (slaveId.contains(slaveTable.getId())) {
                List<MysqlDataModelField> sFields = slaveTable.getFields();
                ArrayList<MysqlTranslate> slaveTranslates = new ArrayList<MysqlTranslate>();
                if (ToolUtil.isNotEmpty(translates)) {
                    block2: for (MysqlDataModelField field : sFields) {
                        for (MysqlTranslate translate : translates) {
                            if (!translate.getSourceFieldId().equals(field.getId())) continue;
                            slaveTranslates.add(translate);
                            continue block2;
                        }
                    }
                    MysqlTranslateUtil.translateMsEnclosure(slaveTranslates, dataModelBase, slaveDTO);
                    if (ToolUtil.isNotEmpty(slaveDTO.getTranslateShowFields())) {
                        slaveDTO.setHasTranslate(true);
                        dataModelBaseDTO.setHasTranslate(true);
                    }
                    msTranslates.removeAll(slaveTranslates);
                }
            }
            Map slavePackageInfo = EnclosureUtil.getPackageInfo((String)((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).javaPathService().getJavaPath(), (String)dataModelBaseDTO.getModuleName(), (String)dataModelBaseDTO.getName());
            slaveDTO.setPackageInfo(slavePackageInfo);
            slaveDTO.setImportInfo(MysqlPublicEnclosure.getImportInfo(slavePackageInfo, slaveDTO));
            slaveDTO.setTablePath(dataModelBaseDTO.getTablePath());
            dataModelDtoMap.put(slaveTable.getId(), slaveDTO);
            dataModelBaseMap.put(slaveTable.getId(), slaveTable);
        }
        dataModelBaseDTO.setDataModelBaseMap(dataModelBaseMap);
        dataModelBaseDTO.setDataModelDtoMap(dataModelDtoMap);
        dataModelBaseDTO.setResultMapContent(ResultMapUtil.renderResultMap(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        dataModelBaseDTO.setSubSelect(ResultMapUtil.renderSubSelect(dataModelBase, dataModelDtoMap, dataModelBaseMap));
        List<SourcePackageInfo> sourcePackageInfos = this.sourceCodePackage(dataModelBaseDTO, dataModelBase, dataModelDtoMap);
        dataModelBaseDTO.setSourcePackageInfos(sourcePackageInfos);
        this.sourceCodeRelationship(dataModelBaseDTO, dataModelBase);
        List<MysqlDataModelField> dataModelFieldBases = dataModelBase.getFlowFields();
        if (ToolUtil.isEmpty(dataModelFieldBases)) {
            logger.error("MysqlFlowMsEnclosure\u7684enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new MysqlFlowMsDataModelDTO();
        }
        ArrayList<MysqlDataModelFieldDto> tableFields = new ArrayList<MysqlDataModelFieldDto>();
        for (MysqlDataModelField dataModelFieldBase : dataModelFieldBases) {
            MysqlDataModelFieldDto tableField = new MysqlDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        MysqlTranslateUtil.translateMsEnclosure(msTranslates, dataModelBase, dataModelBaseDTO);
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            dataModelBaseDTO.setHasTranslate(true);
        }
        PublishTemplateDto publishTemplateDto = MysqlTemplateUtil.processTemplate(dataModelBase.getId(), slaveTables);
        dataModelBaseDTO.setPublishTemplateDto(publishTemplateDto);
        return dataModelBaseDTO;
    }

    private void sourceCodeRelationship(MysqlFlowMsDataModelDTO dataModelDto, MysqlFlowMsDataModel dataModelBase) throws LcdpException {
        ArrayList<MysqlRelationshipDTO> relationshipDtoList = new ArrayList<MysqlRelationshipDTO>();
        List<MysqlDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        block0: for (MysqlRelationshipBase relationship : dataModelBase.getRelationships()) {
            MysqlRelationshipDTO relationshipDto = new MysqlRelationshipDTO();
            BeanUtils.copyProperties((Object)relationship, (Object)relationshipDto);
            MysqlDataModelBaseDTO masterModelDto = dataModelDto.getTableInfo(relationship.getMasterTableId());
            MysqlDataModelBase masterModel = dataModelBase.getMasterTable();
            MysqlDataModelBaseDTO slaveTableDto = dataModelDto.getTableInfo(relationship.getSlaveTableId());
            relationshipDto.setSlaveTableDto(slaveTableDto);
            MysqlDataModelBase slaveTable = slaveTables.stream().filter(e -> e.getId().equals(relationship.getSlaveTableId())).findFirst().orElse(null);
            if (slaveTable == null) continue;
            relationshipDto.setSlaveTableName(slaveTableDto.getEntityName());
            relationshipDto.setSlaveTableServiceName(slaveTableDto.getServiceEnName());
            ArrayList<MysqlRelationshipFieldDTO> relationshipFieldDtoList = new ArrayList<MysqlRelationshipFieldDTO>();
            for (MysqlRelationshipFieldBase relationshipField : relationship.getRelationships()) {
                MysqlDataModelField slaveTableField;
                MysqlRelationshipFieldDTO relationshipFieldDto = new MysqlRelationshipFieldDTO();
                BeanUtils.copyProperties((Object)relationshipField, (Object)relationshipFieldDto);
                String masterTableFieldId = relationshipField.getMasterTableFieldId();
                String slaveTableFieldId = relationshipField.getSlaveTableFieldId();
                MysqlDataModelField masterTableField = null;
                if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{masterTableFieldId})) {
                    masterTableField = masterModel.getFields().stream().filter(e -> e.getId().equals(masterTableFieldId)).findFirst().orElse(null);
                }
                if ((slaveTableField = (MysqlDataModelField)slaveTable.getFields().stream().filter(e -> e.getId().equals(slaveTableFieldId)).findFirst().orElse(null)) == null) continue block0;
                if (masterTableField != null) {
                    relationshipFieldDto.setMasterFieldCap(masterModelDto.getFieldCapitalName(masterTableField.getName()));
                }
                relationshipFieldDto.setSlaveFieldCap(slaveTableDto.getFieldCapitalName(slaveTableField.getName()));
                relationshipFieldDtoList.add(relationshipFieldDto);
            }
            relationshipDto.setRelationshipDtoList(relationshipFieldDtoList);
            if ("collection".equals(relationshipDto.getRelateModelType())) {
                MysqlDataModelField field = dataModelBase.getFields().stream().filter(fieldBase -> fieldBase.getSourceDataModelId().equals(relationship.getSlaveTableId())).findFirst().orElseThrow(() -> new LcdpException(LcdpExceptionEnum.ERROR, "\u672a\u627e\u5230\u5b50\u8868\u5bf9\u5e94\u4e3b\u5b50\u8868\u4e2d\u7684\u5217"));
                relationshipDto.setSlaveTableAlias(field.getName());
            }
            relationshipDtoList.add(relationshipDto);
        }
        dataModelDto.setRelationshipDtoList(relationshipDtoList);
    }

    private List<SourcePackageInfo> sourceCodePackage(MysqlFlowMsDataModelDTO dataModelDto, MysqlFlowMsDataModel dataModelBase, Map<String, MysqlDataModelBaseDTO> tableInfoMap) {
        List<MysqlDataModelField> dataModelFieldBases = dataModelBase.getFields();
        HashMap<String, SourcePackageInfo> sourcePackageInfoMap = new HashMap<String, SourcePackageInfo>();
        VoGeneratorInfo voGeneratorInfo = dataModelDto.getVoGeneratorInfo();
        voGeneratorInfo.addImport(Serializable.class.getCanonicalName());
        for (MysqlDataModelField dataModelFieldBase : dataModelFieldBases) {
            PropertyType propertyType;
            MysqlDataModelBaseDTO sourceDataModelDto;
            String sourceModelId = dataModelFieldBase.getSourceDataModelId();
            if (!ToolUtil.isNotEmpty((Object)sourceModelId) || !ToolUtil.isNotEmpty((Object)(sourceDataModelDto = tableInfoMap.get(sourceModelId)))) continue;
            if (DataModelFieldTypeConvert.isBaseData((String)dataModelFieldBase.getDataType())) {
                if (ToolUtil.isEmpty(sourcePackageInfoMap.get(sourceModelId))) {
                    SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
                    sourcePackageInfo.setDataType("object");
                    sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
                    sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
                    String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
                    sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
                    dataModelDto.addEntityImport(entityImport);
                }
                SourceUseItem sourceUseItem = new SourceUseItem();
                sourceUseItem.setCurrAttr(dataModelFieldBase.getName());
                MysqlDataModelFieldDto sourceField = sourceDataModelDto.getCertainField(dataModelFieldBase.getSourceFieldName());
                sourceUseItem.setSourceAttrCapitalName(sourceField.getCapitalName());
                ((SourcePackageInfo)sourcePackageInfoMap.get(sourceModelId)).addSourceItem(sourceUseItem);
                continue;
            }
            List<MysqlDataModelFieldDto> dataModelFieldDtoList = dataModelDto.getFields();
            List<MysqlDataModelFieldDto> voFields = voGeneratorInfo.getFields();
            for (MysqlDataModelFieldDto dataModelFieldDto : dataModelFieldDtoList) {
                if (!dataModelFieldDto.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = MysqlDataModelUtil.getEntityPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                dataModelFieldDto.setColumnType(propertyType);
                dataModelDto.addEntityImport(sourceDataModelDto.getImportInfo().get("Entity"));
                dataModelDto.addVoImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            for (MysqlDataModelFieldDto voField : voFields) {
                if (!voField.getPropertyName().equals(dataModelFieldBase.getName()) || !ToolUtil.isNotEmpty((Object)(propertyType = MysqlFlowMsEnclosure.getVoPropertyType(dataModelFieldBase.getDataType(), sourceDataModelDto)))) continue;
                voField.setColumnType(propertyType);
                voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            }
            if (!"array".equals(dataModelFieldBase.getDataType())) continue;
            SourcePackageInfo sourcePackageInfo = new SourcePackageInfo();
            sourcePackageInfo.setDataType("array");
            sourcePackageInfo.setObjectName(sourceDataModelDto.getEntityName());
            sourcePackageInfo.setObjectEnName(sourceDataModelDto.getEName());
            sourcePackageInfo.setQuoteAttr(dataModelFieldBase.getName());
            String entityImport = sourceDataModelDto.getImportInfo().get("Entity");
            sourcePackageInfoMap.put(sourceModelId, sourcePackageInfo);
            dataModelDto.addEntityImport(entityImport);
            dataModelDto.addEntityImport("java.util.List");
            voGeneratorInfo.addImport(sourceDataModelDto.getImportInfo().get("VO"));
            voGeneratorInfo.addImport("java.util.List");
        }
        return new ArrayList<SourcePackageInfo>(sourcePackageInfoMap.values());
    }

    private static PropertyType getVoPropertyType(String type, MysqlDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("VO"));
            String modelName = dataModelDto.getVoName();
            if (type.equals("array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (type.equals("object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }
}

