/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.element.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MysqlTaskMsDataModel
extends MysqlMsDataModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(MysqlTaskMsDataModel.class);
    public static final String FUNCTION_TYPE = "TASK_MASTER_SLAVE";
    public static final String TASK_KEY = "task";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private MysqlBaseDataModel task;
    private List<MysqlDataModelField> flowFields;

    public List<MysqlDataModelField> getFlowFields() {
        return this.flowFields;
    }

    public void setFlowFields(List<MysqlDataModelField> flowFields) {
        this.flowFields = flowFields;
    }

    @Override
    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"MYSQL.TASK_MASTER_SLAVE", MysqlTaskMsDataModel.class);
    }

    public MysqlBaseDataModel getTask() {
        return this.task;
    }

    public void setTask(MysqlBaseDataModel task) {
        this.task = task;
    }

    @Override
    public MysqlTaskMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        MysqlTaskMsDataModel mysqlTaskMsDataModel;
        try {
            ArrayList<MysqlDataModelField> fieldList = new ArrayList<MysqlDataModelField>();
            mysqlTaskMsDataModel = (MysqlTaskMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), MysqlTaskMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                MysqlDataModelBase master = MysqlDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(mysqlTaskMsDataModel.getName() + "Master");
                mysqlTaskMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<MysqlDataModelBase> slaveTables = new ArrayList<MysqlDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    MysqlDataModelBase slaveTable = MysqlDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (MysqlRelationshipBase relationship : mysqlTaskMsDataModel.getRelationships()) {
                    if (relationship.getMasterTableId().equals(mysqlTaskMsDataModel.task.getId())) continue;
                    MysqlDataModelBase dataModelBase = slaveTables.stream().filter(item -> HussarUtils.equals((Object)item.getId(), (Object)relationship.getSlaveTableId())).findFirst().orElseGet(MysqlBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    MysqlDataModelField mysqlDataModelField = new MysqlDataModelField();
                    mysqlDataModelField.setId(dataModelBase.getId());
                    mysqlDataModelField.setName(dataModelBase.getName());
                    mysqlDataModelField.setComment(dataModelBase.getComment());
                    mysqlDataModelField.setSourceDataModelId(dataModelBase.getId());
                    mysqlDataModelField.setDataType("array");
                    fieldList.add(mysqlDataModelField);
                }
                mysqlTaskMsDataModel.setSlaveTables(slaveTables);
            }
            mysqlTaskMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return mysqlTaskMsDataModel;
    }

    @Override
    public MysqlEnclosure<MysqlDataModelBase> enclosure() throws LcdpException {
        return MysqlModelBeanUtil.getEnclosureBean("MYSQL", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public void customOption(MysqlBackCtx<MysqlDataModelBase, MysqlDataModelBaseDTO> backCtx) throws LcdpException {
        MysqlModelBeanUtil.getCustomOperationBean("MYSQL", FUNCTION_TYPE, "CUSTOM_OPTION").publishCustomOption(backCtx);
    }

    @Override
    public MysqlRender<MysqlDataModelBase, MysqlDataModelBaseDTO> render() throws LcdpException {
        return MysqlModelBeanUtil.getRenderBean("MYSQL", FUNCTION_TYPE, "RENDER");
    }

    public List<ContrastVO<MysqlDataModelField>> tableContrastModel(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        return super.tableContrastModel((FieldsContrastParam<MysqlDataModelField>)fieldsContrastParam);
    }

    public List<ContrastVO<MysqlDataModelField>> modelContrastTable(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<MysqlDataModelField>> contrastVOS = this.task.modelContrastTable((FieldsContrastParam<MysqlDataModelField>)fieldsContrastParam);
        contrastVOS.addAll(super.modelContrastTable((FieldsContrastParam<MysqlDataModelField>)fieldsContrastParam));
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> findTableContrast() throws IOException, LcdpException {
        return super.findTableContrast();
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.task.checkTableContrast(modelId).getDetails().get(0));
        details.addAll(super.checkTableContrast(modelId).getDetails());
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        this.task.updateTable(fieldsContrastParam);
        super.updateTable(fieldsContrastParam);
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        return this.task.copyTableByModel(fieldsContrastParam) + super.copyTableByModel(fieldsContrastParam);
    }

    @Override
    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.getMasterTable().getId(), "T2");
        List<MysqlRelationshipBase> relationships = super.getRelationships();
        if (ToolUtil.isNotEmpty(relationships) && !relationships.isEmpty()) {
            for (int i = 0; i < relationships.size(); ++i) {
                MysqlRelationshipBase relationship = relationships.get(i);
                if (relationship.getSlaveTableId().equals(super.getId())) continue;
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        finalMap.put(this.task.getId(), TASK_KEY);
        return finalMap;
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        return super.getSlaveModelInfo();
    }
}

