@Override
<#--有查询条件-->
<#if isSelectCondition?? && isSelectCondition!>
    public ApiResponse<${vo!}> ${name!}(${QueryObj!} ${queryObj!}){
    try {
    ${vo!} ${vo?uncap_first} = new ${vo!}();
    <#if securityLevel??>
        ${queryObj!}.set${securityLevel.capitalName}(BaseSecurityUtil.getUser().getSecurityLevel());
    </#if>
    <#if isPagination?? && isPagination!>
        Page<${returnValue}> pager = new Page<>(${queryObj!}.getCurrent(), ${queryObj!}.getSize());
    <#--        全局排序-->
        <#if isSortOverall?? && isSortOverall!>
            Map<String, String[]> parameterMap = new HashMap<>();
            List<String> orderRule = new ArrayList<>();
            if (${queryObj!}.getOrders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : ${queryObj!}.getOrders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                    }else {
                        order.append(orderItem.getColumn()).append(DESC);
                    }
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }

        </#if>
    <#--    排序条件，分页排序条件加载page对象中,sortConditionObj排序对象-->
        <#if sortConditionObj??>
            <#if isSortOverall?? && isSortOverall!>
                List<String> defaultOrderRule = new ArrayList<>();
                String defaultOrder = "";
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    defaultOrder += "${f.fromModelFieldSort!}" + <#if f.sortCondition == "asc">ASC<#else>DESC</#if>;
                </#list>
                defaultOrderRule.add(defaultOrder);
                parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
            <#else>
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    pager.addOrder(new OrderItem("${f.fromModelFieldSort!}", <#if f.sortCondition == "asc">true<#else>false</#if>));
                </#list>
            </#if>
        </#if>
    <#--        新建一个vo-->
        <#if likeQueryFields??>
            <#list likeQueryFields! as queryField >
                ${queryObj!}.set${queryField}(${queryObj!}.get${queryField}()
                .replaceAll("/", "//").replaceAll("%", "/%")
                .replaceAll("_","/_").replaceAll("\\[","/[").replaceAll("]","/]"));
            </#list>
        </#if>
        <#if isSortOverall?? && isSortOverall!>
        // 查询条件构造器,将排序条件封装成QueryWrapper
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper<${returnValue}> queryWrapper = singleTableQueryGenerator.initQueryWrapper(new ${returnValue}(), parameterMap);
        </#if>
        /* @begin ${name!}1 #自定义代码 */
        /* @end ${name!}1 */
        List<${returnValue}> list = ${table.mapperEnName!}.${name!}(pager, ${queryObj!}<#if isSortOverall?? && isSortOverall!>, queryWrapper</#if>);
        /* @begin ${name!}2 #自定义代码 */
        /* @end ${name!}2 */
        <#if table.translateShowFields??>
            TransUtil.trans(list);
        </#if>
        ${vo?uncap_first}.setData(list);
        ${vo?uncap_first}.setCount(pager.getTotal());
    <#else>
    <#--    是否有排序条件 如果有增加一个排序条件的QueryWrapper-->
        <#if sortConditionObj??>
            <#assign sortFields = sortConditionObj.fields!>
            /* @begin ${name!}1 #自定义代码 */
            /* @end ${name!}1 */
            List<${returnValue}> list = ${table.mapperEnName!}.${name!}(${queryObj!}, new QueryWrapper<${returnValue}>()
            <#list sortFields as f>
                <#if f.sortCondition == "asc">
                    .orderByAsc("${f.fromModelFieldSort!}")
                <#else>
                    .orderByDesc("${f.fromModelFieldSort!}")
                </#if>
            </#list>
            );
            /* @begin ${name!}2 #自定义代码 */
            /* @end ${name!}2 */
        <#else>
            <#if likeQueryFields??>
                <#list likeQueryFields! as queryField >
                    ${queryObj!}.set${queryField}(${queryObj!}.get${queryField}()
                    .replaceAll("/", "//").replaceAll("%", "/%")
                    .replaceAll("_","/_").replaceAll("\\[","/[").replaceAll("]","/]"));
                </#list>
            </#if>
            /* @begin ${name!}1 #自定义代码 */
            /* @end ${name!}1 */
            List<${returnValue}> list = ${table.mapperEnName!}.${name!}(${queryObj!});
            /* @begin ${name!}2 #自定义代码 */
            /* @end ${name!}2 */
        </#if>
        <#if table.translateShowFields??>
            TransUtil.trans(importData);
        </#if>
        ${vo?uncap_first}.setData(list);
    <#--        无分页count存当前list长度-->
        if(HussarUtils.isNotEmpty(list)){
        ${vo?uncap_first}.setCount((long) list.size());
        }
    </#if>
<#else>
<#--    无查询条件-->
    <#if isPagination?? && isPagination!>
    public ApiResponse<${vo!}> ${name!}(Page<${returnValue}> page){
        try {
            Page<${returnValue}> pager = new Page<>(page.getCurrent(), page.getSize());
        <#--        全局排序-->
            <#if isSortOverall?? && isSortOverall!>
            Map<String, String[]> parameterMap = new HashMap<>();
            List<String> orderRule = new ArrayList<>();
            if (page.orders() != null) {
                StringBuilder order = new StringBuilder();
                for (OrderItem orderItem : page.orders()) {
                    if (orderItem.isAsc()) {
                        order.append(orderItem.getColumn()).append(ASC);
                    }else {
                        order.append(orderItem.getColumn()).append(DESC);
                    }
                }
                orderRule.add(order.toString());
                parameterMap.put(ORDER_RULE, orderRule.toArray(new String[0]));
            }

            </#if>
    <#--    排序条件，分页排序条件加载page对象中,sortConditionObj排序对象-->
        <#if sortConditionObj??>
            <#if isSortOverall?? && isSortOverall!>
            List<String> defaultOrderRule = new ArrayList<>();
            String defaultOrder = "";
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    defaultOrder += "${f.fromModelFieldSort!}" + <#if f.sortCondition == "asc">ASC<#else>DESC</#if>;
                </#list>
                defaultOrderRule.add(defaultOrder);
                parameterMap.put(DEFAULT_ORDER_RULE, defaultOrderRule.toArray(new String[0]));
            <#else>
                <#assign sortFields = sortConditionObj.fields!>
                <#list sortFields as f>
                <#--   fromModelFieldSort 排序列名   sortCondition asc 升序  desc 降序      -->
                    pager.addOrder(new OrderItem("${f.fromModelFieldSort!}", <#if f.sortCondition == "asc">true<#else>false</#if>));
                </#list>
            </#if>
        </#if>
        ${vo!} ${vo?uncap_first} = new ${vo!}();
        <#if isSortOverall?? && isSortOverall!>
            // 查询条件构造器,将排序条件封装成QueryWrapper
            SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
            QueryWrapper<${returnValue}> queryWrapper = singleTableQueryGenerator.initQueryWrapper(new ${returnValue}(), parameterMap);
        <#elseif (logicallyDelete?? && logicallyDelete!) || (securityLevel??)>
            QueryWrapper<${returnValue}> queryWrapper = new QueryWrapper<>();
        </#if>
        <#if logicallyDelete?? && logicallyDelete!>
            queryWrapper.lambda().and(wrapper -> wrapper.ne(${returnValue}::get${getLogicallyFlag!}, "1").or().isNull(${returnValue}::get${getLogicallyFlag!}));
        </#if>
        <#if securityLevel??>
            queryWrapper.lambda().and(wrapper -> wrapper.le(${returnValue}::get${securityLevel.capitalName!}, BaseSecurityUtil.getUser().getSecurityLevel()));
        </#if>
        /* @begin ${name!}1 #自定义代码 */
        /* @end ${name!}1 */
        List<${returnValue}> list = this.page(pager<#if isSortOverall?? && isSortOverall!>, queryWrapper</#if>).getRecords();
        /* @begin ${name!}2 #自定义代码 */
        /* @end ${name!}2 */
        <#if table.translateShowFields??>
            TransUtil.trans(list);
        </#if>
        ${vo?uncap_first}.setData(list);
        ${vo?uncap_first}.setCount(pager.getTotal());
    <#else>
        public ApiResponse<${vo!}> ${name!}(){
        try {
        ${vo!} ${vo?uncap_first} = new ${vo!}();
    <#--    是否有排序条件 如果有增加一个排序条件的QueryWrapper-->
        <#if sortConditionObj??>
            <#assign sortFields = sortConditionObj.fields!>
            /* @begin ${name!}1 #自定义代码 */
            /* @end ${name!}1 */
            List<${returnValue}> list = this.list(new QueryWrapper<${returnValue}>()
            <#if logicallyDelete?? && logicallyDelete!>
                .ne("${deleteFlagName}","1").or().isNull("${deleteFlagName}")
            </#if>
            <#list sortFields as f>
                <#if f.sortCondition == "asc">
                    .orderByAsc("${f.fromModelFieldSort!}")
                <#else>
                    .orderByDesc("${f.fromModelFieldSort!}")
                </#if>
            </#list>
            );
            /* @begin ${name!}2 #自定义代码 */
            /* @end ${name!}2 */
        <#else>
            <#if (logicallyDelete?? && logicallyDelete!) || (securityLevel??)>
                QueryWrapper<${returnValue}> queryWrapper = new QueryWrapper<>();
            </#if>
            <#if logicallyDelete?? && logicallyDelete!>
                queryWrapper.lambda().and(wrapper -> wrapper.ne(${returnValue}::get${getLogicallyFlag!}, "1").or().isNull(${returnValue}::get${getLogicallyFlag!}));
            </#if>
            <#if securityLevel??>
                queryWrapper.lambda().and(wrapper -> wrapper.le(${returnValue}::get${securityLevel.capitalName!}, BaseSecurityUtil.getUser().getSecurityLevel()));
            </#if>
            /* @begin ${name!}1 #自定义代码 */
            /* @end ${name!}1 */
            List<${returnValue}> list = this.list(<#if (logicallyDelete?? && logicallyDelete!) || (securityLevel??)>queryWrapper</#if>);
            /* @begin ${name!}2 #自定义代码 */
            /* @end ${name!}2 */
        </#if>
        <#if table.translateShowFields??>
            TransUtil.trans(list);
        </#if>
        ${vo?uncap_first}.setData(list);
        if(HussarUtils.isNotEmpty(list)){
        ${vo?uncap_first}.setCount((long) list.size());
        }
    </#if>
</#if>
<#--共有部分-->
${vo?uncap_first}.setCode(RETURN_CODE);
return ApiResponse.success(${vo?uncap_first});
} catch (Exception e) {
    <#if table?? && table.transDisposition?? && table.transDisposition>
    throw new HussarException(TfModelEnum.TF_TABLE_QUERY_FAILED.getMessage(),e);
    <#else>
    throw new HussarException("表格查询失败",e);
    </#if>
    }
}
