/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.service;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.JavaCodeFormatUtil;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.result.MysqlCodeResult;
import com.jxdinfo.hussar.formdesign.structural.model.MergeConfig;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="MYSQL_RESULT_BEAN")
public class MysqlCodeMergeServiceImpl
implements CodeMergeService {
    @Resource
    private FilePublishService filePublishService;
    @Resource
    private VersionManageService versionManageService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService codeMergeService;
    @Resource
    private FileMappingService fileMappingService;

    public void writeMergeCode(CodeResult result) throws IOException {
        if (result instanceof MysqlCodeResult) {
            MysqlCodeResult codeResult = (MysqlCodeResult)result;
            String dataId = codeResult.getDataId();
            String lastPublish = ToolUtil.textFomatterByOS((String)codeResult.getLastPublish());
            String newContent = codeResult.getNewCode();
            String filePath = codeResult.getFilePath();
            this.filePublishService.writeStringToFile(lastPublish, filePath);
            this.versionManageService.saveLastPublishCode(dataId, newContent);
            this.versionManageService.saveLastFileCode(dataId, lastPublish);
        }
    }

    public CodeResult parseData(String s) {
        return (CodeResult)JSON.parseObject((String)s, MysqlCodeResult.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeResult dealMerge(CodeResult result) throws IOException {
        if (result instanceof MysqlCodeResult) {
            MergeResult mergeResult;
            boolean isConflict;
            MysqlCodeResult codeResult = (MysqlCodeResult)result;
            String id = codeResult.getId();
            String dataId = codeResult.getDataId();
            String pagePath = codeResult.getFilePath();
            String lastPublish = ToolUtil.textFomatterByOS((String)codeResult.getLastPublish());
            String currentPublish = codeResult.getCurrentPublish();
            String currentFile = this.filePublishService.readCurrentPublishedFile(pagePath);
            String lastFile = this.versionManageService.getLastFileCode(dataId);
            if ("java".equals(codeResult.getType())) {
                Map format = JavaCodeFormatUtil.formatImport((String)currentFile, (String)lastPublish, (String)lastFile);
                currentFile = format.getOrDefault("currentFile", currentFile);
                lastPublish = format.getOrDefault("lastPublish", lastPublish);
                lastFile = format.getOrDefault("lastFileCode", lastFile);
            }
            if (!(isConflict = (mergeResult = this.codeMergeService.structuralMerge(pagePath, ExtractFileType.byExtension((String)pagePath), lastPublish, currentFile, currentPublish, lastFile, false, new MergeConfig(true))).isConflict())) {
                try {
                    this.filePublishService.writeStringToFile(mergeResult.getMergedCode(), pagePath, id);
                    codeResult.setExistConflict(false);
                }
                finally {
                    this.versionManageService.saveCacheLastPublishCode(dataId, currentPublish, id);
                    this.versionManageService.saveCacheLastFileCode(dataId, mergeResult.getMergedCode(), id);
                }
            } else {
                codeResult.setExistConflict(true);
                codeResult.setMergeCode(mergeResult.getMergedCode());
                codeResult.setConflictCode(mergeResult.getConflictsCode());
                codeResult.setLastPublish(mergeResult.getLastPublish());
                codeResult.setCurrentFile(mergeResult.getCurrentFile());
                codeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                codeResult.setMergeInfo(mergeResult.getMergeInfo());
                codeResult.setMergeUserSection(mergeResult.getMergeUserSection());
            }
            return codeResult;
        }
        return result;
    }
}

