<#assign index = 1>
@Override
@HussarTransactional
public ApiResponse<?> ${operationName!}(MultipartFile file, String uniqueIdentification, String slaveTable,String slaveUniqueIdentification, String slaveForeignIdentification) {
    //适配单表不判断子表相关信息
    if (HussarUtils.isEmpty(uniqueIdentification)) {
        return ApiResponse.fail("缺少业务唯一标识信息");
    }
    //主表业务唯一标识名
    List<String> slaveTables = Arrays.asList(slaveTable.split(","));
    List<String> slaveUniqueIdentifications = Arrays.asList(slaveUniqueIdentification.split(","));
    List<String> slaveForeignIdentifications = Arrays.asList(slaveForeignIdentification.split(","));
    Map<String, String> param = new HashMap<>();
    Map<String, String> foreignParam = new HashMap<>();
    for (int i = 0; i < slaveTables.size(); i++) {
        param.put(slaveTables.get(i), slaveUniqueIdentifications.get(i));
        foreignParam.put(slaveTables.get(i), slaveForeignIdentifications.get(i));
    }
    <#if modelTranslate?? && modelTranslate!>
        String mapString = "${sourceMap!}";
        String sqlMapString = "${sqlMap!}";
        Map<String, String> sourceMap = new HashMap<>();
        Map<String, String> sqlMap = new HashMap<>();
        Map<String, String> sourceIdMap = new HashMap<>();

        String[] sqlPairs = sqlMapString.split("; ");
        for (String pair : sqlPairs) {
            String[] keyValue = pair.split(": ");
            if (keyValue.length == 2) {
                String key = keyValue[0].trim();
                String value = String.valueOf(keyValue[1].trim());
                sqlMap.put(key, value);
            }
        }

        String[] pairs = mapString.split(", ");
        for (String pair : pairs) {
            String[] keyValue = pair.split(": ");
            if (keyValue.length == 2) {
                String key = keyValue[0].trim();
                String value = String.valueOf(keyValue[1].trim());
                sourceMap.put(key, value);
            }
        }

        String useName2 = "${useName!}";
        String[] pairs2 = useName2.split(", ");
        for (String pair : pairs2) {
            String[] keyValue = pair.split(": ");
            if (keyValue.length == 2) {
                String key = keyValue[0].trim();
                String value = String.valueOf(keyValue[1].trim());
                sourceIdMap.put(key, value);
            }
        }
    Map<String,Map<String, Object>> temp = new HashMap<>();
    </#if>
    //表名和service对应关系
    Map<String, Class<?>> classMap = new HashMap<>();
    classMap.put("${table.comment}", ${masterTableName!}.class);
    <#list slaveTable as slave>
        classMap.put("${slave.comment}", ${slave.name?cap_first}.class);
    </#list>
    //主表物理主键与业务唯一标识对应关系
    Map<String, String> masterKeyCorrespondence = new HashMap<>();
    Map<String, Map<String, String>> dict = new HashMap<>();
    <#if table.hasTranslate?? && table.hasTranslate!>
        Map<String, String> map = new HashMap<>();
        <#list table.fields as field>
            <#if field.dictTyeName?? && field.dictTyeName != ''>
                map.put("${table.comment}${field.comment}","${field.dictTyeName}");
            </#if>
        </#list>
        <#list table.dataModelDtoMap as key, value>
            <#list value.fields as field>
                <#if field.dictTyeName?? && field.dictTyeName != ''>
                    map.put("${value.comment}${field.comment}","${field.dictTyeName}");
                </#if>
            </#list>
        </#list>
        List<DictVo> dictVosByTypeNames = iSysDicRefService.getDictVosByTypeNames(new ArrayList<>(map.values()));
        Map<String, List<DictVo>> group = dictVosByTypeNames.stream().collect(Collectors.groupingBy(DictVo::getTypeName));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            List<DictVo> dictVos = group.get(entry.getValue());
            if (HussarUtils.isNotEmpty(dictVos)){
                Map<String, String> collect = dictVos.get(0).getSingleList().stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
                dict.put(entry.getKey(), collect);
            }
        }
    </#if>
    //主表用于数据库操作的list、sql
    List<${masterTableName!}> ${table.name?uncap_first}AddList = new ArrayList<>();
    List<${masterTableName!}> ${table.name?uncap_first}UpdateList = new ArrayList<>();
    StringBuilder ${table.name?uncap_first}Sb = new StringBuilder();
    //各个子表用于数据库操作的list、sql
    <#list slaveTable as slave>
        List<${slave.name?cap_first}> ${slave.name}Add = new ArrayList<>();
        List<${slave.name?cap_first}> ${slave.name}Update = new ArrayList<>();
        StringBuilder ${slave.name}Sb = new StringBuilder();
    </#list>


    try {
        //表名及对应实体类数据
        Map<String, List<?>> data = ExcelUtils.readFileManySheetToObj(file, classMap, dict);
        importData:
        for (Map.Entry<String, List<?>> entry : data.entrySet()) {
            if ("${table.comment}".equals(entry.getKey())) {
                //获取业务唯一标识对应属性
                Field declaredField = classMap.get(entry.getKey()).getDeclaredField(uniqueIdentification);
                //允许访问私有字段
                declaredField.setAccessible(true);
                List<${masterTableName!}> ${table.name?uncap_first}List = (List<${masterTableName!}>) entry.getValue();
                //主表业务唯一标识值
                List<String> values = new ArrayList<>();
                //获取库里的对应信息
                List<${masterTableName!}> masterList = ${masterServiceName?uncap_first}.list();
                if (!masterList.isEmpty()) {
                    for (${masterTableName!} ${table.name?uncap_first} : masterList) {
                        masterKeyCorrespondence.put(String.valueOf(${table.name?uncap_first}.get${primaryField?cap_first}()), String.valueOf(declaredField.get(${table.name?uncap_first})));
                    }
                }
                //循环获取值
                for (${masterTableName!} ${table.name?uncap_first} : ${table.name?uncap_first}List) {
                    if (HussarUtils.isEmpty(declaredField.get(${table.name?uncap_first}))) {
                        return ApiResponse.fail("业务主键不存在");
                    }
                    String s = String.valueOf(declaredField.get(${table.name?uncap_first}));
                    values.add(s);
                    if (!masterKeyCorrespondence.containsValue(s)) {
                        if (HussarUtils.isEmpty(${table.name?uncap_first}.get${primaryField?cap_first}())){
                            ${table.name?uncap_first}.set${primaryField?cap_first}((IdWorker.getId(${table.name?uncap_first})));
                        }
                        masterKeyCorrespondence.put(String.valueOf(${table.name?uncap_first}.get${primaryField?cap_first}()), s);
                    }
                    <#if isMasterslaveTask?? && isMasterslaveTask!>
                    if(HussarUtils.isEmpty(${table.name?uncap_first}.getCreator())){
                        ${table.name?uncap_first}.setCreator(BaseSecurityUtil.getUser().getId());
                    }
                    if (HussarUtils.isEmpty(${table.name?uncap_first}.getCreateTime())){
                        ${table.name?uncap_first}.setCreateTime(LocalDateTime.now());
                    }
                    </#if>
                }
                <#if modelTranslate?? && modelTranslate!>
                List<Map<String, Object>> clumsMap;
                for (int i = 0; i < ${table.name?uncap_first}List.size(); i++) {
                    Class<?> clazz = ${table.name?uncap_first}List.get(i).getClass();
                    Field[] fields = clazz.getDeclaredFields();
                    for (Field field : fields) {
                        if (sqlMap.containsKey("${table.comment}" + field.getName())){
                            clumsMap = ${table.mapperEnName!}.getModelInfo(new StringBuilder(sqlMap.get("${table.comment}" + field.getName())));
                            String s = sourceIdMap.get("${table.comment}" + field.getName());
                            Map<String, Object> map6 = new HashMap<>();
                            for (int o = 0; o < clumsMap.size(); o++) {
                                if (HussarUtils.isNotEmpty(clumsMap.get(o).get(s))){
                                    map6.put(clumsMap.get(o).get(s).toString(), clumsMap.get(o).get(sourceMap.get("${table.comment}" + field.getName())));
                                }
                                temp.put("${table.comment}" + field.getName(),map6);
                            }
                        }
                    }
                    for (Field field : fields) {
                        if (field.isAnnotationPresent(TableField.class)) {
                            TableField tableField = field.getAnnotation(TableField.class);
                            // 检查此表是否有附加字段
                            if (sourceMap.containsKey("${table.comment}" + field.getName())) {
                                Map<String, Object> stringStringMap = temp.get("${table.comment}" + field.getName());
                                ${masterTableName!} obj = ${table.name?uncap_first}List.get(i);
                                // 使用反射获取getter和setter方法
                                Method getter = obj.getClass().getMethod("get" + capitalize(field.getName()));
                                if(field.getType().equals(Boolean.class)){
                                    getter = obj.getClass().getMethod("is" + capitalize(field.getName()));
                                }
                                Method setter = obj.getClass().getMethod("set" + capitalize(field.getName()), String.class);
                                Object o = getter.invoke(obj);
                                setter.invoke(obj, "");
                                for (Map.Entry<String, Object> entry2 : stringStringMap.entrySet()) {
                                    if (entry2.getValue().toString().equals(o)) {
                                        setter.invoke(obj, entry2.getKey());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                </#if>

                //主表只区分新增还是修改
                //List<${masterTableName!}> addList = new ArrayList<>();
                //List<${masterTableName!}> updateList = new ArrayList<>();
                //Function<Object, String> f = (Object::toString);
                List<String> masterColumn = ExcelUtils.camelToSnake(Collections.singletonList(uniqueIdentification));
                //List<String> strings = HussarUtils.isNotEmpty(values) ? ${masterServiceName?uncap_first}.listObjs(new QueryWrapper<${masterTableName!}>().in(masterColumn.get(0), values), f) : new ArrayList<>();
                List<${masterTableName!}> strings = HussarUtils.isNotEmpty(values) ? ${masterServiceName?uncap_first}.list(new QueryWrapper<${masterTableName!}>().in(masterColumn.get(0), values)) : new ArrayList<>();
                //自然主键、业务主键map
                HashMap<Long,String> IdToMasterColume = new HashMap<>();
                for (${masterTableName!} ${table.name?uncap_first} : strings) {
                    IdToMasterColume.put(${table.name?uncap_first}.get${primaryField?cap_first}(),String.valueOf(declaredField.get(${table.name?uncap_first})));
                }
                if (!IdToMasterColume.isEmpty()) {
                    for (${masterTableName!} ${table.name?uncap_first} : ${table.name?uncap_first}List) {
                        if (IdToMasterColume.containsValue(String.valueOf(declaredField.get(${table.name?uncap_first})))) {
                            Long s = IdToMasterColume.keySet()
                                    .stream()
                                    .filter(key -> {
                                        try {
                                            return String.valueOf(declaredField.get(${table.name?uncap_first})).equals(IdToMasterColume.get(key));
                                        } catch (IllegalAccessException e) {
                                            throw new RuntimeException(e);
                                        }
                                    })
                                    .findFirst().get();
                            ${table.name?uncap_first}.set${primaryField?cap_first}(s);
                            ${table.name?uncap_first}UpdateList.add(${table.name?uncap_first});
                        } else {
                           ${table.name?uncap_first}AddList.add(${table.name?uncap_first});
                        }
                    }
                } else {
                    ${table.name?uncap_first}AddList.addAll(${table.name?uncap_first}List);
                }
                //if (!${table.name?uncap_first}AddList.isEmpty()) {
                //    ${masterServiceName?uncap_first}.saveBatch(${table.name?uncap_first}AddList);
                //}
                //StringBuilder sb = new StringBuilder();
                //数据库中主键字段名
                String mainIdName = "";
                String mainName = "";
                if (!${table.name?uncap_first}UpdateList.isEmpty()) {
                    for (int i = 0; i < ${table.name?uncap_first}UpdateList.size(); i++) {
                        Long mainId = 0L;
                        StringBuilder setClause = new StringBuilder();
                        //表名
                        String tableName = "${mainName!}";
                        Class<?> clazz = ${table.name?uncap_first}UpdateList.get(i).getClass();
                        Field[] fields = clazz.getDeclaredFields();
                        List<Field> neededFields = new ArrayList<>();
                        List<String> neededFieldValues = new ArrayList<>();
                        Map<String,String> ${table.name}Map = new HashMap<>();//实体类字段和数据库字段对照map，无主键。
                        for (Field field : fields) {
                            if (field.isAnnotationPresent(TableField.class)) { // 检查字段上是否有@TableField注解
                                neededFields.add(field);
                                TableField tableField = field.getAnnotation(TableField.class); // 获取注解实例
                                ${table.name}Map.put(field.getName(),tableField.value());
                            }
                            if (field.isAnnotationPresent(TableId.class)) {
                                neededFields.add(field);
                                field.setAccessible(true);
                                TableId tableId = field.getAnnotation(TableId.class); // 获取注解实例
                                mainIdName = tableId.value(); // 获取注解的value值，即数据库字段名
                                mainId = (Long) field.get(${table.name?uncap_first}UpdateList.get(i));
                                mainName = field.getName();
                            }
                        }
                        // 业务主键不需要更新
                        boolean firstField = true;
                        for (Field field : neededFields) {
                            try {
                                if (!field.getName().equals(mainName)) { // 排除id字段
                                    if (!firstField) {
                                        setClause.append(", ");
                                    }
                                    // 使用getter获取字段值，这里假设有标准的getter方法
                                    String methodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                                    if(field.getType().equals(Boolean.class)){
                                        methodName = "is" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                                    }
                                    Method method = clazz.getMethod(methodName);
                                    Object value = method.invoke(${table.name?uncap_first}UpdateList.get(i));
                                    // 检查值是否为null，并相应地构建SQL片段
                                    if (value == null) {
                                        setClause.append(${table.name}Map.get(field.getName())).append(" = NULL");
                                    } else {
                                        if (value instanceof Boolean) {
                                            if ((Boolean) value){
                                                setClause.append(${table.name}Map.get(field.getName())).append(" = 1");
                                            } else {
                                                setClause.append(${table.name}Map.get(field.getName())).append(" = 0");
                                            }
                                        } else {
                                            setClause.append(${table.name}Map.get(field.getName())).append(" = '").append(value).append("'");
                                        }
                                    }
                                    firstField = false;
                                }
                            } catch (NoSuchMethodException | IllegalAccessException e) {
                                e.printStackTrace();
                                // 处理异常或返回null等
                            }
                        }

                        if (setClause.length() == 0) {
                            return null; // 如果没有可更新的字段，则返回null
                        }

                        String sql = String.format("UPDATE %s SET %s WHERE " + mainIdName +  " = %d;", tableName, setClause.toString(), mainId);
                        ${table.name?uncap_first}Sb.append(sql);
                    }
                    //${table.name}Mapper.updateBySqls(sb);
                //${masterServiceName?uncap_first}.updateBatchById(updateList);
                }
            }
        <#list slaveTable as slave>
            if ("${slave.comment}".equals(entry.getKey())) {
                //获取业务唯一标识对应属性
                String slaveNatural${index!} = String.valueOf(param.get(entry.getKey()));
                Field declaredField${index!} = classMap.get(entry.getKey()).getDeclaredField(slaveNatural${index!});
                //获取外键对应属性（对应主表业务唯一标识）
                Field foreignKeyAttributes${index!} = classMap.get(entry.getKey()).getDeclaredField(foreignParam.get(entry.getKey()));
                //允许访问私有字段
                declaredField${index!}.setAccessible(true);
                foreignKeyAttributes${index!}.setAccessible(true);
                //业务唯一标识
                List<String> subValues${index!} = new ArrayList<>();
                //子表物理外键与外键对应关系
                //外键（对应主表业务唯一标识）
                Map<String, String> subKeyCorrespondence${index!} = new HashMap<>();

                List<${slave.name?cap_first}> ${slave.name}List = (List<${slave.name?cap_first}>) entry.getValue();
                //循环获取值
                for (${slave.name?cap_first} ${slave.name?uncap_first} : ${slave.name}List) {
                    if (HussarUtils.isEmpty(declaredField${index!}.get(${slave.name?uncap_first}))) {
                        declaredField${index!}.set(${slave.name?uncap_first},IdWorker.getId(${slave.name?uncap_first}));
                    }
                    subValues${index!}.add(String.valueOf(declaredField${index!}.get(${slave.name?uncap_first})));
                    // key 为外键字段名
                    if (HussarUtils.isEmpty(${slave.name?uncap_first}.get${slave.foreignField?cap_first}())){
                        for (Map.Entry<String, String> ${slave.name?uncap_first}Entry : masterKeyCorrespondence.entrySet()) {
                            if (${slave.name?uncap_first}Entry.getValue().equals(String.valueOf(foreignKeyAttributes${index!}.get(${slave.name?uncap_first})))) {
                                ${slave.name?uncap_first}.set${slave.foreignField?cap_first}(Long.parseLong(${slave.name?uncap_first}Entry.getKey()));
                            }
                        }
                    }
                    subKeyCorrespondence${index!}.put(String.valueOf(${slave.name?uncap_first}.get${slave.foreignField?cap_first}()), String.valueOf(foreignKeyAttributes${index!}.get(${slave.name?uncap_first})));
                }
                if (!ExcelUtils.isMapContained(masterKeyCorrespondence, subKeyCorrespondence${index!})) {
                    throw new RuntimeException("外键关联有误");
                }
                <#if modelTranslate?? && modelTranslate!>
                List<Map<String, Object>> clumsMap2;
                for (int i = 0; i < ${slave.name}List.size(); i++) {
                    Class<?> clazz = ${slave.name}List.get(i).getClass();
                    Field[] fields = clazz.getDeclaredFields();
                    for (Field field : fields) {
                        if (sqlMap.containsKey("${slave.comment}" + field.getName())){
                            clumsMap2 = ${table.name}Mapper.getModelInfo(new StringBuilder(sqlMap.get("${slave.comment}" + field.getName())));
                            String s = sourceIdMap.get("${slave.comment}" + field.getName());
                            Map<String, Object> map6 = new HashMap<>();
                            for (int o = 0; o < clumsMap2.size(); o++) {
                                if (HussarUtils.isNotEmpty(clumsMap2.get(o).get(s))){
                                    map6.put(clumsMap2.get(o).get(s).toString(), clumsMap2.get(o).get(sourceMap.get("${slave.comment}" + field.getName())));
                                }
                                temp.put("${slave.comment}" + field.getName(),map6);
                            }
                        }
                    }
                    for (Field field : fields) {
                        if (field.isAnnotationPresent(TableField.class)) {
                            TableField tableField = field.getAnnotation(TableField.class);
                            // 检查此表是否有附加字段
                            if (sourceMap.containsKey("${slave.comment}" + field.getName())) {
                                Map<String, Object> stringStringMap = temp.get("${slave.comment}" + field.getName());
                                ${slave.name?cap_first} obj = ${slave.name}List.get(i);
                                // 使用反射获取getter和setter方法
                                Method getter = obj.getClass().getMethod("get" + capitalize(field.getName()));
                                if(field.getType().equals(Boolean.class)){
                                    getter = obj.getClass().getMethod("is" + capitalize(field.getName()));
                                }
                                Method setter = obj.getClass().getMethod("set" + capitalize(field.getName()), String.class);
                                Object o = getter.invoke(obj);
                                setter.invoke(obj, "");
                                for (Map.Entry<String, Object> entry2 : stringStringMap.entrySet()) {
                                    if (entry2.getValue().toString().equals(o)) {
                                        setter.invoke(obj, entry2.getKey());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                </#if>
                //List<${slave.name?cap_first}> subAdd${index!} = new ArrayList<>();
                //List<${slave.name?cap_first}> subUpdate${index!} = new ArrayList<>();
                //Function<Object, String> f${index!} = (Object::toString);
                List<String> slaveColumn${index!} = ExcelUtils.camelToSnake(Collections.singletonList(slaveNatural${index!}));
                List<${slave.name?cap_first}> strings${index!} = HussarUtils.isNotEmpty(subValues${index!}) ? ${slave.name?uncap_first}Service.list(new QueryWrapper<${slave.name?cap_first}>().in(slaveColumn${index!}.get(0), subValues${index!})) : new ArrayList<>();
                //自然主键、业务主键 map
                HashMap<Long,String> IdToSlaveColume = new HashMap<>();
                for (${slave.name?cap_first} ${slave.name} : strings${index!}) {
                    IdToSlaveColume.put(${slave.name}.get${slave.primaryField?cap_first}(),String.valueOf(declaredField${index!}.get(${slave.name})));
                }
                if (!IdToSlaveColume.isEmpty()) {
                    for (${slave.name?cap_first} ${slave.name} : ${slave.name}List) {
                        if (IdToSlaveColume.containsValue(String.valueOf(declaredField${index!}.get(${slave.name})))) {
                            Long s = IdToSlaveColume.keySet()
                                    .stream()
                                    .filter(key -> {
                                        try {
                                            return String.valueOf(declaredField${index!}.get(${slave.name})).equals(IdToSlaveColume.get(key));
                                        } catch (IllegalAccessException e) {
                                            throw new RuntimeException(e);
                                        }
                                    })
                                    .findFirst().get();
                            ${slave.name}.set${slave.primaryField?cap_first}(s);
                            ${slave.name}Update.add(${slave.name});
                        } else {
                            ${slave.name}Add.add(${slave.name});
                        }
                    }
                } else {
                    ${slave.name}Add.addAll(${slave.name}List);
                }
                //if (!subAdd${index!}.isEmpty()) {
                //    ${slave.name?uncap_first}Service.saveBatch(subAdd${index!});
                //}
                if (!${slave.name}Update.isEmpty()) {
                    //StringBuilder sb = new StringBuilder();
                    String mainIdName = "";//数据库中主键字段名
                    for (int i = 0; i < ${slave.name}Update.size(); i++) {
                        Long mainId = 0L;
                        StringBuilder setClause = new StringBuilder();
                        String tableName = "${slave.name}"; //表名
                        Class<?> clazz = ${slave.name}Update.get(i).getClass();
                        Field[] fields = clazz.getDeclaredFields();
                        List<Field> neededFields = new ArrayList<>();
                        List<String> neededFieldValues = new ArrayList<>();
                        Map<String,String> ${slave.name}Map = new HashMap<>();//实体类字段和数据库字段对照map，无主键。
                        String mainName = "";
                        for (Field field : fields) {
                            if (field.isAnnotationPresent(TableField.class)) { // 检查字段上是否有@TableField注解
                                neededFields.add(field);
                                TableField tableField = field.getAnnotation(TableField.class); // 获取注解实例
                                if(HussarUtils.isNotEmpty(tableField.value())){
                                    ${slave.name}Map.put(field.getName(),tableField.value());
                                }
                            }
                            if (field.isAnnotationPresent(TableId.class)) {
                                neededFields.add(field);
                                field.setAccessible(true);
                                TableId tableId = field.getAnnotation(TableId.class); // 获取注解实例
                                mainIdName = tableId.value(); // 获取注解的value值，即数据库字段名
                                mainId = (Long) field.get(${slave.name}Update.get(i));
                                mainName = field.getName();
                            }
                        }
                        // 业务主键不需要更新
                        boolean firstField = true;
                        for (Field field : neededFields) {
                            try {
                                if (!field.getName().equals(mainName)) { // 排除id字段
                                    if (!firstField) {
                                        setClause.append(", ");
                                    }
                                    // 使用getter获取字段值，这里假设有标准的getter方法
                                    String methodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                                    if(field.getType().equals(Boolean.class)){
                                        methodName = "is" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                                    }
                                    Method method = clazz.getMethod(methodName);
                                    Object value = method.invoke(${slave.name}Update.get(i));
                                    // 检查值是否为null，并相应地构建SQL片段
                                    if (value == null) {
                                        if(HussarUtils.isNotEmpty(${slave.name}Map.get(field.getName()))){
                                            setClause.append(${slave.name}Map.get(field.getName())).append(" = NULL");
                                        } else {
                                            setClause = new StringBuilder(setClause.substring(0,setClause.lastIndexOf(",")));
                                        }
                                    } else {
                                        if (value instanceof Boolean) {
                                            if ((Boolean) value){
                                                setClause.append(${slave.name}Map.get(field.getName())).append(" = 1");
                                            } else {
                                                setClause.append(${slave.name}Map.get(field.getName())).append(" = 0");
                                            }
                                        } else {
                                            setClause.append(${slave.name}Map.get(field.getName())).append(" = '").append(value).append("'");
                                        }
                                    }
                                    firstField = false;
                                }
                            } catch (NoSuchMethodException | IllegalAccessException e) {
                                e.printStackTrace();
                                // 处理异常或返回null等
                            }
                        }

                        if (setClause.length() == 0) {
                            return null; // 如果没有可更新的字段，则返回null
                        }

                        String sql = String.format("UPDATE %s SET %s WHERE " + mainIdName +  " = %d;", tableName, setClause.toString(), mainId);
                        ${slave.name}Sb.append(sql);
                    }
                    //${table.name}Mapper.updateBySqls(sb);
                    //${slave.name?uncap_first}Service.updateBatchById(subUpdate${index!});
                }
            <#assign index++>
            }
        </#list>
        }
    } catch (Exception e) {
        throw new RuntimeException(e);
    }
    try{
        if (!${table.name?uncap_first}AddList.isEmpty()) {
            ${masterServiceName?uncap_first}.saveBatch(${table.name?uncap_first}AddList);
        }
        if (HussarUtils.isNotEmpty(${table.name?uncap_first}Sb)){
            ${table.name?uncap_first}Mapper.updateBySqls(${table.name?uncap_first}Sb);
        }
        <#list slaveTable as slave>
            if (!${slave.name}Add.isEmpty()) {
                ${slave.name}Service.saveBatch(${slave.name}Add);
            }
            if (HussarUtils.isNotEmpty(${slave.name}Sb)){
                ${table.name?uncap_first}Mapper.updateBySqls(${slave.name}Sb);
            }
        </#list>
    } catch (Exception e) {
        throw new RuntimeException(e);
    }

    return ApiResponse.success();
}
