/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.view;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.view.MysqlViewDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.view.MysqlViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlViewRender;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLVIEWConditionFilter")
public class MysqlViewConditionFilterVisitor
implements MysqlOperationVisitor<MysqlViewDataModel, MysqlViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlViewConditionFilterVisitor.class);
    public static final String OPERATION_NAME = "MYSQLVIEWConditionFilter";

    @Override
    public void visit(MysqlBackCtx<MysqlViewDataModel, MysqlViewDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException {
        boolean isPagination;
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        MysqlViewDataModelDTO dataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = dataModelViewDTO.getApiPrefix() + "/" + dataModelOperation.getName();
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelViewDTO);
        controllerParams.put("returnValue", dataModelViewDTO.getEntityName());
        controllerParams.put("url", url);
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelViewDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelViewDTO.getComment() + "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        this.renderSort(dataModelOperation, controllerParams, backCtx.getUseDataModelBase());
        isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderFilter(backCtx, dataModelOperation, modelId, dataModelViewDTO, controllerParams);
        this.renderPageVo(backCtx, modelId, dataModelViewDTO, controllerParams);
        String controllerPath = "template/backcode/conditionFilter/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelViewDTO.getServiceName());
        String servicePath = "template/backcode/conditionFilter/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/backcode/conditionFilter/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelViewDTO, isSortOverall, isPagination);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", url, "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlViewRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private void renderImport(MysqlBackCtx<MysqlViewDataModel, MysqlViewDataModelDTO> backCtx, String modelId, MysqlViewDataModelDTO dataModelBaseDTO, boolean isSortOverall, boolean isPagination) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
    }

    private boolean renderFilter(MysqlBackCtx<MysqlViewDataModel, MysqlViewDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, MysqlViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("showFilter"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        controllerParams.put("showFilter", true);
        MysqlQueryDTO queryDTO = MysqlDataModelUtil.getFilterDto(dataModelViewDTO);
        dataModelViewDTO.addQueryDto(queryDTO);
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderSort(MysqlDataModelOperation dataModelOperation, Map<String, Object> templateParams, MysqlViewDataModel useDataModelBase) throws LcdpException {
        MysqlSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(MysqlSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<MysqlSortConditionField> sortConditionFields = sortCondition.getFields();
            for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                sortConditionField.replaceFieldName();
            }
            templateParams.put("sortConditionObj", sortCondition);
            templateParams.put("isSortCondition", true);
        }
    }

    private void renderPageVo(MysqlBackCtx<MysqlViewDataModel, MysqlViewDataModelDTO> backCtx, String modelId, MysqlViewDataModelDTO dataModelViewDTO, Map<String, Object> controllerParams) {
        MysqlDataModelUtil.addQueryPageViewVo(dataModelViewDTO);
        String voEntityName = dataModelViewDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelViewDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

