/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.source.SourcePackageInfo;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.constant.MysqlConstUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.masterslave.util.MysqlMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLFLOW_MASTER_SLAVEFormQuery")
public class MysqlMsFlowFormQueryVisitor
implements MysqlOperationVisitor<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsFlowFormQueryVisitor.class);
    public static final String OPERATION_NAME = "MYSQLFLOW_MASTER_SLAVEFormQuery";

    @Override
    public void visit(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        MysqlFlowMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        MysqlDataModelBase masterTable = dataModelBase.getMasterTable();
        MysqlFlowMsDataModelDTO mysqlFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = mysqlFlowMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, MysqlDataModelBase> dataModelBaseMap = mysqlFlowMsDataModelDTO.getDataModelBaseMap();
        Map<String, MysqlDataModelBaseDTO> dataModelDtoMap = mysqlFlowMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        Map slaveTablePlusSave = (Map)operation.getParams().get("slaveTablePlusSave");
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        controllerParams.put("table", mysqlFlowMsDataModelDTO);
        controllerParams.put("returnValue", mysqlFlowMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("isPlusQuery", false);
        controllerParams.put("operationName", controllerParams.get("name"));
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            Map<String, String> slaveQueryNames;
            for (MysqlDataModelBase slaveTable : dataModelBase.getSlaveTables()) {
                capitalNameList.put(slaveTable.getName(), MysqlMasterSlaveUtil.getCapitalName(slaveTable.getName()));
            }
            controllerParams.put("boolFields", mysqlFlowMsDataModelDTO.getFields().stream().filter(o -> "boolean".equals(o.getType())).collect(Collectors.toList()));
            controllerParams.put("capitalNameList", capitalNameList);
            controllerParams.put("returnIncrementValue", mysqlFlowMsDataModelDTO.getEntityName() + "FormVO");
            controllerParams.put("slaveTable", MysqlMsFlowFormQueryVisitor.getSlaveArrayTables(mysqlFlowMsDataModelDTO, dataModelBase));
            controllerParams.put("primaryField", mysqlFlowMsDataModelDTO.getKeyPropertyName());
            controllerParams.put("pageDTO", mysqlFlowMsDataModelDTO.getEntityName() + "PageDTO");
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                controllerParams.put("isPlusQuery", true);
                break;
            }
            if (ToolUtil.isNotEmpty(slaveQueryNames = MysqlMsFlowFormQueryVisitor.getSlaveQueryName(dataModelBase))) {
                controllerParams.put("slaveQueryNames", slaveQueryNames);
            }
            MysqlDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
            backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
            MysqlMsFlowFormQueryVisitor.addFormVO(mysqlFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
            MysqlMsFlowFormQueryVisitor.addFormQueryDto(mysqlFlowMsDataModelDTO, dataModelBase, slaveTablePlusSave, backCtx);
        }
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(mysqlFlowMsDataModelDTO.getComment() + "\u8868\u5355\u67e5\u8be2");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/masterslavebackcode/get/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, mysqlFlowMsDataModelDTO.getServiceName());
        String servicePath = "template/masterslavebackcode/get/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Entity"));
        String serviceImplPath = "template/masterslavebackcode/get/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Mapper"));
        if (ToolUtil.isNotEmpty((Object)slaveTablePlusSave)) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        }
        if (ToolUtil.isNotEmpty((Object)mysqlFlowMsDataModelDTO.isHasTranslate()) && mysqlFlowMsDataModelDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addServiceImplInversion(modelId, mysqlFlowMsDataModelDTO.getMapperName());
        String mapperPath = "template/masterslavebackcode/get/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Entity"));
        Map<String, String> aliasMap = dataModelBase.getModelAliasName();
        String finalReturn = SqlReturnUtil.renderReturn(dataModelBase, aliasMap);
        controllerParams.put("return", finalReturn);
        String finalRelation = SqlReturnUtil.renderRelation(dataModelBase, dataModelBaseMap);
        controllerParams.put("relation", finalRelation);
        controllerParams.put("quoteModel", MysqlConstUtil.TRUE);
        String whereTemplate = "where ${T}.${primary} = #{id}";
        String masterTableId = masterTable.getId();
        MysqlDataModelBaseDTO mysqlDataModelBaseDTO = dataModelDtoMap.get(masterTableId);
        if (ToolUtil.isNotEmpty((Object)mysqlDataModelBaseDTO)) {
            controllerParams.put("whereSql", whereTemplate.replace("${T}", aliasMap.get(masterTableId)).replace("${primary}", mysqlDataModelBaseDTO.getKeyField().getName()));
        }
        if (ToolUtil.isNotEmpty((Object)controllerParams.get("customizeSql"))) {
            backCtx.addXmlCode(modelId, (String)controllerParams.get("customizeSql"));
        } else {
            String xmlPath = "template/masterslavebackcode/get/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "get", url, "\u8868\u5355\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        if (((Boolean)controllerParams.get("isPlusQuery")).booleanValue()) {
            ApiGenerateInfo apiGenerateInfoPlus = new ApiGenerateInfo(operation.getName() + "Plus", "data", "postJson", url + "Plus", "\u589e\u91cf\u8868\u5355\u67e5\u8be2");
            backCtx.addApi(modelId, MysqlBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfoPlus));
        }
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static void addFormVO(MysqlMsDataModelDTO dataModelBaseDTO, MysqlMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx) {
        MysqlQueryDTO queryDTO = new MysqlQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/backcode/code/formVo.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        params.put("voImport", dataModelBaseDTO.getPackageInfo().get("VO"));
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("Entity"));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("masterTable", dataModelBaseDTO.getFields());
        params.put("slaveTable", MysqlMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "FormVO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "FormVO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("VO"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        String importVOPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + queryDTO.getEntityName();
        dataModelBaseDTO.addQueryDto(queryDTO);
        backCtx.addControllerImport(modelId, importVOPath);
        backCtx.addServiceImport(modelId, importVOPath);
        backCtx.addServiceImplImport(modelId, importVOPath);
    }

    private static void addFormQueryDto(MysqlMsDataModelDTO dataModelBaseDTO, MysqlMsDataModel dataModelBase, Map<String, Boolean> slaveTablePlusSave, MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx) {
        MysqlQueryDTO queryDTO = new MysqlQueryDTO();
        String modelId = dataModelBase.getId();
        queryDTO.setFtlPath("template/backcode/code/formDto.ftl");
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("slaveTable", MysqlMsFlowFormQueryVisitor.getSlaveArrayTables(dataModelBaseDTO, dataModelBase));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("dto"));
        params.put("queryDto", queryDTO);
        params.put("priType", dataModelBaseDTO.getKeyField().getPropertyType());
        params.put("table", table);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + "PageDTO");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "PageDTO");
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
        String importDTOPath = dataModelBaseDTO.getPackageInfo().get("dto") + "." + queryDTO.getEntityName();
        backCtx.addControllerImport(modelId, importDTOPath);
        backCtx.addServiceImport(modelId, importDTOPath);
        backCtx.addServiceImplImport(modelId, importDTOPath);
    }

    private static List<MysqlDataModelBase> getSlaveArrayTables(MysqlMsDataModelDTO dataModelBaseDTO, MysqlMsDataModel dataModelBase) {
        CopyOnWriteArrayList<MysqlDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<MysqlDataModelBase>(dataModelBase.getSlaveTables());
        for (MysqlDataModelBase slaveArrayTable : slaveArrayTables) {
            for (SourcePackageInfo sourcePackageInfo : dataModelBaseDTO.getSourcePackageInfos()) {
                if (!"object".equals(sourcePackageInfo.getDataType()) || !slaveArrayTable.getName().equals(sourcePackageInfo.getObjectEnName())) continue;
                slaveArrayTables.remove(slaveArrayTable);
            }
        }
        return slaveArrayTables;
    }

    private static Map<String, String> getSlaveQueryName(MysqlFlowMsDataModel dataModelBase) {
        List<MysqlDataModelOperation> operations = dataModelBase.getOperations();
        HashMap<String, String> slaveQueryNameMap = new HashMap<String, String>();
        List<MysqlDataModelBase> slaveTables = dataModelBase.getSlaveTables();
        if (ToolUtil.isNotEmpty(slaveTables)) {
            block0: for (MysqlDataModelOperation operation : operations) {
                if (!ToolUtil.isNotEmpty((Object)operation) || !"SlaveQuery".equals(operation.getType()) || !ToolUtil.isNotEmpty((Object)operation.getName()) || !ToolUtil.isNotEmpty(operation.getParams()) || !ToolUtil.isNotEmpty((Object)operation.getParams().get("slaveModelId"))) continue;
                String slaveModelId = operation.getParams().get("slaveModelId").toString();
                for (MysqlDataModelBase slaveTable : slaveTables) {
                    if (!ToolUtil.isNotEmpty((Object)slaveTable) || !ToolUtil.isNotEmpty((Object)slaveModelId) || !slaveModelId.equals(slaveTable.getId())) continue;
                    slaveQueryNameMap.put(operation.getParams().get("slaveModelId").toString(), operation.getName());
                    continue block0;
                }
            }
        }
        return slaveQueryNameMap;
    }
}

