/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.element.view.MysqlViewDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.view.MysqlViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslate;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlPublicEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlTranslateUtil;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="MYSQLVIEWENCLOSURE")
public class MysqlViewEnclosure
implements MysqlEnclosure<MysqlViewDataModel> {
    public static final String ENCLOSURE = "MYSQLVIEWENCLOSURE";

    @Override
    public MysqlDataModelBaseDTO enclosure(MysqlViewDataModel dataModelBase) throws CloneNotSupportedException, LcdpException {
        List<MysqlTranslate> translates;
        MysqlViewDataModelDTO dataModelViewDTO = new MysqlViewDataModelDTO();
        dataModelViewDTO.setUseMybatisPlus(true);
        MysqlPublicEnclosure.enclosure(dataModelBase, dataModelViewDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelViewDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isNotEmpty(translates = dataModelBase.getTranslate())) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = MysqlTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<MysqlDataModelFieldDto> fields = dataModelViewDTO.getFields();
                block0: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (MysqlDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        continue block0;
                    }
                }
                dataModelViewDTO.setFields(fields);
                dataModelViewDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelViewDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<MysqlDataModelFieldDto> translateShowFields = MysqlTranslateUtil.getTranslateShowFields(translates);
            for (MysqlDataModelFieldDto mysqlDataModelFieldDto : translateShowFields) {
                if (null == mysqlDataModelFieldDto.getColumnType() || null == mysqlDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelViewDTO.addEntityImport(mysqlDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelViewDTO.setTranslateShowFields(translateShowFields);
        }
        return dataModelViewDTO;
    }
}

