/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.flow.baseflow;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlBaseRender;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLFLOWTaskEndorsement")
public class MysqlTaskEndorsementCodeVisitor
implements MysqlOperationVisitor<MysqlFlowDataModel, MysqlFlowDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlTaskEndorsementCodeVisitor.class);
    public static final String OPERATION_NAME = "MYSQLFLOWTaskEndorsement";

    @Override
    public void visit(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, MysqlDataModelOperation operation) throws LcdpException, IOException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        MysqlFlowDataModelDTO dataModelBaseDto = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(operation, dataModelBaseDto);
        String controllerPath = "template/flowbackcode/baseflowbackcode/taskendorsement/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDto);
        backCtx.addControllerInversion(modelId, dataModelBaseDto.getServiceName());
        String servicePath = "template/flowbackcode/baseflowbackcode/taskendorsement/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String implPath = "template/flowbackcode/baseflowbackcode/taskendorsement/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)implPath, controllerParams));
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", dataModelBaseDto.getApiPrefix() + "/" + operation.getName(), "\u4efb\u52a1\u52a0\u7b7e", null);
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, String modelId, MysqlFlowDataModelDTO dataModelBaseDto) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDto.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.manage.engine.TaskEngineService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.workflow.engine.constant.BpmConstant");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getImportInfo());
    }

    private Map<String, Object> initParams(MysqlDataModelOperation operation, MysqlFlowDataModelDTO dataModelBaseDto) {
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("flowDatasourceName", MysqlDataSourceUtil.getDefaultDataSourceName());
        controllerParams.put("table", dataModelBaseDto);
        controllerParams.put("parameter", dataModelBaseDto.getQueryDtoMap().get(dataModelBaseDto.getName()).getEntityName());
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(dataModelBaseDto.getComment() + "\u4efb\u52a1\u52a0\u7b7e");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        return controllerParams;
    }
}

