<#include "../../../auditLog/ds.ftl">
@Override
<#if !isRemote>${ds!}</#if>
public ApiResponse<ResultProcessVO> ${name!}(${parameter!} ${parameter?uncap_first!}){
    try{
    ${table.entityName} ${table.EName} = ${parameter?uncap_first!}.getFormdata();
    String processDefinitionKey = ${parameter?uncap_first!}.getProcessDefinitionKey() == null ? "" : ${parameter?uncap_first!}.getProcessDefinitionKey();
    <#if fillCode??>
        ${fillCode!}
    </#if>
    /* @begin ${name!}1 #自定义代码 */
    /* @end ${name!}1 */
    this.saveOrUpdate(${table.EName});
    /* @begin ${name!}2 #自定义代码 */
    /* @end ${name!}2 */
    <#if primaryField?? && primaryField != "">
        String businessKey = String.valueOf(${table.EName!}.get${primaryField!}());
    </#if>
    <#if securityLevel?? && securityLevel != "">
        Integer securityLevel = HussarUtils.isEmpty(${table.EName}.get${securityLevel!}()) ? null : Integer.valueOf(${table.EName}.get${securityLevel!}());
    </#if>
    ApiResponse<ResultProcessVO> flowApiResponse = this.startSaveProcessInstance(processDefinitionKey,businessKey<#if securityLevel?? && securityLevel != "">, securityLevel</#if>);
    if(flowApiResponse.isSuccess()){
    return ApiResponse.success(flowApiResponse.getData());
    }
    throw new HussarException(flowApiResponse.getMsg());
    } catch(Exception e){
    throw new HussarException(e.getMessage(),e);
    }
    }

    @Override
    ${ds!}
    ${dataSourceAnnotation!}
    public ApiResponse<ResultProcessVO> startSaveProcessInstance(String processDefinitionKey,String businessKey<#if securityLevel?? && securityLevel != "">, Integer securityLevel</#if>) {
        BpmResponseResult isstartResult;
        ResultProcessVO resultProcessVO = new ResultProcessVO();
        resultProcessVO.setProcessKey(processDefinitionKey);
        resultProcessVO.setBusinessId(businessKey);
        try {
        isstartResult = InstanceEngineService.checkProcessInstByBusinessKey(businessKey);
        if (BpmConstant.SUCCESS_CODE.equals(isstartResult.getCode())) {
        if(HussarUtils.isEmpty(BaseSecurityUtil.getUser())){
        <#if table?? && table.transDisposition?? && table.transDisposition>
        throw new HussarException(TfModelEnum.TF_FAILED_T0_OBTAIN_USER_INFORMATION.getMessage());
        <#else>
        throw new HussarException("获取用户信息失败");
        </#if>
        }
        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
        BpmResponseResult startResult;
        <#if securityLevel?? && securityLevel != "">
            Map<String, Object> variables = new HashMap<>();
            variables.put(BpmConstant.SECURITY_LEVEL, securityLevel);
        </#if>
        startResult = InstanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, deptId, businessKey, <#if securityLevel?? && securityLevel != "">variables<#else>null</#if>);
        if (BpmConstant.SUCCESS_CODE.equals(startResult.getCode())) {
        if(HussarUtils.isNotEmpty(startResult.getResult())
                && HussarUtils.isNotEmpty(startResult.getResult().get(0)) ){
            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(startResult.getResult().get(0)));
            resultProcessVO.setTaskDefKey(jsonObject.getString("taskDefinitionKey"));
            resultProcessVO.setTaskId(jsonObject.getString("taskId"));
            resultProcessVO.setTaskType(jsonObject.getString("taskType"));
        }
        return ApiResponse.success(resultProcessVO);
        } else {
        throw new HussarException(startResult.getMsg());
        }
        } else {
        return ApiResponse.success(resultProcessVO);
        }
        } catch(Exception e) {
        throw new HussarException(e.getMessage(),e);
        }
        }
