/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableField;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableIndex;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EnclosureUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.dataset.ValueObjectProperty;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlModelFunction;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlEditDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.index.MysqlDataModelIndex;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class MysqlDataModelUtil {
    public static final String PAGE_VO = "PageVO";
    public static final String SLAVE_PAGE_VO = "SlavePageVO";
    private static final Pattern TPATTERN = Pattern.compile("[A-Z0-9]");

    public static MysqlDataModelBase transfer(DataModelBase dataModelBase) throws LcdpException {
        MysqlModelFunction modelFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(dataModelBase.getFunctionType());
        return modelFunction.parseDataModel(DataModelUtil.getDataModelJson((String)dataModelBase.getId()));
    }

    public static MysqlDataModelBase transfer(JSONObject jsonObject) throws LcdpException {
        MysqlModelFunction modelFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(String.valueOf(jsonObject.get((Object)"functionType")));
        return modelFunction.parseDataModel(jsonObject);
    }

    public static MysqlDataModelBase transfer(String jsonData) throws LcdpException {
        DataModelBase dataModel = (DataModelBase)JSONObject.parseObject((String)jsonData, DataModelBase.class);
        MysqlModelFunction modelFunction = MysqlModelBeanUtil.getFunctionModelVisitorBean(dataModel.getFunctionType());
        return modelFunction.parseDataModel(JSONObject.parseObject((String)jsonData));
    }

    public static MysqlDataModelField getModelFieldById(List<MysqlDataModelField> fields, String fieldId) {
        return fields.stream().filter(field -> HussarUtils.equals((Object)field.getId(), (Object)fieldId)).findFirst().orElseGet(MysqlDataModelField::new);
    }

    public static void addQueryPageVo(MysqlDataModelBaseDTO dataModelBaseDTO) {
        MysqlQueryDTO queryDTO = new MysqlQueryDTO();
        queryDTO.setFtlPath("template/backcode/code/page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static void addSlaveQueryPageVo(MysqlDataModelBaseDTO dataModelBaseDTO, MysqlDataModelOperation dataModelOperation) {
        MysqlQueryDTO queryDTO = new MysqlQueryDTO();
        queryDTO.setFtlPath("template/backcode/code/slave_page.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setName(dataModelBaseDTO.getName() + SLAVE_PAGE_VO);
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + SLAVE_PAGE_VO);
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "VO".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }

    public static String camelToUnderLine(String str) {
        Matcher matcher = TPATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void addQueryPageViewVo(MysqlDataModelBaseDTO dataModelBaseDTO) {
        MysqlDataModelUtil.addQueryPageVo(dataModelBaseDTO);
    }

    public static void addQueryPageMsVo(MysqlDataModelBaseDTO msdataModelBaseDTO) {
        MysqlDataModelUtil.addQueryPageVo(msdataModelBaseDTO);
    }

    public static MysqlQueryDTO getQueryDto(DataSet dataSet, MysqlDataModelBaseDTO dataModelDTO) {
        MysqlQueryDTO queryDto;
        block4: {
            block3: {
                queryDto = new MysqlQueryDTO();
                queryDto.setId(dataSet.getId());
                queryDto.setName(EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null));
                queryDto.setComment(dataSet.getComment());
                Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
                queryDto.setPackageInfo(packageInfo.get("dto"));
                queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataSet.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
                queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
                queryDto.setFtlPath("template/backcode/code/queryDto.ftl");
                HashMap<String, Object> params = new HashMap<String, Object>();
                HashMap<String, Boolean> table = new HashMap<String, Boolean>();
                table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
                params.put("table", table);
                params.put("queryDto", queryDto);
                queryDto.setParams(params);
                queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
                if (!HussarUtils.equals((Object)dataSet.getDataSetObject().getObjectType(), (Object)ComponentData.DataSetObjectTypeEnum.DATA_MODEL.getValue())) break block3;
                queryDto.setDataModel(true);
                if (!ToolUtil.isNotEmpty(dataModelDTO.getFields())) break block4;
                for (MysqlDataModelFieldDto field : dataModelDTO.getFields()) {
                    MysqlQueryFieldDTO queryVOFieldDto = new MysqlQueryFieldDTO();
                    queryVOFieldDto.setComment(field.getComment());
                    queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)field.getColumnType().getType()));
                    queryVOFieldDto.setPropertyName(field.getName());
                    queryDto.addVOField(queryVOFieldDto);
                }
                break block4;
            }
            if (ToolUtil.isNotEmpty((Object)dataSet.getDataSetObject().getProperties())) {
                List<MysqlQueryFieldDTO> queryVOFields = MysqlDataModelUtil.addQueryVOField(dataSet.getDataSetObject().getProperties(), queryDto);
                for (MysqlQueryFieldDTO queryVOField : queryVOFields) {
                    queryDto.addVOField(queryVOField);
                }
            }
        }
        return queryDto;
    }

    public static MysqlQueryDTO getFilterDto(MysqlDataModelBaseDTO dataModelDTO) {
        MysqlQueryDTO queryDto = new MysqlQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setImports(Collections.singleton(dataModelDTO.getImportInfo().get("Entity")));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)dataModelDTO.getName(), (NamingStrategy)NamingStrategy.underline_to_camel, null)) + "SelectCondition");
        queryDto.setFtlPath("template/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("queryDto", queryDto);
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static MysqlQueryDTO getTotalQueryDto(MysqlDataModelBaseDTO dataModelDTO) {
        MysqlQueryDTO queryDto = new MysqlQueryDTO();
        Map<String, String> packageInfo = dataModelDTO.getPackageInfo();
        queryDto.setPackageInfo(packageInfo.get("dto"));
        queryDto.setEntityName(NamingStrategy.capitalFirst((String)EnclosureUtil.processName((String)(dataModelDTO.getName() + "TotalQuery"), (NamingStrategy)NamingStrategy.underline_to_camel, null)));
        queryDto.setWriteFilePath(dataModelDTO.getTablePath().toLowerCase() + File.separator + "dto" + File.separator + queryDto.getEntityName() + ".java");
        queryDto.setFtlPath("template/backcode/code/filter.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        params.put("queryDto", queryDto);
        params.put("table", table);
        queryDto.setParams(params);
        queryDto.setImportInfo(queryDto.getPackageInfo() + "." + queryDto.getEntityName());
        return queryDto;
    }

    public static List<MysqlQueryFieldDTO> addQueryVOField(List<ValueObjectProperty> properties, MysqlQueryDTO queryDto) {
        ArrayList<MysqlQueryFieldDTO> children = new ArrayList<MysqlQueryFieldDTO>();
        for (ValueObjectProperty property : properties) {
            MysqlQueryFieldDTO queryVOFieldDto = new MysqlQueryFieldDTO();
            queryVOFieldDto.setComment(property.getComment());
            queryVOFieldDto.setDbColumnType(DataModelFieldTypeConvert.getDbColumnType((String)property.getBaseDataType()));
            queryVOFieldDto.setType(property.getBaseDataType());
            queryVOFieldDto.setPropertyName(property.getName());
            if (ToolUtil.isNotEmpty((Object)property.getProperties())) {
                queryVOFieldDto.setChildren(MysqlDataModelUtil.addQueryVOField(property.getProperties(), queryDto));
            }
            children.add(queryVOFieldDto);
            if (null == queryVOFieldDto.getDbColumnType() || null == queryVOFieldDto.getDbColumnType().getImportT()) continue;
            queryDto.addImport(queryVOFieldDto.getDbColumnType().getImportT());
        }
        return children;
    }

    public static PropertyType getEntityPropertyType(String type, MysqlDataModelBaseDTO dataModelDto) {
        PropertyType propertyType = null;
        if (ToolUtil.isNotEmpty((Object)type)) {
            propertyType = new PropertyType();
            propertyType.setImportT(dataModelDto.getImportInfo().get("Entity"));
            String modelName = dataModelDto.getEntityName();
            if (HussarUtils.equals((Object)type, (Object)"array")) {
                propertyType.setType("List<${model}>".replace("${model}", modelName));
            } else if (HussarUtils.equals((Object)type, (Object)"object")) {
                propertyType.setType(modelName);
            }
        }
        return propertyType;
    }

    public static ContrastVO<MysqlDataModelField> contrastWith(List<TableField> tableFields, List<MysqlDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<MysqlDataModelField> delFields = new ArrayList<MysqlDataModelField>();
        ArrayList<MysqlDataModelField> modifyFields = new ArrayList<MysqlDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!HussarUtils.equals((Object)modelFields.get(i).getSourceFieldName(), (Object)tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().toLowerCase().equals(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(MysqlDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        addFields = MysqlDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<MysqlDataModelField> contrastWithIgnoreCase(List<TableField> tableFields, List<MysqlDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        List<Object> addFields = new ArrayList();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        ArrayList<MysqlDataModelField> delFields = new ArrayList<MysqlDataModelField>();
        ArrayList<MysqlDataModelField> modifyFields = new ArrayList<MysqlDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!HussarUtils.equals((Object)modelFields.get(i).getSourceFieldName(), (Object)tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().toLowerCase().equals(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot()) break;
                modifyFields.add(MysqlDataModelUtil.tabTransmodelOne(tableFields.get(j), modelFields.get(i).getId()));
            }
            if (flag) continue;
            delFields.add(modelFields.get(i));
        }
        addFields = MysqlDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastVO<MysqlDataModelField> mcontrastWith(List<TableField> tableFields, List<MysqlDataModelField> modelFields) {
        ContrastVO contrast = new ContrastVO();
        ArrayList<MysqlDataModelField> addFields = new ArrayList<MysqlDataModelField>();
        ArrayList<TableField> addTableFields = new ArrayList<TableField>();
        CollectionUtils.addAll(addTableFields, (Object[])new Object[tableFields.size()]);
        Collections.copy(addTableFields, tableFields);
        List<Object> delFields = new ArrayList();
        ArrayList<MysqlDataModelField> modifyFields = new ArrayList<MysqlDataModelField>();
        for (int i = 0; i < modelFields.size(); ++i) {
            boolean flag = false;
            for (int j = 0; j < tableFields.size(); ++j) {
                if (!HussarUtils.equals((Object)modelFields.get(i).getSourceFieldName(), (Object)tableFields.get(j).getName())) continue;
                flag = true;
                addTableFields.remove(tableFields.get(j));
                if (modelFields.get(i).getSourceDataType().toLowerCase().equals(tableFields.get(j).getType()) && modelFields.get(i).getDataIsEmpty() == tableFields.get(j).getDataIsEmpty() && modelFields.get(i).getDataLength() == tableFields.get(j).getDataLength() && modelFields.get(i).getDataDot() == tableFields.get(j).getDataDot() && HussarUtils.equals((Object)modelFields.get(i).getComment(), (Object)tableFields.get(j).getComment()) && "primary".equals(modelFields.get(i).getUsage()) == HussarUtils.equals((Object)"PRI", (Object)tableFields.get(j).getPrimarys())) break;
                modifyFields.add(modelFields.get(i));
            }
            if (flag) continue;
            addFields.add(modelFields.get(i));
        }
        delFields = MysqlDataModelUtil.tabTransmodel(addTableFields);
        contrast.setAddFields(addFields);
        contrast.setDelFields(delFields);
        contrast.setModifyFields(modifyFields);
        return contrast;
    }

    public static ContrastIndexVO<MysqlDataModelIndex> contrastIndexWith(List<TableIndex> tableIndexs, List<MysqlDataModelIndex> modelIndexs, TableCorrespond modelFislds) {
        boolean flag;
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<MysqlDataModelIndex> addIndexs = new ArrayList<MysqlDataModelIndex>();
        ArrayList<MysqlDataModelIndex> delIndexs = new ArrayList<MysqlDataModelIndex>();
        if (!HussarUtils.isEmpty(tableIndexs)) {
            if (!HussarUtils.isEmpty(modelIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(modelIndexs.get(i));
                        addIndexs.add(MysqlDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                    }
                    if (flag) continue;
                    delIndexs.add(modelIndexs.get(i));
                }
                addIndexs.addAll(MysqlDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(MysqlDataModelUtil.tabTransmodelIndex(tableIndexs));
            }
        } else if (!HussarUtils.isEmpty(modelIndexs)) {
            delIndexs.addAll(modelIndexs);
        }
        if (HussarUtils.isNotEmpty((Object)modelFislds)) {
            List modifyFields;
            ArrayList fields = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)modelFislds.getAddFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getAddFields(), MysqlDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)modelFislds.getDelFields())) {
                fields.addAll(JSONArray.parseArray((String)modelFislds.getDelFields(), MysqlDataModelField.class));
            }
            if (HussarUtils.isNotEmpty((Object)(modifyFields = JSONArray.parseArray((String)modelFislds.getModifyFields(), MysqlEditDataModelField.class)))) {
                fields.addAll(modifyFields.stream().map(MysqlEditDataModelField::getNewField).collect(Collectors.toList()));
            }
            flag = false;
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(delIndexs)) {
                Iterator iterator = delIndexs.iterator();
                while (iterator.hasNext()) {
                    MysqlDataModelIndex delIndex = (MysqlDataModelIndex)((Object)iterator.next());
                    for (MysqlDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(delIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
            if (HussarUtils.isNotEmpty(fields) && HussarUtils.isNotEmpty(addIndexs)) {
                Iterator iterator = addIndexs.iterator();
                while (iterator.hasNext()) {
                    MysqlDataModelIndex addIndex = (MysqlDataModelIndex)((Object)iterator.next());
                    for (MysqlDataModelField field : fields) {
                        if (!field.getSourceFieldName().equals(addIndex.getColumnName())) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        iterator.remove();
                        continue;
                    }
                    flag = false;
                }
            }
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static ContrastIndexVO<MysqlDataModelIndex> mcontrastIndexWith(List<TableIndex> tableIndexs, List<MysqlDataModelIndex> modelIndexs) {
        ContrastIndexVO index = new ContrastIndexVO();
        ArrayList<MysqlDataModelIndex> addIndexs = new ArrayList<MysqlDataModelIndex>();
        ArrayList<MysqlDataModelIndex> delIndexs = new ArrayList<MysqlDataModelIndex>();
        if (!HussarUtils.isEmpty(modelIndexs)) {
            if (!HussarUtils.isEmpty(tableIndexs)) {
                ArrayList<TableIndex> addTableIndexs = new ArrayList<TableIndex>();
                CollectionUtils.addAll(addTableIndexs, (Object[])new Object[tableIndexs.size()]);
                Collections.copy(addTableIndexs, tableIndexs);
                for (int i = 0; i < modelIndexs.size(); ++i) {
                    boolean flag = false;
                    for (int j = 0; j < tableIndexs.size(); ++j) {
                        if (!tableIndexs.get(j).getIndexName().equalsIgnoreCase(modelIndexs.get(i).getIndexName())) continue;
                        flag = true;
                        addTableIndexs.remove(tableIndexs.get(j));
                        if (modelIndexs.get(i).isChkUnique() == (tableIndexs.get(j).getIsNonUnique() == 0) && modelIndexs.get(i).getColumnName().equals(tableIndexs.get(j).getColumnName())) break;
                        delIndexs.add(MysqlDataModelUtil.tabTransmodelIndexOne(tableIndexs.get(j), modelIndexs.get(i).getIndexName()));
                        addIndexs.add(modelIndexs.get(i));
                    }
                    if (flag) continue;
                    addIndexs.add(modelIndexs.get(i));
                }
                delIndexs.addAll(MysqlDataModelUtil.tabTransmodelIndex(addTableIndexs));
            } else {
                addIndexs.addAll(modelIndexs);
            }
        } else if (!HussarUtils.isEmpty(tableIndexs)) {
            delIndexs.addAll(MysqlDataModelUtil.tabTransmodelIndex(tableIndexs));
        }
        index.setAddIndexs(addIndexs);
        index.setDelIndexs(delIndexs);
        return index;
    }

    public static List<MysqlDataModelField> tabTransmodel(List<TableField> tableFields) {
        ArrayList<MysqlDataModelField> modelFields = new ArrayList<MysqlDataModelField>();
        tableFields.forEach(tab -> {
            MysqlDataModelField field = new MysqlDataModelField();
            field.setSourceFieldName(tab.getName());
            field.setDataIsEmpty(tab.getDataIsEmpty());
            field.setDataLength(tab.getDataLength());
            field.setDataDot(tab.getDataDot());
            field.setComment(tab.getComment());
            field.setSourceDataType(tab.getType().toUpperCase());
            if ("PRI".equals(tab.getPrimarys())) {
                field.setUsage("primary");
            }
            modelFields.add(field);
        });
        return modelFields;
    }

    public static MysqlDataModelField tabTransmodelOne(TableField tableFields, String id) {
        MysqlDataModelField field = new MysqlDataModelField();
        field.setId(id);
        field.setSourceFieldName(tableFields.getName());
        field.setDataIsEmpty(tableFields.getDataIsEmpty());
        field.setDataLength(tableFields.getDataLength());
        field.setDataDot(tableFields.getDataDot());
        field.setComment(tableFields.getComment());
        if ("PRI".equals(tableFields.getPrimarys())) {
            field.setUsage("primary");
        }
        field.setSourceDataType(tableFields.getType().toUpperCase());
        return field;
    }

    public static List<MysqlDataModelIndex> tabTransmodelIndex(List<TableIndex> tableIndexs) {
        ArrayList<MysqlDataModelIndex> modelIndexs = new ArrayList<MysqlDataModelIndex>();
        if (HussarUtils.isNotEmpty(tableIndexs)) {
            tableIndexs.forEach(tab -> {
                MysqlDataModelIndex index = new MysqlDataModelIndex();
                index.setIndexName(tab.getIndexName());
                index.setChkUnique(tab.getIsNonUnique() == 0);
                index.setTableSchema(tab.getTableSchema());
                index.setColumnName(tab.getColumnName().toUpperCase());
                index.setIndexType(tab.getIndexType());
                index.setTableName(tab.getTableName().toUpperCase());
                modelIndexs.add(index);
            });
        }
        return modelIndexs;
    }

    public static MysqlDataModelIndex tabTransmodelIndexOne(TableIndex tableIndex, String indexName) {
        MysqlDataModelIndex index = new MysqlDataModelIndex();
        index.setIndexName(indexName);
        index.setChkUnique(tableIndex.getIsNonUnique() == 0);
        index.setTableSchema(tableIndex.getTableSchema());
        index.setColumnName(tableIndex.getColumnName().toUpperCase());
        index.setIndexType(tableIndex.getIndexType());
        index.setTableName(tableIndex.getTableName().toUpperCase());
        return index;
    }
}

