/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.element.customview;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryObject;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MysqlCustomViewModel
extends MysqlDataModelBase {
    private static final Logger logger = LoggerFactory.getLogger(MysqlDataModelBase.class);
    public static final String FUNCTION_TYPE = "CUSTOM_VIEW";
    private String viewSql;
    public static final Logger LOGGER = LoggerFactory.getLogger(MysqlBaseDataModel.class);
    private String sourceDataModelName;
    private List<MysqlQueryCondition> queryConditions;
    private List<MysqlQueryObject> queryObject;
    private List<MysqlSortCondition> sortCondition;
    private List<MysqlDataModelField> addFields;
    private List<MysqlDataModelField> delFields;
    private List<MysqlDataModelField> editFields;

    public String getViewSql() {
        return this.viewSql;
    }

    public void setViewSql(String viewSql) {
        this.viewSql = viewSql;
    }

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"MYSQL.CUSTOM_VIEW", MysqlCustomViewModel.class);
    }

    @Override
    public MysqlCustomViewModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        MysqlCustomViewModel customSqlModel;
        try {
            customSqlModel = (MysqlCustomViewModel)JSONObject.parseObject((String)jsonObject.toString(), MysqlCustomViewModel.class);
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return customSqlModel;
    }

    public MysqlEnclosure enclosure() throws LcdpException {
        return null;
    }

    public MysqlRender render() throws LcdpException {
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<MysqlQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<MysqlQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<MysqlQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<MysqlQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<MysqlSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (MysqlSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (MysqlSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = MysqlDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<MysqlSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<MysqlDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<MysqlDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<MysqlDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<MysqlDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<MysqlDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<MysqlDataModelField> editFields) {
        this.editFields = editFields;
    }

    @Override
    public MysqlQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (MysqlQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new MysqlQueryCondition();
    }

    @Override
    public MysqlSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (MysqlSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new MysqlSortCondition();
    }
}

