/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlBaseRender;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.constant.MysqlConstUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLMASTER_SLAVETableQuery")
public class MysqlMsTableQueryVisitor
implements MysqlOperationVisitor<MysqlMsDataModel, MysqlMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsTableQueryVisitor.class);
    public static final String OPERATION_NAME = "MYSQLMASTER_SLAVETableQuery";

    @Override
    public void visit(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        MysqlMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        MysqlMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String mastId = useDataModelBase.getMasterTable().getId();
        MysqlDataModelFieldDto fieldDto = dataModelBaseDTO.getDataModelDtoMap().get(mastId).getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            String securityLevelSql = useDataModelBase.getModelAliasName().get(mastId) + "." + fieldDto.getName() + " &lt;= #{securityLevel}";
            controllerParams.put("securityLevelSql", securityLevelSql);
            hasSecurityLevel = true;
        }
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, backCtx.getUseDataModelBase(), isPagination);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/masterslavebackcode/query/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/masterslavebackcode/query/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/masterslavebackcode/query/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/masterslavebackcode/query/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/masterslavebackcode/query/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSelectCondition, isSortCondition, isSortOverall, hasSecurityLevel);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, String modelId, MysqlMsDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSelectCondition, boolean isSortCondition, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
        } else if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelect(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, MysqlMsDataModelDTO dataModelBaseDTO, Map<String, Object> templateParams) {
        MysqlMsDataModel msDataModel = backCtx.getUseDataModelBase();
        MysqlDataModelField deleteField = msDataModel.getDeleteFlag();
        boolean isLogicallyDelete = msDataModel.isLogicallyDelete();
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        if (!StringUtil.isNotBlank((CharSequence)selectConditionName)) {
            if (isLogicallyDelete) {
                templateParams.put("addLogicallyCondition", true);
                String logicallyFlag = msDataModel.getModelAliasName().get(msDataModel.getMasterTable().getId()) + "." + deleteField.getSourceFieldName();
                templateParams.put("logicallyFlag", logicallyFlag);
            }
            return false;
        }
        MysqlQueryCondition queryCondition = backCtx.getUseDataModelBase().getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)templateParams.get("securityLevel"))) {
            MysqlQueryConditionField oredElse;
            boolean flag = true;
            if (ToolUtil.isNotEmpty((Object)queryCondition) && ToolUtil.isNotEmpty(queryCondition.getFields()) && ToolUtil.isNotEmpty((Object)(oredElse = (MysqlQueryConditionField)queryCondition.getFields().stream().filter(item -> "securityLevel".equals(item.getUsageType())).findFirst().orElse(null)))) {
                flag = false;
            }
            if (flag) {
                MysqlDataModelFieldDto fieldDto = (MysqlDataModelFieldDto)templateParams.get("securityLevel");
                MysqlQueryConditionField field = new MysqlQueryConditionField();
                field.setConnect("and");
                field.setFromModelField(fieldDto.getId());
                field.setQueryAttrName(fieldDto.getPropertyName());
                field.setFromModelId(backCtx.getUseDataModelBase().getMasterTable().getId());
                field.setType("row");
                field.setSymbol("<=");
                field.setUsageType("securityLevel");
                if (HussarUtils.isEmpty(queryCondition.getFields())) {
                    ArrayList<MysqlQueryConditionField> newFields = new ArrayList<MysqlQueryConditionField>();
                    newFields.add(field);
                    queryCondition.setFields(newFields);
                } else {
                    queryCondition.getFields().add(field);
                }
            }
        }
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (MysqlQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<MysqlDataModelField> fields = backCtx.getUseDataModelBase().getFields();
            boolean isStringType = true;
            for (MysqlDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        templateParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(MysqlQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        templateParams.put("isSelectCondition", MysqlConstUtil.TRUE);
        DataSet dataSet = backCtx.getUseDataModelBase().getDataSetById(queryCondition.getFromDataSet());
        if (isLogicallyDelete) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, deleteField.getName(), msDataModel.getMasterTable().getId());
        }
        MysqlQueryDTO queryDTO = MysqlDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)templateParams.get("securityLevel"))) {
            MysqlDataModelFieldDto fieldDto = (MysqlDataModelFieldDto)templateParams.get("securityLevel");
            MysqlQueryFieldDTO field = new MysqlQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            if (HussarUtils.isEmpty(queryDTO.getQueryFields())) {
                ArrayList<MysqlQueryFieldDTO> newFields = new ArrayList<MysqlQueryFieldDTO>();
                newFields.add(field);
                queryDTO.setQueryFields(newFields);
            } else {
                queryDTO.getQueryFields().add(field);
            }
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), MysqlConstUtil.FALSE, ConnectEnum._AND.getType(), null, dataModelBaseDTO, msDataModel.getModelAliasName(), deleteField == null ? "" : deleteField.getSourceFieldName());
        if (isLogicallyDelete) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        templateParams.put("whereSql", finalWhereSql);
        templateParams.put("QueryObj", queryDTO.getEntityName());
        templateParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private boolean renderSort(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, MysqlMsDataModel useDataModelBase, boolean isPagination) throws LcdpException {
        MysqlSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(MysqlSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            if (!isPagination) {
                List<MysqlSortConditionField> sortConditionFields = sortCondition.getFields();
                for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            } else {
                List<MysqlSortConditionField> sortConditionFields = sortCondition.getFields();
                for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", MysqlConstUtil.TRUE);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private void renderPageVo(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, String modelId, MysqlMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        MysqlDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + "PageVO";
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

