/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.render;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.MysqlCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.baseapi.MysqlBaseApiDataModel;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLBASE_APIRENDER")
public class MysqlBaseApiRender
implements MysqlRender<MysqlBaseApiDataModel, MysqlBaseDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlBaseApiRender.class);
    public static final String RENDER = "MYSQLBASE_APIRENDER";

    @Override
    public List<MysqlCodeGenerateInfo> renderCode(MysqlBackCtx<MysqlBaseApiDataModel, MysqlBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<MysqlCodeGenerateInfo> mysqlCodeGenerateInfos = new ArrayList<MysqlCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        MysqlBaseDataModelDTO mysqlDataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        mysqlCodeGenerateInfos.add(this.genApiCode(mysqlDataModelBaseDTO, baseFile));
        return mysqlCodeGenerateInfos;
    }

    private MysqlCodeGenerateInfo genApiCode(MysqlBaseDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }
}

