/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.element.base;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.datasource.manager.api.model.ColumnInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.model.MetadataParam;
import com.jxdinfo.hussar.datasource.manager.api.model.TableInfoDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.model.TableInfo;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.EngineColumnTypeUtil;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.sync.CheckTable;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastIndexVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.IndexCorrespond;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.TableCorrespond;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseConnector;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlEditDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.index.MysqlDataModelIndex;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryObject;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslate;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MysqlBaseDataModel
extends MysqlDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(MysqlBaseDataModel.class);
    public static final String FUNCTION_TYPE = "BASE";
    public static final int OK = 1;
    public static final int ERROR = -1;
    public static final int UN = 0;
    private List<MysqlTranslate> translate;
    private String sourceDataModelName;
    private List<MysqlQueryCondition> queryConditions;
    private List<MysqlQueryObject> queryObject;
    private List<MysqlSortCondition> sortCondition;
    private List<MysqlDataModelField> addFields;
    private List<MysqlDataModelField> delFields;
    private List<MysqlEditDataModelField> editFields;
    private boolean logicallyDelete;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"MYSQL.BASE", MysqlBaseDataModel.class);
    }

    @Override
    public MysqlBaseDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        MysqlBaseDataModel mysqlBaseDataModel;
        try {
            mysqlBaseDataModel = (MysqlBaseDataModel)JSONObject.parseObject((String)jsonObject.toString(), MysqlBaseDataModel.class);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return mysqlBaseDataModel;
    }

    @Override
    public MysqlEnclosure<MysqlDataModelBase> enclosure() throws LcdpException {
        return MysqlModelBeanUtil.getEnclosureBean("MYSQL", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public MysqlRender<MysqlDataModelBase, MysqlDataModelBaseDTO> render() throws LcdpException {
        return MysqlModelBeanUtil.getRenderBean("MYSQL", FUNCTION_TYPE, "RENDER");
    }

    @Override
    public List<MysqlTranslate> getTranslate() {
        return this.translate;
    }

    @Override
    public void setTranslate(List<MysqlTranslate> translate) {
        this.translate = translate;
    }

    @Override
    public String getSourceDataModelName() {
        return this.sourceDataModelName;
    }

    public void setSourceDataModelName(String sourceDataModelName) {
        this.sourceDataModelName = sourceDataModelName;
    }

    public List<MysqlQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<MysqlQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<MysqlQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<MysqlQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<MysqlSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (MysqlSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (MysqlSortConditionField field : condition.getFields()) {
                    try {
                        Map<String, String> fieldMap = MysqlDataModelUtil.transfer(DataModelUtil.getDataModelJson((String)field.getFromModelIdSort())).getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName));
                        String fieldName = fieldMap.get(field.getFromModelFieldIdSort());
                        if (HussarUtils.equals((Object)fieldName, (Object)field.getFromModelFieldSort())) continue;
                        field.setFromModelFieldSort(fieldName);
                    }
                    catch (LcdpException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<MysqlSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    public List<MysqlDataModelField> getAddFields() {
        return this.addFields;
    }

    public void setAddFields(List<MysqlDataModelField> addFields) {
        this.addFields = addFields;
    }

    public List<MysqlDataModelField> getDelFields() {
        return this.delFields;
    }

    public void setDelFields(List<MysqlDataModelField> delFields) {
        this.delFields = delFields;
    }

    public List<MysqlEditDataModelField> getEditFields() {
        return this.editFields;
    }

    public void setEditFields(List<MysqlEditDataModelField> editFields) {
        this.editFields = editFields;
    }

    public boolean getLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    @Override
    public MysqlQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (MysqlQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return new MysqlQueryCondition();
    }

    @Override
    public MysqlSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.sortCondition != null) {
            for (MysqlSortCondition sortConditionBase : this.sortCondition) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return new MysqlSortCondition();
    }

    public Optional<TableInfo> findTable(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional infoOptional;
        TableInfo table = null;
        boolean findCurrentTable = false;
        List tableCorresponds = fieldsContrastParam.getTableCorresponds();
        if (tableCorresponds != null) {
            for (TableCorrespond tableCorrespond : tableCorresponds) {
                if (!this.getId().equals(tableCorrespond.getModelId())) continue;
                String changeName = tableCorrespond.getTableName().toUpperCase();
                Optional infoOptional2 = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)changeName);
                findCurrentTable = infoOptional2.isPresent();
                if (!findCurrentTable) break;
                table = (TableInfo)infoOptional2.get();
                break;
            }
        }
        if (!findCurrentTable && (findCurrentTable = (infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase())).isPresent())) {
            table = (TableInfo)infoOptional.get();
        }
        return Optional.ofNullable(table);
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> tableContrastModel(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<MysqlDataModelField> contrast = new ContrastVO<MysqlDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = MysqlDataModelUtil.contrastWith(table.getFields(), this.getFields());
            contrast.setTableFields(MysqlDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<MysqlDataModelField>> contrastVOS = new ArrayList<ContrastVO<MysqlDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> modelContrastTable(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable(fieldsContrastParam);
        ContrastVO<MysqlDataModelField> contrast = new ContrastVO<MysqlDataModelField>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = MysqlDataModelUtil.mcontrastWith(table.getFields(), this.getFields());
            contrast.setTableFields(MysqlDataModelUtil.tabTransmodel(table.getFields()));
        }
        contrast.setModelId(this.getId());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        ArrayList<ContrastVO<MysqlDataModelField>> contrastVOS = new ArrayList<ContrastVO<MysqlDataModelField>>();
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public List<ContrastIndexVO> tableContrastModelIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable((FieldsContrastParam<MysqlDataModelField>)fieldsContrastParam);
        ContrastIndexVO<MysqlDataModelIndex> contrast = new ContrastIndexVO<MysqlDataModelIndex>();
        TableCorrespond info = new TableCorrespond();
        if (HussarUtils.isNotEmpty((Object)fieldsContrastParam.getTableCorresponds())) {
            info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(0);
        }
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = MysqlDataModelUtil.contrastIndexWith(table.getIndexs(), this.getIndexList(), info);
            contrast.setTableIndexs(MysqlDataModelUtil.tabTransmodelIndex(table.getIndexs()));
        }
        contrast.setModelId(this.getId());
        ArrayList<ContrastIndexVO> contrastIndexVOS = new ArrayList<ContrastIndexVO>();
        contrastIndexVOS.add(contrast);
        return contrastIndexVOS;
    }

    @Override
    public List<ContrastIndexVO> modelContrastTableIndex(FieldsContrastParam fieldsContrastParam) throws IOException, LcdpException {
        Optional<TableInfo> infoOptional = this.findTable((FieldsContrastParam<MysqlDataModelField>)fieldsContrastParam);
        ContrastIndexVO<MysqlDataModelIndex> contrast = new ContrastIndexVO<MysqlDataModelIndex>();
        if (infoOptional.isPresent()) {
            TableInfo table = infoOptional.get();
            contrast = MysqlDataModelUtil.mcontrastIndexWith(table.getIndexs(), this.getIndexList());
            contrast.setTableIndexs(MysqlDataModelUtil.tabTransmodelIndex(table.getIndexs()));
        }
        contrast.setModelId(this.getId());
        ArrayList<ContrastIndexVO> contrastIndexVOS = new ArrayList<ContrastIndexVO>();
        contrastIndexVOS.add(contrast);
        return contrastIndexVOS;
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> findTableContrast() throws IOException, LcdpException {
        ArrayList<ContrastVO<MysqlDataModelField>> contrastVOS = new ArrayList<ContrastVO<MysqlDataModelField>>();
        ContrastVO contrast = new ContrastVO();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase());
        contrast.setTableContrast(Integer.valueOf(infoOptional.isPresent() ? 0 : 1));
        contrast.setModelId(this.getId());
        contrastVOS.add(contrast);
        return contrastVOS;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO contrastVOS = new PublishCheckVO();
        contrastVOS.setModelId(modelId);
        ArrayList<CheckTable> contrast = new ArrayList<CheckTable>();
        CheckTable info = new CheckTable();
        long start = System.currentTimeMillis();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase());
        LOGGER.info("\u53d1\u5e03\u65f6\u6821\u9a8c\u67e5\u8be2\u5355\u8868{}\u8017\u65f6\uff1a{}", (Object)this.sourceDataModelName.toUpperCase(), (Object)ToolUtil.logTime((long)start));
        if (!infoOptional.isPresent()) {
            info.setState(Integer.valueOf(0));
        } else {
            TableInfo table = (TableInfo)infoOptional.get();
            if (ToolUtil.isNotEmpty((Object)table)) {
                ContrastVO<MysqlDataModelField> model = MysqlDataModelUtil.contrastWith(table.getFields(), this.getFields());
                if (model.getAddFields().size() == 0 && model.getDelFields().size() == 0 && model.getModifyFields().size() == 0) {
                    info.setState(Integer.valueOf(2));
                } else {
                    info.setState(Integer.valueOf(1));
                }
            } else {
                info.setState(Integer.valueOf(0));
            }
        }
        info.setModelId(this.getId());
        contrast.add(info);
        contrastVOS.setDetails(contrast);
        return contrastVOS;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        int x;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return false;
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        IndexCorrespond indexInfo = new IndexCorrespond();
        boolean findTable = false;
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (fieldsContrastParam.getIndexCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getIndexCorresponds().size(); ++x) {
                if (!this.getId().equals(((IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x)).getModelId())) continue;
                indexInfo = (IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (!findTable) {
            return true;
        }
        boolean findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase()).isPresent();
        if (!findCurrentTable) {
            this.creatTabs(datasourceLr);
        } else {
            this.editTabs(datasourceLr, (TableCorrespond<MysqlDataModelField>)info, indexInfo);
        }
        return true;
    }

    public int creatTabs(SysDataSource datasourceLr) {
        MetadataParam metadataParam = new MetadataParam();
        TableInfoDto tableInfoDto = MysqlBaseConnector.tableInfoInCreate(datasourceLr, this);
        metadataParam.setTableInfo(tableInfoDto);
        metadataParam.setColumnInfo(MysqlBaseConnector.transferColumn(this.getFields(), ""));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.createTable(metadataParam);
        return 1;
    }

    public int editTabs(SysDataSource datasourceLr, TableCorrespond<MysqlDataModelField> info, IndexCorrespond indexInfo) throws Exception {
        MetadataParam paramData = new MetadataParam();
        TableInfoDto tableInfoDto = MysqlBaseConnector.tableInfoInEdit(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), MysqlDataModelField.class);
        if (!HussarUtils.isEmpty((Object)delFields)) {
            for (int y = 0; y < delFields.size(); ++y) {
                ColumnInfoDto del = new ColumnInfoDto();
                del.setColumnName(((MysqlDataModelField)((Object)delFields.get(y))).getSourceFieldName());
                deletedCols.add(del);
            }
        }
        paramData.setDeletedCols(deletedCols);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), MysqlDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), MysqlEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        String oldTableName = !HussarUtils.isEmpty((Object)info.getOldTableName()) ? info.getOldTableName() : indexInfo.getOldTableName();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)oldTableName.toUpperCase());
        if (!infoOptional.isPresent()) {
            return 0;
        }
        TableInfo table = (TableInfo)infoOptional.get();
        List<ColumnInfoDto> oldColumn = this.transform(MysqlDataModelUtil.tabTransmodel(table.getFields()));
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        ddlService.editTable(paramData, oldColumn, info.getOldTableName());
        return 1;
    }

    public List<ColumnInfoDto> transformDto(List<MysqlDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (!HussarUtils.isEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                Optional engineColumnType;
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getComment());
                columnInfo.setColumnAlias(getFields.get(i).getName());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                    columnInfo.setPrimarys("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setDataType(getFields.get(i).getSourceDataType());
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
                columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getDataIsEmpty() ? 1 : 0));
                if (!"all".equals(state)) {
                    columnInfo.setOperation(state);
                }
                if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getDataType())).isPresent()) {
                    columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                    columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
                }
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transformEdit(List<MysqlEditDataModelField> getFields, String state) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (!HussarUtils.isEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                Optional engineColumnType;
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getNewField().getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getNewField().getComment());
                columnInfo.setColumnAlias(getFields.get(i).getNewField().getName());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getNewField().getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                    columnInfo.setPrimarys("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getNewField().getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setPurpose(getFields.get(i).getNewField().getUsage());
                columnInfo.setOldColumnName(getFields.get(i).getOldField().getSourceFieldName());
                columnInfo.setDataType(getFields.get(i).getNewField().getSourceDataType());
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getNewField().getDataDot()));
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getNewField().getDataLength()));
                columnInfo.setDataIsEmpty(Integer.valueOf(getFields.get(i).getNewField().getDataIsEmpty() ? 1 : 0));
                if (!"all".equals(state)) {
                    columnInfo.setOperation(state);
                }
                if ((engineColumnType = EngineColumnTypeUtil.getEngineColumnType((String)getFields.get(i).getNewField().getDataType())).isPresent()) {
                    columnInfo.setJdbcType(((EngineColumnType)engineColumnType.get()).getJdbcType().getName());
                    columnInfo.setJavaType(((EngineColumnType)engineColumnType.get()).getJavaType());
                }
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    public List<ColumnInfoDto> transform(List<MysqlDataModelField> getFields) {
        ArrayList<ColumnInfoDto> columnInfos = new ArrayList<ColumnInfoDto>();
        if (HussarUtils.isNotEmpty(getFields)) {
            for (int i = 0; i < getFields.size(); ++i) {
                ColumnInfoDto columnInfo = new ColumnInfoDto();
                columnInfo.setColumnName(getFields.get(i).getSourceFieldName());
                columnInfo.setColumnComment(getFields.get(i).getComment());
                columnInfo.setRequired("0");
                if ("primary".equals(getFields.get(i).getUsage())) {
                    columnInfo.setPk("1");
                    columnInfo.setRequired("1");
                } else {
                    columnInfo.setPk("0");
                }
                if (getFields.get(i).getDataIsEmpty()) {
                    columnInfo.setRequired("1");
                }
                columnInfo.setDataLength(Long.valueOf(getFields.get(i).getDataLength()));
                columnInfo.setDataDot(Integer.valueOf(getFields.get(i).getDataDot()));
                columnInfo.setDataType(getFields.get(i).getSourceDataType());
                columnInfos.add(columnInfo);
            }
        }
        return columnInfos;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        int x;
        String dataSourceName = this.getDataSourceName();
        if (ToolUtil.isEmpty((Object)dataSourceName)) {
            return "";
        }
        SysDataSourceService sysDataSourceService = (SysDataSourceService)SpringContextUtil.getBean(SysDataSourceService.class);
        SysDataSource datasourceLr = sysDataSourceService.getByConnName(dataSourceName);
        datasourceLr.setDbName(dataSourceName);
        TableCorrespond info = new TableCorrespond();
        IndexCorrespond indexInfo = new IndexCorrespond();
        boolean findTable = false;
        if (fieldsContrastParam.getTableCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getTableCorresponds().size(); ++x) {
                if (!this.getId().equals(((TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x)).getModelId())) continue;
                info = (TableCorrespond)fieldsContrastParam.getTableCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        if (fieldsContrastParam.getIndexCorresponds() != null) {
            for (x = 0; x < fieldsContrastParam.getIndexCorresponds().size(); ++x) {
                if (!this.getId().equals(((IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x)).getModelId())) continue;
                indexInfo = (IndexCorrespond)fieldsContrastParam.getIndexCorresponds().get(x);
                findTable = true;
                break;
            }
        }
        boolean isCopy = true;
        if (!findTable) {
            isCopy = false;
        } else if ((info.getTableName() == null || "".equals(info.getTableName())) && "[]".equals(info.getAddFields()) && "[]".equals(info.getDelFields()) && "[]".equals(info.getModifyFields()) && "[]".equals(indexInfo.getAddIndexs()) && "[]".equals(indexInfo.getDelIndexs())) {
            boolean findCurrentTable = info.getTableName() != null && ToolUtil.isNotEmpty((Object)info.getTableName()) || indexInfo.getTableName() != null && ToolUtil.isNotEmpty((Object)indexInfo.getTableName()) ? DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)info.getTableName()).isPresent() : DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)this.sourceDataModelName.toUpperCase()).isPresent();
            isCopy = !findCurrentTable;
        }
        String sql = "";
        if (isCopy) {
            sql = this.doCopy(datasourceLr, (TableCorrespond<MysqlDataModelField>)info, indexInfo);
        }
        return sql;
    }

    private String doCopy(SysDataSource datasourceLr, TableCorrespond<MysqlDataModelField> info, IndexCorrespond indexInfo) throws Exception {
        MetadataParam paramData = new MetadataParam();
        ArrayList<ColumnInfoDto> deletedCols = new ArrayList<ColumnInfoDto>();
        List delFields = JSONArray.parseArray((String)info.getDelFields(), MysqlDataModelField.class);
        if (HussarUtils.isNotEmpty((Object)delFields)) {
            for (int y = 0; y < delFields.size(); ++y) {
                ColumnInfoDto del = new ColumnInfoDto();
                del.setColumnName(((MysqlDataModelField)((Object)delFields.get(y))).getSourceFieldName());
                deletedCols.add(del);
            }
        }
        paramData.setDeletedCols(deletedCols);
        List delIndexs = JSONArray.parseArray((String)indexInfo.getDelIndexs(), MysqlDataModelIndex.class);
        List addFields = JSONArray.parseArray((String)info.getAddFields(), MysqlDataModelField.class);
        List editFields = JSONArray.parseArray((String)info.getModifyFields(), MysqlEditDataModelField.class);
        List<ColumnInfoDto> add = this.transformDto(addFields, "add");
        List<ColumnInfoDto> edit = this.transformEdit(editFields, "edit");
        ArrayList<ColumnInfoDto> column = new ArrayList<ColumnInfoDto>();
        column.addAll(add);
        column.addAll(edit);
        paramData.setColumnInfo(column);
        String oldTableName = !HussarUtils.isEmpty((Object)info.getOldTableName()) ? info.getOldTableName() : indexInfo.getOldTableName();
        Optional infoOptional = DataModelUtil.filterTable((String)this.getDataSourceName(), (String)"BASE TABLE", (String)oldTableName.toUpperCase());
        List addIndexs = JSONArray.parseArray((String)indexInfo.getAddIndexs(), MysqlDataModelIndex.class);
        TableInfo table = infoOptional.orElseGet(TableInfo::new);
        ArrayList<ColumnInfoDto> oldColumn = new ArrayList();
        TableInfoDto tableInfoDto = MysqlBaseConnector.tableInfoInCreate(datasourceLr, this);
        paramData.setTableInfo(tableInfoDto);
        if (table.getFields() != null) {
            oldColumn = this.transform(MysqlDataModelUtil.tabTransmodel(table.getFields()));
            if (StringUtil.isNotEmpty((Object)tableInfoDto.getTableDec()) && tableInfoDto.getTableDec().equals(table.getComment())) {
                tableInfoDto.setTableDec(null);
            }
        } else {
            paramData.setColumnInfo(this.transformDto(this.getFields(), "all"));
        }
        return this.getDdlSql(paramData, oldColumn, info.getOldTableName());
    }

    public MysqlDataModelField getDeleteFlag() {
        return this.getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public MysqlDataModelField getUpdateTime() {
        return this.getFields().stream().filter(field -> "updateTime".equals(field.getUsage())).findFirst().orElse(null);
    }

    public MysqlDataModelField getPrimaryKey() {
        return this.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    private String getDdlSql(MetadataParam paramData, List<ColumnInfoDto> oldColumn, String oldTableName) throws Exception {
        HussarDdlService ddlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        return ddlService.getDdlSql(paramData, oldColumn, oldTableName);
    }
}

