/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.customOption.task;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.MysqlCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlCustomOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Component;

@Component(value="MYSQLTASKCUSTOM_OPTION")
public class MysqlTaskCustomOption
implements MysqlCustomOperation<MysqlTaskDataModel, MysqlTaskDataModelDTO> {
    public static final String CUSTOM_OPTION = "MYSQLTASKCUSTOM_OPTION";

    @Override
    public void publishCustomOption(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> backCtx) throws LcdpException {
        this.publishTaskDataBackFill(backCtx);
    }

    private void publishTaskDataBackFill(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> backCtx) throws LcdpException {
        if (ToolUtil.isEmpty((Object)backCtx.getParams()) || ToolUtil.isEmpty(backCtx.getParams().get("identity"))) {
            return;
        }
        MysqlTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        MysqlTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        if (ToolUtil.isEmpty(useDataModelDTO.getCustomCodeGenerateInfo())) {
            useDataModelDTO.setCustomCodeGenerateInfo(new HashMap<String, MysqlCodeGenerateInfo>());
        }
        useDataModelDTO.getCustomCodeGenerateInfo().put(useDataModelBase.getId(), this.genTaskDataBackFillCode(backCtx));
    }

    private MysqlCodeGenerateInfo genTaskDataBackFillCode(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> backCtx) throws LcdpException {
        MysqlTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        MysqlTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(useDataModelBase.getId());
        MysqlBaseDataModel task = useDataModelBase.getTask();
        String taskId = task.getId();
        MysqlDataModelBaseDTO userTaskModelDTO = useDataModelDTO.getDataModelDtoMap().get(taskId);
        MysqlDataModelBaseDTO userBusinessModelDTO = useDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getId());
        String modulePath = useDataModelDTO.getTablePath().toLowerCase();
        String fileName = userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl";
        String writePath = modulePath + File.separator + "Task".toLowerCase() + File.separator + fileName + ".java";
        String dataBackFillPath = "template/taskbackcode/code/task_data_backfill_service_impl.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("package", userTaskModelDTO.getPackageInfo().get("Task"));
        params.put("className", fileName);
        params.put("identity", backCtx.getParams().get("identity"));
        TreeSet<String> imports = new TreeSet<String>();
        params.put("implementServiceNameImportInfo", "com.jxdinfo.hussar.workflow.task.model.service.TaskModelService");
        params.put("implementServiceName", "TaskModelService");
        params.put("ProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto");
        params.put("DeletedProcessInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto");
        params.put("ProcessNodeInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto");
        params.put("CompleteTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto");
        params.put("UpdateTaskUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto");
        params.put("WorkflowUserDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.WorkflowUserDto");
        params.put("TaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto");
        params.put("DeletedTaskInfoDtoImportInfo", "com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto");
        params.put("taskEntity", userTaskModelDTO.getEntityName());
        params.put("taskEntityImportInfo", userTaskModelDTO.getImportInfo().get("Entity"));
        params.put("taskServiceName", userTaskModelDTO.getServiceName());
        params.put("taskServiceImportInfo", userTaskModelDTO.getImportInfo().get("Service"));
        params.put("businessServiceName", userBusinessModelDTO.getServiceName());
        params.put("businessServiceImportInfo", userBusinessModelDTO.getImportInfo().get("Service"));
        params.put("businessEntity", userBusinessModelDTO.getEntityName());
        params.put("businessEntityImportInfo", userBusinessModelDTO.getImportInfo().get("Entity"));
        HashMap<String, String> businessColumn = new HashMap<String, String>();
        List<MysqlDataModelFieldDto> businessFields = userBusinessModelDTO.getFields();
        for (MysqlDataModelFieldDto mysqlDataModelFieldDto : businessFields) {
            if (!ToolUtil.isNotEmpty((Object)mysqlDataModelFieldDto.getFill())) continue;
            businessColumn.put(mysqlDataModelFieldDto.getFill(), mysqlDataModelFieldDto.getName());
            if (!"primary".equals(mysqlDataModelFieldDto.getFill())) continue;
            params.put("primaryType", mysqlDataModelFieldDto.getColumnType().getType());
            if (!ToolUtil.isNotEmpty((Object)mysqlDataModelFieldDto.getColumnType().getImportT())) continue;
            imports.add(mysqlDataModelFieldDto.getColumnType().getImportT());
        }
        params.put("businessColumn", businessColumn);
        List<MysqlDataModelField> fields = task.getFields();
        for (MysqlDataModelField field : fields) {
            if ("foreign".equals(field.getUsage())) {
                params.put("taskForeign", field.getSourceFieldName());
            }
            if (!"taskId".equals(field.getName())) continue;
            params.put("taskTaskId", field.getSourceFieldName());
        }
        params.put("dataSourceName", useDataModelBase.getDataSourceName());
        params.put("imports", imports);
        MysqlCodeGenerateInfo mysqlCodeGenerateInfo = new MysqlCodeGenerateInfo();
        mysqlCodeGenerateInfo.setFileWriteRelativePath(writePath);
        mysqlCodeGenerateInfo.setFileContent(RenderUtil.renderTemplate((String)dataBackFillPath, params));
        mysqlCodeGenerateInfo.setFileType("serviceImpl");
        mysqlCodeGenerateInfo.setFileId(useDataModelDTO.getId());
        mysqlCodeGenerateInfo.setFileName(userTaskModelDTO.getEntityName() + "DataBackFillServiceImpl" + ".java");
        return mysqlCodeGenerateInfo;
    }
}

