/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlBaseRender;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.constant.MysqlConstUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTaskTableQuery {
    private static final Logger logger = LoggerFactory.getLogger(MysqlTaskTableQuery.class);

    public static void visit(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        MysqlFlowDataModel useDataModelBase = backCtx.getUseDataModelBase();
        MysqlFlowDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        boolean isLogicallyDelete = useDataModelBase.getLogicallyDelete();
        Map<String, Object> controllerParams = MysqlTaskTableQuery.initParams(dataModelOperation, useDataModelDTO, useDataModelBase);
        MysqlDataModelFieldDto fieldDto = useDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            hasSecurityLevel = true;
        }
        if (isLogicallyDelete) {
            controllerParams.put("deleteFlag", useDataModelDTO.getFieldCapitalName(useDataModelBase.getDeleteFlag().getName()));
        }
        Boolean isPagination = Boolean.valueOf(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        boolean isSelectCondition = MysqlTaskTableQuery.renderSelectAndSort(backCtx, dataModelOperation, modelId, useDataModelBase, useDataModelDTO, controllerParams, isPagination, isSortOverall);
        controllerParams.put("isSortOverall", isSortOverall);
        MysqlTaskTableQuery.renderPageVo(backCtx, modelId, useDataModelDTO, controllerParams);
        String controllerPath = "template/taskbackcode/basetaskbackcode/tableQuery/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/taskbackcode/basetaskbackcode/tableQuery/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/taskbackcode/basetaskbackcode/tableQuery/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (isSelectCondition) {
            backCtx.addServiceImplInversion(modelId, useDataModelDTO.getMapperName());
            String mapperPath = "template/taskbackcode/basetaskbackcode/tableQuery/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String xmlPath = "template/taskbackcode/basetaskbackcode/tableQuery/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        MysqlTaskTableQuery.renderImport(backCtx, modelId, useDataModelDTO, isSelectCondition, isPagination, isLogicallyDelete, isSortOverall, hasSecurityLevel);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
    }

    private static void renderImport(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, boolean isSelectCondition, boolean isPagination, boolean isLogicallyDelete, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "java.util.List");
            if (isPagination) {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            } else {
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
                backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            }
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        if (isLogicallyDelete) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private static Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlFlowDataModelDTO dataModelBaseDTO, MysqlBaseDataModel mysqlBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        controllerParams.put("url", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName());
        boolean isLogicallyDelete = mysqlBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            MysqlDataModelField logicallyField = mysqlBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
            controllerParams.put("deleteFlagName", logicallyField.getSourceFieldName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private static boolean renderSelectAndSort(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, MysqlFlowDataModel useDataModelBase, MysqlFlowDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams, Boolean isPagination, boolean isSortOverall) throws LcdpException {
        MysqlSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{sortConditionName}) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(MysqlSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<MysqlSortConditionField> sortConditionFields;
            List<MysqlSortConditionField> fields = sortCondition.getFields();
            block0: for (MysqlSortConditionField mysqlSortConditionField : fields) {
                String fromModelFieldIdSort = mysqlSortConditionField.getFromModelFieldIdSort();
                List<MysqlDataModelField> fromModelFieldSort = useDataModelBase.getFields();
                for (MysqlDataModelField mysqlDataModelField : fromModelFieldSort) {
                    if (!mysqlDataModelField.getId().equals(fromModelFieldIdSort)) continue;
                    mysqlSortConditionField.setFromModelFieldSort(mysqlDataModelField.getName());
                    continue block0;
                }
            }
            if (!isPagination.booleanValue()) {
                sortConditionFields = sortCondition.getFields();
                for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll();
                }
            } else {
                sortConditionFields = sortCondition.getFields();
                for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName();
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            if (Boolean.TRUE.equals(isPagination)) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        boolean isSelectCondition = false;
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        MysqlQueryCondition queryCondition = useDataModelBase.getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            boolean bl;
            MysqlQueryConditionField oredElse;
            boolean bl2 = true;
            if (ToolUtil.isNotEmpty((Object)queryCondition) && ToolUtil.isNotEmpty(queryCondition.getFields()) && ToolUtil.isNotEmpty((Object)(oredElse = (MysqlQueryConditionField)queryCondition.getFields().stream().filter(item -> "securityLevel".equals(item.getUsageType())).findFirst().orElse(null)))) {
                bl = false;
            }
            if (bl) {
                MysqlDataModelFieldDto fieldDto = (MysqlDataModelFieldDto)controllerParams.get("securityLevel");
                MysqlQueryConditionField field = new MysqlQueryConditionField();
                field.setConnect("and");
                field.setFromModelField(fieldDto.getId());
                field.setQueryAttrName(fieldDto.getPropertyName());
                field.setFromModelId(useDataModelBase.getId());
                field.setType("row");
                field.setSymbol("<=");
                field.setUsageType("securityLevel");
                queryCondition.getFields().add(field);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MysqlQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<MysqlDataModelField> fields = backCtx.getUseDataModelBase().getFields();
            boolean isStringType = true;
            for (MysqlDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            arrayList.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        controllerParams.put("likeQueryFields", arrayList);
        if (!Optional.ofNullable(queryCondition).map(MysqlQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        DataSet dataSet = useDataModelBase.getDataSetById(queryCondition.getFromDataSet());
        MysqlDataModelField mysqlDataModelField = useDataModelBase.getDeleteFlag();
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, mysqlDataModelField.getName(), useDataModelBase.getId());
        }
        MysqlQueryDTO queryDTO = MysqlDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)controllerParams.get("securityLevel"))) {
            MysqlDataModelFieldDto fieldDto = (MysqlDataModelFieldDto)controllerParams.get("securityLevel");
            MysqlQueryFieldDTO field = new MysqlQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            queryDTO.getQueryFields().add(field);
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), null, dataModelBaseDTO, new HashMap<String, String>(), mysqlDataModelField == null ? "" : mysqlDataModelField.getSourceFieldName());
        if (useDataModelBase.getLogicallyDelete()) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        controllerParams.put("whereSql", finalWhereSql);
        isSelectCondition = true;
        controllerParams.put("isSelectCondition", MysqlConstUtil.TRUE);
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return isSelectCondition;
    }

    private static void renderPageVo(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        MysqlDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + MysqlDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

