/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.enclosure;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.translate.MysqlTranslate;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlPublicEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlTranslateUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLFLOWENCLOSURE")
public class MysqlFlowEnclosure
implements MysqlEnclosure<MysqlFlowDataModel> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlFlowEnclosure.class);
    public static final String ENCLOSURE = "MYSQLFLOWENCLOSURE";

    @Override
    public MysqlDataModelBaseDTO enclosure(MysqlFlowDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        List<MysqlDataModelField> dataModelFieldBases;
        MysqlFlowDataModelDTO dataModelBaseDTO = new MysqlFlowDataModelDTO();
        dataModelBaseDTO.setUseMybatisPlus(true);
        MysqlPublicEnclosure.enclosure(dataModelBase, dataModelBaseDTO);
        if (dataModelBase.getSourceDataModelName() != null) {
            dataModelBaseDTO.setSourceDataModelName(dataModelBase.getSourceDataModelName());
        }
        if (ToolUtil.isEmpty(dataModelFieldBases = dataModelBase.getFlowFields())) {
            logger.error("MysqlFlowMsEnclosure\u7684enclosure\u65b9\u6cd5\u51fa\u9519,FlowFields\u4e3a\u7a7a,json\u683c\u5f0f\u9519\u8bef");
            return new MysqlFlowDataModelDTO();
        }
        ArrayList<MysqlDataModelFieldDto> tableFields = new ArrayList<MysqlDataModelFieldDto>();
        for (MysqlDataModelField dataModelFieldBase : dataModelFieldBases) {
            MysqlDataModelFieldDto tableField = new MysqlDataModelFieldDto();
            tableField.setConvert(true);
            tableField.setName(dataModelFieldBase.getSourceFieldName());
            tableField.setPropertyName(dataModelFieldBase.getName());
            tableField.setComment(dataModelFieldBase.getComment());
            tableField.setType(dataModelFieldBase.getDataType());
            tableField.setColumnType(DataModelFieldTypeConvert.getDbColumnType((String)dataModelFieldBase.getDataType()));
            tableField.setUpdateStrategy(dataModelFieldBase.getUpdateStrategy());
            if (StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{dataModelFieldBase.getUsage()})) {
                tableField.setFill(dataModelFieldBase.getUsage());
            }
            tableFields.add(tableField);
        }
        dataModelBaseDTO.setFlowFields(tableFields);
        List<MysqlTranslate> translates = dataModelBase.getTranslate();
        if (ToolUtil.isNotEmpty(translates)) {
            List rightFields = ModelProvideAdapter.adaptor((String)dataModelBase.getId()).getFields(dataModelBase.getId());
            List<Map<String, Object>> translateAnnotations = MysqlTranslateUtil.translate(translates, rightFields);
            if (ToolUtil.isNotEmpty(translateAnnotations)) {
                List<MysqlDataModelFieldDto> fields = dataModelBaseDTO.getFields();
                block1: for (Map map : translateAnnotations) {
                    if (!ToolUtil.isNotEmpty((Object)map) || !ToolUtil.isNotEmpty(map.get("fieldId"))) continue;
                    for (MysqlDataModelFieldDto field : fields) {
                        if (!field.getId().equals(map.get("fieldId").toString())) continue;
                        field.setFieldAnnotation(map.get("fieldAnnotation").toString());
                        continue block1;
                    }
                }
                dataModelBaseDTO.setFields(fields);
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.anno.Trans");
                dataModelBaseDTO.addEntityImport("com.jxdinfo.hussar.support.transdict.core.constant.TransType");
            }
            List<MysqlDataModelFieldDto> translateShowFields = MysqlTranslateUtil.getTranslateShowFields(translates);
            for (MysqlDataModelFieldDto mysqlDataModelFieldDto : translateShowFields) {
                if (null == mysqlDataModelFieldDto.getColumnType() || null == mysqlDataModelFieldDto.getColumnType().getImportT()) continue;
                dataModelBaseDTO.addEntityImport(mysqlDataModelFieldDto.getColumnType().getImportT());
            }
            dataModelBaseDTO.setTranslateShowFields(translateShowFields);
        }
        return dataModelBaseDTO;
    }
}

