/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelFieldBase;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.back.model.sync.ContrastVO;
import com.jxdinfo.hussar.formdesign.back.model.sync.FieldsContrastParam;
import com.jxdinfo.hussar.formdesign.back.model.sync.PublishCheckVO;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryObject;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MysqlMsDataModel
extends MysqlDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(MysqlMsDataModel.class);
    public static final String FUNCTION_TYPE = "MASTER_SLAVE";
    private static final String MASTER_KEY = "masterTable";
    private static final String SLAVE_KEY = "slaveTables";
    private static final String CREATE_STRATEGY = "create";
    private static final String UPDATE_STRATEGY = "update";
    private static final String ASSOCIATION = "association";
    private static final String COLLECTION = "collection";
    private List<MysqlQueryCondition> queryConditions;
    private List<MysqlQueryObject> queryObject;
    private MysqlDataModelBase masterTable;
    private List<MysqlDataModelBase> slaveTables;
    private boolean logicallyDelete;
    private List<MysqlRelationshipBase> relationships;
    private List<MysqlSortCondition> sortCondition;

    @PostConstruct
    public void register() {
        FunctionModelFactory.registerFunction((String)"MYSQL.MASTER_SLAVE", MysqlMsDataModel.class);
    }

    @Override
    public MysqlMsDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        MysqlMsDataModel mysqlMsDataModel;
        try {
            ArrayList<MysqlDataModelField> fieldList = new ArrayList<MysqlDataModelField>();
            mysqlMsDataModel = (MysqlMsDataModel)JSONObject.parseObject((String)jsonObject.toString(), MysqlMsDataModel.class);
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)MASTER_KEY))) {
                MysqlDataModelBase master = MysqlDataModelUtil.transfer(jsonObject.get((Object)MASTER_KEY).toString());
                master.setName(mysqlMsDataModel.getName() + "Master");
                mysqlMsDataModel.setMasterTable(master);
                fieldList.addAll(master.getFields());
            }
            ArrayList<MysqlDataModelBase> slaveTables = new ArrayList<MysqlDataModelBase>();
            if (ToolUtil.isNotEmpty((Object)jsonObject.get((Object)SLAVE_KEY))) {
                for (Object slaves : JSONArray.parseArray((String)jsonObject.get((Object)SLAVE_KEY).toString())) {
                    MysqlDataModelBase slaveTable = MysqlDataModelUtil.transfer(slaves.toString());
                    slaveTables.add(slaveTable);
                }
                for (MysqlRelationshipBase relationship : mysqlMsDataModel.getRelationships()) {
                    MysqlDataModelBase dataModelBase = slaveTables.stream().filter(item -> item.getId().equals(relationship.getSlaveTableId())).findFirst().orElseGet(MysqlBaseDataModel::new);
                    if (ASSOCIATION.equals(relationship.getRelateModelType())) {
                        fieldList.addAll(dataModelBase.getFields());
                        continue;
                    }
                    if (!COLLECTION.equals(relationship.getRelateModelType())) continue;
                    MysqlDataModelField mysqlDataModelField = new MysqlDataModelField();
                    mysqlDataModelField.setId(dataModelBase.getId());
                    mysqlDataModelField.setName(dataModelBase.getName());
                    mysqlDataModelField.setComment(dataModelBase.getComment());
                    mysqlDataModelField.setSourceDataModelId(dataModelBase.getId());
                    mysqlDataModelField.setDataType("array");
                    fieldList.add(mysqlDataModelField);
                }
                mysqlMsDataModel.setSlaveTables(slaveTables);
            }
            mysqlMsDataModel.setFields(fieldList);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return mysqlMsDataModel;
    }

    @Override
    public MysqlEnclosure<MysqlDataModelBase> enclosure() throws LcdpException {
        return MysqlModelBeanUtil.getEnclosureBean("MYSQL", FUNCTION_TYPE, "ENCLOSURE");
    }

    @Override
    public MysqlRender<MysqlDataModelBase, MysqlDataModelBaseDTO> render() throws LcdpException {
        return MysqlModelBeanUtil.getRenderBean("MYSQL", FUNCTION_TYPE, "RENDER");
    }

    public MysqlDataModelBase getMasterTable() {
        return this.masterTable;
    }

    public void setMasterTable(MysqlDataModelBase masterTable) {
        this.masterTable = masterTable;
    }

    public List<MysqlDataModelBase> getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(List<MysqlDataModelBase> slaveTables) {
        this.slaveTables = slaveTables;
    }

    public List<MysqlRelationshipBase> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<MysqlRelationshipBase> relationships) {
        this.relationships = relationships;
    }

    @Override
    public boolean isLogicallyDelete() {
        return this.logicallyDelete;
    }

    @Override
    public void setLogicallyDelete(boolean logicallyDelete) {
        this.logicallyDelete = logicallyDelete;
    }

    public List<MysqlQueryCondition> getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(List<MysqlQueryCondition> queryConditions) {
        this.queryConditions = queryConditions;
    }

    public List<MysqlQueryObject> getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(List<MysqlQueryObject> queryObject) {
        this.queryObject = queryObject;
    }

    @Override
    public List<MysqlSortCondition> getSortCondition() {
        if (HussarUtils.isNotEmpty(this.sortCondition)) {
            for (MysqlSortCondition condition : this.sortCondition) {
                if (!HussarUtils.isNotEmpty(condition.getFields())) continue;
                for (MysqlSortConditionField field : condition.getFields()) {
                    Map<String, String> fieldMap;
                    String fieldName;
                    if (HussarUtils.isEmpty((Object)field.getParentModelId())) {
                        field.setParentModelId(field.getFromModelIdSort());
                    }
                    MysqlDataModelBase dataModelBase = this.masterTable;
                    if (!this.masterTable.getId().equals(field.getFromModelIdSort())) {
                        for (MysqlDataModelBase modelBase : this.slaveTables) {
                            if (!modelBase.getId().equals(field.getFromModelIdSort())) continue;
                            dataModelBase = modelBase;
                            break;
                        }
                    }
                    if (HussarUtils.equals((Object)(fieldName = (fieldMap = dataModelBase.getFields().stream().filter(e -> e.getName() != null).collect(Collectors.toMap(DataModelFieldBase::getId, DataModelFieldBase::getName))).get(field.getFromModelFieldIdSort())), (Object)field.getFromModelFieldSort())) continue;
                    field.setFromModelFieldSort(fieldName);
                }
            }
        }
        return this.sortCondition;
    }

    public void setSortCondition(List<MysqlSortCondition> sortCondition) {
        this.sortCondition = sortCondition;
    }

    @Override
    public MysqlQueryCondition getQuConBaseByName(String queryConditionName) {
        if (ToolUtil.isNotEmpty(this.queryConditions)) {
            for (MysqlQueryCondition queryConditionBase : this.queryConditions) {
                if (!queryConditionBase.getName().equals(queryConditionName)) continue;
                return queryConditionBase;
            }
        }
        return null;
    }

    @Override
    public MysqlSortCondition getSortConBaseByName(String sortConditionName) {
        if (this.getSortCondition() != null) {
            for (MysqlSortCondition sortConditionBase : this.getSortCondition()) {
                if (!sortConditionBase.getName().equals(sortConditionName)) continue;
                return sortConditionBase;
            }
        }
        return null;
    }

    @Override
    public String getSourceDataModelName() {
        return "";
    }

    public Map<String, String> getModelAliasName() {
        HashMap<String, String> finalMap = new HashMap<String, String>();
        finalMap.put(super.getId(), "T1");
        finalMap.put(this.masterTable.getId(), "T2");
        if (ToolUtil.isNotEmpty(this.relationships) && !this.relationships.isEmpty()) {
            for (int i = 0; i < this.relationships.size(); ++i) {
                MysqlRelationshipBase relationship = this.relationships.get(i);
                finalMap.put(relationship.getSlaveTableId(), "T" + (i + 3));
            }
        }
        return finalMap;
    }

    public DataSet getDataSetById(String dataSetId) {
        if (this.getDataSets() != null) {
            for (DataSet dataSet : this.getDataSets()) {
                if (!dataSet.getId().equals(dataSetId)) continue;
                return dataSet;
            }
        }
        return null;
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> findTableContrast() throws IOException, LcdpException {
        List<ContrastVO<MysqlDataModelField>> tableContrast = this.masterTable.findTableContrast();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).findTableContrast().get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> tableContrastModel(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<MysqlDataModelField>> tableContrast = this.masterTable.tableContrastModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            tableContrast.add(this.slaveTables.get(i).tableContrastModel(fieldsContrastParam).get(0));
        }
        return tableContrast;
    }

    @Override
    public List<ContrastVO<MysqlDataModelField>> modelContrastTable(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws IOException, LcdpException {
        List<ContrastVO<MysqlDataModelField>> tableContrast = this.masterTable.modelContrastTable(fieldsContrastParam);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            if (!HussarUtils.isEmpty(map.get(this.slaveTables.get(i).getSourceDataModelName()))) continue;
            tableContrast.add(this.slaveTables.get(i).modelContrastTable(fieldsContrastParam).get(0));
            map.put(this.slaveTables.get(i).getSourceDataModelName(), true);
        }
        return tableContrast;
    }

    @Override
    public PublishCheckVO checkTableContrast(String modelId) throws IOException, LcdpException {
        PublishCheckVO tableContrast = new PublishCheckVO();
        tableContrast.setModelId(modelId);
        ArrayList details = new ArrayList();
        details.add(this.masterTable.checkTableContrast(modelId).getDetails().get(0));
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            details.add(this.slaveTables.get(i).checkTableContrast(modelId).getDetails().get(0));
        }
        tableContrast.setDetails(details);
        return tableContrast;
    }

    @Override
    public Boolean updateTable(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        this.masterTable.updateTable(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            this.slaveTables.get(i).updateTable(fieldsContrastParam);
        }
        return true;
    }

    @Override
    public String copyTableByModel(FieldsContrastParam<MysqlDataModelField> fieldsContrastParam) throws Exception {
        String sql = this.masterTable.copyTableByModel(fieldsContrastParam);
        for (int i = 0; i < this.slaveTables.size(); ++i) {
            sql = sql + this.slaveTables.get(i).copyTableByModel(fieldsContrastParam);
        }
        return sql;
    }

    public MysqlDataModelField getDeleteFlag() {
        return this.masterTable.getFields().stream().filter(field -> "delDefFlag".equals(field.getUsage())).findFirst().orElse(null);
    }

    public MysqlDataModelField getPrimaryKey() {
        return this.masterTable.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(null);
    }

    @Override
    public Map<String, Map<String, Object>> getSlaveModelInfo() {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        List<MysqlDataModelBase> slaveTables = this.getSlaveTables();
        for (MysqlDataModelBase slaveTable : slaveTables) {
            MysqlDataModelField mysqlDataModelField = slaveTable.getFields().stream().filter(field -> "primary".equals(field.getUsage())).findFirst().orElse(new MysqlDataModelField());
            HashMap<String, Object> val = new HashMap<String, Object>();
            val.put("comment", slaveTable.getComment());
            val.put("primary", mysqlDataModelField.getName());
            val.put("fields", slaveTable.getFields());
            boolean association = this.getRelationships().stream().anyMatch(relationship -> relationship.getRelateModelType().equals(ASSOCIATION) && relationship.getSlaveTableId().equals(slaveTable.getId()));
            val.put(ASSOCIATION, association);
            map.put(slaveTable.getId(), val);
        }
        return map;
    }
}

