<#assign index = 1>
@Override
@HussarTransactional
public ApiResponse<?> ${operationName!}(MultipartFile file, String uniqueIdentification, String slaveTable,String slaveUniqueIdentification, String slaveForeignIdentification) {
    //适配单表不判断子表相关信息
    if (HussarUtils.isEmpty(uniqueIdentification)) {
        return ApiResponse.fail("缺少业务唯一标识信息");
    }
    //主表业务唯一标识名
    List<String> slaveTables = Arrays.asList(slaveTable.split(","));
    List<String> slaveUniqueIdentifications = Arrays.asList(slaveUniqueIdentification.split(","));
    List<String> slaveForeignIdentifications = Arrays.asList(slaveForeignIdentification.split(","));
    Map<String, String> param = new HashMap<>();
    Map<String, String> foreignParam = new HashMap<>();
    for (int i = 0; i < slaveTables.size(); i++) {
        param.put(slaveTables.get(i), slaveUniqueIdentifications.get(i));
        foreignParam.put(slaveTables.get(i), slaveForeignIdentifications.get(i));
    }
    //表名和service对应关系
    Map<String, Class<?>> classMap = new HashMap<>();
    classMap.put("${table.comment}", ${table.entityName?cap_first}Master.class);
    <#list slaveTable as slave>
        classMap.put("${slave.comment}", ${slave.name?cap_first}.class);
    </#list>
    //主表物理主键与业务唯一标识对应关系
    Map<String, String> masterKeyCorrespondence = new HashMap<>();
    Map<String, Map<String, String>> dict = new HashMap<>();
    <#if table.hasTranslate?? && table.hasTranslate!>
        Map<String, String> map = new HashMap<>();
        <#list table.fields as field>
            <#if field.dictTyeName?? && field.dictTyeName != ''>
                map.put("${field.comment}","${field.dictTyeName}");
            </#if>
        </#list>
        <#list table.dataModelDtoMap as key, value>
            <#list value.fields as field>
                <#if field.dictTyeName?? && field.dictTyeName != ''>
                    map.put("${field.comment}","${field.dictTyeName}");
                </#if>
            </#list>
        </#list>
        List<DictVo> dictVosByTypeNames = iSysDicRefService.getDictVosByTypeNames(new ArrayList<>(map.values()));
        Map<String, List<DictVo>> group = dictVosByTypeNames.stream().collect(Collectors.groupingBy(DictVo::getTypeName));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            List<DictVo> dictVos = group.get(entry.getValue());
            if (HussarUtils.isNotEmpty(dictVos)){
                Map<String, String> collect = dictVos.get(0).getSingleList().stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
                dict.put(entry.getKey(), collect);
            }
        }
    </#if>
    try {
        //表名及对应实体类数据
        Map<String, List<?>> data = ExcelUtils.readFileManySheetToObj(file, classMap, dict);
        importData:
        for (Map.Entry<String, List<?>> entry : data.entrySet()) {
            if ("${table.comment}".equals(entry.getKey())) {
                //获取业务唯一标识对应属性
                Field declaredField = classMap.get(entry.getKey()).getDeclaredField(uniqueIdentification);
                //允许访问私有字段
                declaredField.setAccessible(true);
                List<${table.entityName}Master> ${table.name?uncap_first}List = (List<${table.entityName}Master>) entry.getValue();
                //主表业务唯一标识值
                List<String> values = new ArrayList<>();
                //获取库里的对应信息
                List<${table.entityName}Master> masterList = ${masterServiceName?uncap_first}.list();
                if (!masterList.isEmpty()) {
                    for (${table.entityName}Master ${table.name?uncap_first} : masterList) {
                        masterKeyCorrespondence.put(String.valueOf(${table.name?uncap_first}.get${primaryField?cap_first}()), String.valueOf(declaredField.get(${table.name?uncap_first})));
                    }
                }
                //循环获取值
                for (${table.entityName}Master ${table.name?uncap_first} : ${table.name?uncap_first}List) {
                    if (HussarUtils.isEmpty(declaredField.get(${table.name?uncap_first}))) {
                        return ApiResponse.fail("");
                    }
                    String s = String.valueOf(declaredField.get(${table.name?uncap_first}));
                    values.add(s);
                    masterKeyCorrespondence.put(String.valueOf(${table.name?uncap_first}.get${primaryField?cap_first}()), s);
                }
                //主表只区分新增还是修改
                List<${table.entityName}Master> addList = new ArrayList<>();
                List<${table.entityName}Master> updateList = new ArrayList<>();
                Function<Object, String> f = (Object::toString);
                List<String> masterColumn = ExcelUtils.camelToSnake(Collections.singletonList(uniqueIdentification));
                List<String> strings = HussarUtils.isNotEmpty(values) ? ${masterServiceName?uncap_first}.listObjs(new QueryWrapper<${table.entityName}Master>().in(masterColumn.get(0), values), f) : new ArrayList<>();
                if (!strings.isEmpty()) {
                    for (${table.entityName}Master ${table.name?uncap_first} : ${table.name?uncap_first}List) {
                        if (strings.contains(String.valueOf(declaredField.get(${table.name?uncap_first})))) {
                            updateList.add(${table.name?uncap_first});
                        } else {
                           addList.add(${table.name?uncap_first});
                        }
                    }
                } else {
                    addList.addAll(${table.name?uncap_first}List);
                }
                if (!addList.isEmpty()) {
                    ${masterServiceName?uncap_first}.saveBatch(addList);
                }
                StringBuilder sb = new StringBuilder();
                String mainIdName = "";//数据库中主键字段名
                if (!updateList.isEmpty()) {
                    for (int i = 0; i < updateList.size(); i++) {
                        Long mainId = 0L;
                        StringBuilder setClause = new StringBuilder();
                        String tableName = "${mainName!}"; //表名
                        Class<?> clazz = updateList.get(i).getClass();
                        Field[] fields = clazz.getDeclaredFields();
                        List<Field> neededFields = new ArrayList<>();
                        List<String> neededFieldValues = new ArrayList<>();
                        Map<String,String> ${table.name}Map = new HashMap<>();//实体类字段和数据库字段对照map，无主键。
                        for (Field field : fields) {
                            if (field.isAnnotationPresent(TableField.class)) { // 检查字段上是否有@TableField注解
                                neededFields.add(field);
                                TableField tableField = field.getAnnotation(TableField.class); // 获取注解实例
                                ${table.name}Map.put(field.getName(),tableField.value());
                            }
                            if (field.isAnnotationPresent(TableId.class)) {
                                neededFields.add(field);
                                field.setAccessible(true);
                                TableId tableId = field.getAnnotation(TableId.class); // 获取注解实例
                                mainIdName = tableId.value(); // 获取注解的value值，即数据库字段名
                                mainId = (Long) field.get(updateList.get(i));
                            }
                        }
                        // 业务主键不需要更新
                        boolean firstField = true;
                        for (Field field : neededFields) {
                            try {
                                if (!field.getName().equals(uniqueIdentification)) { // 排除id字段
                                    if (!firstField) {
                                        setClause.append(", ");
                                    }
                                    // 使用getter获取字段值，这里假设有标准的getter方法
                                    String methodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                                    Method method = clazz.getMethod(methodName);
                                    Object value = method.invoke(updateList.get(i));
                                    // 检查值是否为null，并相应地构建SQL片段
                                    if (value == null) {
                                        setClause.append(${table.name}Map.get(field.getName())).append(" = NULL");
                                    } else {
                                        setClause.append(${table.name}Map.get(field.getName())).append(" = '").append(value).append("'");
                                    }
                                    firstField = false;
                                }
                            } catch (NoSuchMethodException | IllegalAccessException e) {
                                e.printStackTrace();
                                // 处理异常或返回null等
                            }
                        }

                        if (setClause.length() == 0) {
                            return null; // 如果没有可更新的字段，则返回null
                        }

                        String sql = String.format("UPDATE %s SET %s WHERE " + mainIdName +  " = %d;", tableName, setClause.toString(), mainId);
                        sb.append(sql);
                    }
                    ${table.name}Mapper.updateBySqls(sb);
                //${masterServiceName?uncap_first}.updateBatchById(updateList);
                }
            }
        <#list slaveTable as slave>
            if ("${slave.comment}".equals(entry.getKey())) {
                //获取业务唯一标识对应属性
                String slaveNatural${index!} = String.valueOf(param.get(entry.getKey()));
                Field declaredField${index!} = classMap.get(entry.getKey()).getDeclaredField(slaveNatural${index!});
                //获取外键对应属性（对应主表业务唯一标识）
                Field foreignKeyAttributes${index!} = classMap.get(entry.getKey()).getDeclaredField(foreignParam.get(entry.getKey()));
                //允许访问私有字段
                declaredField${index!}.setAccessible(true);
                foreignKeyAttributes${index!}.setAccessible(true);
                //业务唯一标识
                List<String> subValues${index!} = new ArrayList<>();
                //子表物理外键与外键对应关系
                //外键（对应主表业务唯一标识）
                Map<String, String> subKeyCorrespondence${index!} = new HashMap<>();

                List<${slave.name?cap_first}> ${slave.name}List = (List<${slave.name?cap_first}>) entry.getValue();
                //循环获取值
                for (${slave.name?cap_first} ${slave.name?uncap_first} : ${slave.name}List) {
                    if (HussarUtils.isEmpty(declaredField${index!}.get(${slave.name?uncap_first}))) {
                        return ApiResponse.fail("");
                    }
                    subValues${index!}.add(String.valueOf(declaredField${index!}.get(${slave.name?uncap_first})));
                    // key 为外键字段名
                    subKeyCorrespondence${index!}.put(String.valueOf(${slave.name?uncap_first}.get${slave.foreignField?cap_first}()), String.valueOf(foreignKeyAttributes${index!}.get(${slave.name?uncap_first})));
                }
                if (!ExcelUtils.isMapContained(masterKeyCorrespondence, subKeyCorrespondence${index!})) {
                    throw new RuntimeException("外键关联有误");
                }
                List<${slave.name?cap_first}> subAdd${index!} = new ArrayList<>();
                List<${slave.name?cap_first}> subUpdate${index!} = new ArrayList<>();
                Function<Object, String> f${index!} = (Object::toString);
                List<String> slaveColumn${index!} = ExcelUtils.camelToSnake(Collections.singletonList(slaveNatural${index!}));
                List<String> strings${index!} = HussarUtils.isNotEmpty(subValues${index!}) ? ${slave.name?uncap_first}Service.listObjs(new QueryWrapper<${slave.name?cap_first}>().in(slaveColumn${index!}.get(0), subValues${index!}), f${index!}) : new ArrayList<>();
                if (!strings${index!}.isEmpty()) {
                    for (${slave.name?cap_first} ${slave.name?uncap_first} : ${slave.name}List) {
                        if (strings${index!}.contains(String.valueOf(declaredField${index!}.get(${slave.name?uncap_first})))) {
                            subUpdate${index!}.add(${slave.name?uncap_first});
                        } else {
                            subAdd${index!}.add(${slave.name?uncap_first});
                        }
                    }
                } else {
                    subAdd${index!}.addAll(${slave.name}List);
                }
                if (!subAdd${index!}.isEmpty()) {
                    ${slave.name?uncap_first}Service.saveBatch(subAdd${index!});
                }
                if (!subUpdate${index!}.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    String mainIdName = "";//数据库中主键字段名
                    for (int i = 0; i < subUpdate${index!}.size(); i++) {
                        Long mainId = 0L;
                        StringBuilder setClause = new StringBuilder();
                        String tableName = "${slave.name}"; //表名
                        Class<?> clazz = subUpdate${index!}.get(i).getClass();
                        Field[] fields = clazz.getDeclaredFields();
                        List<Field> neededFields = new ArrayList<>();
                        List<String> neededFieldValues = new ArrayList<>();
                        Map<String,String> ${slave.name}Map = new HashMap<>();//实体类字段和数据库字段对照map，无主键。
                        String mainName = "";
                        for (Field field : fields) {
                            if (field.isAnnotationPresent(TableField.class)) { // 检查字段上是否有@TableField注解
                                neededFields.add(field);
                                TableField tableField = field.getAnnotation(TableField.class); // 获取注解实例
                                ${slave.name}Map.put(field.getName(),tableField.value());
                            }
                            if (field.isAnnotationPresent(TableId.class)) {
                                neededFields.add(field);
                                field.setAccessible(true);
                                TableId tableId = field.getAnnotation(TableId.class); // 获取注解实例
                                mainIdName = tableId.value(); // 获取注解的value值，即数据库字段名
                                mainId = (Long) field.get(subUpdate${index!}.get(i));
                                mainName = field.getName();
                            }
                        }
                        // 业务主键不需要更新
                        boolean firstField = true;
                        for (Field field : neededFields) {
                            try {
                                if (!field.getName().equals(mainName)) { // 排除id字段
                                    if (!firstField) {
                                        setClause.append(", ");
                                    }
                                    // 使用getter获取字段值，这里假设有标准的getter方法
                                    String methodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                                    Method method = clazz.getMethod(methodName);
                                    Object value = method.invoke(subUpdate${index!}.get(i));
                                    // 检查值是否为null，并相应地构建SQL片段
                                    if (value == null) {
                                        setClause.append(${slave.name}Map.get(field.getName())).append(" = NULL");
                                    } else {
                                        setClause.append(${slave.name}Map.get(field.getName())).append(" = '").append(value).append("'");
                                    }
                                    firstField = false;
                                }
                            } catch (NoSuchMethodException | IllegalAccessException e) {
                                e.printStackTrace();
                                // 处理异常或返回null等
                            }
                        }

                        if (setClause.length() == 0) {
                            return null; // 如果没有可更新的字段，则返回null
                        }

                        String sql = String.format("UPDATE %s SET %s WHERE " + mainIdName +  " = %d;", tableName, setClause.toString(), mainId);
                        sb.append(sql);
                    }
                    ${table.name}Mapper.updateBySqls(sb);
                    //${slave.name?uncap_first}Service.updateBatchById(subUpdate${index!});
                }
            <#assign index++>
            }
        </#list>
        }
    } catch (Exception e) {
        throw new RuntimeException(e);
    }
    return ApiResponse.success();
}
