<#include "../../../auditLog/ds.ftl">
<#assign isSave = 1>
<#assign methodName = name >
<#include "../../../saveordel/saveordel.ftl">
@Override
public ApiResponse<String> ${name!}(${parameter} ${parameter?uncap_first}) {
<#if !ifPlusSave>
    ${table.entityName} ${table.EName} = ${parameter?uncap_first}.getFormdata();
<#else>
    ${incrementTable.type!} ${table.EName} = ${parameter?uncap_first}.getFormdata();
</#if>
    try {
        ${saveOrDel!}
        this.formsubmitreject<#if ifPlusSave>Plus</#if>(${parameter?uncap_first},String.valueOf(${masterTable.EName!}.get${primaryField!}()));
        <#if table?? && table.transDisposition?? && table.transDisposition>
            return ApiResponse.success(TfModelEnum.TF_PROCESS_FORM_WAS_SUCCESSFULLY_SUBMITTED.getMessage());
        <#else>
            return ApiResponse.success("提交流程表单成功");
        </#if>
    } catch(Exception e) {
        throw new HussarException(e.getMessage(),e);
    }
}

@Override
${ds!}
${dataSourceAnnotation!}
public void formsubmitreject<#if ifPlusSave>Plus</#if>(${parameter} ${parameter?uncap_first},String businessKey){
    Map<String, String> appointMap = new HashMap<>();
    Map<String, Object> variable = new HashMap<>();
    try {
        if(HussarUtils.isEmpty(BaseSecurityUtil.getUser())){
        <#if table?? && table.transDisposition?? && table.transDisposition>
            throw new HussarException(TfModelEnum.TF_FAILED_T0_OBTAIN_USER_INFORMATION.getMessage());
        <#else>
            throw new HussarException("获取用户信息失败");
        </#if>
        }
        String taskId = ${parameter?uncap_first}.getTaskId();
        String comment = ${parameter?uncap_first}.getComment();
        if (${parameter?uncap_first}.getFlowSelect() == null) {
            appointMap.put(BpmConstant.STATIC_APPOINT_ASSIGNEE, ${parameter?uncap_first}.getParticipantSelect());
        } else {
            appointMap.put(${parameter?uncap_first}.getFlowSelect(), ${parameter?uncap_first}.getParticipantSelect());
            variable.put(BpmConstant.BPM_NEXT_NODE, ${parameter?uncap_first}.getFlowSelect());
        }
    <#if securityLevel?? && securityLevel != "">
        if (${parameter?uncap_first}.getFormdata() != null && HussarUtils.isNotEmpty(${parameter?uncap_first}.getFormdata().get${securityLevel!}())) {
        variable.put(BpmConstant.SECURITY_LEVEL, Integer.valueOf(${parameter?uncap_first}.getFormdata().get${securityLevel!}()));
        }
    </#if>
        if (${parameter?uncap_first}.getSelectBranches() != null) {
        List<String> nextNodeIds = new ArrayList<>();
            for (Map<String, String> map : ${parameter?uncap_first}.getSelectBranches()) {
                appointMap.put(map.get("flowSelect"), map.get("participants"));
                nextNodeIds.add(map.get("flowSelect"));
            }
            variable.put(BpmConstant.BPM_NEXT_NODE, String.join(",", nextNodeIds));
        }
        String processDefinitionKey = ${parameter?uncap_first}.getProcessDefinitionKey();

        String userId = String.valueOf(BaseSecurityUtil.getUser().getId());
        if (HussarUtils.isEmpty(taskId)) {
            String deptId = BaseSecurityUtil.getUser().getDeptId() == null ? "" : String.valueOf(BaseSecurityUtil.getUser().getDeptId());
            BpmResponseResult startResult;
            startResult = InstanceEngineService.startProcessInstanceByKey(processDefinitionKey, userId, deptId, businessKey, variable);
            if (BpmConstant.SUCCESS_CODE.equals(startResult.getCode())) {
                taskId = (String)startResult.getResult().getJSONObject(0).get("taskId");
            } else {
                <#if table?? && table.transDisposition?? && table.transDisposition>
                throw new HussarException(TfModelEnum.TF_FAILED_TO_CREATE_A_START_NODE.getMessage());
                <#else>
                throw new HussarException("创建开始节点失败");
                </#if>
            }
        }
        BpmResponseResult bpmResponseResult = TaskEngineService.completeLeapTask(taskId, userId, appointMap, null, comment, variable);
        if (!BpmConstant.SUCCESS_CODE.equals(bpmResponseResult.getCode())) {
            throw new HussarException(bpmResponseResult.getMsg());
        }
    } catch(Exception e){
        throw new HussarException(e.getMessage(),e);
    }
}
