<#include "../../../auditLog/ds.ftl">
@Override
<#if !isRemote>${ds!}</#if>
public ApiResponse<String> ${name!}(String id){
    try{
        //调用操作业务数据的方法
        <#assign isSave = -1>
        <#assign idType ="id">
        <#assign getId ="Collections.singletonList(id)">
        <#assign methodName = name >
        <#include "../../../saveordel/saveordel.ftl">
        ${saveOrDel!}
        return this.deleteProcessInstance(id);
    } catch(Exception e){
        throw new HussarException(e.getMessage(),e);
    }

}

@Override
<#if !isRemote>${ds!}</#if>
public ApiResponse<String> ${name!}UnStart(String id){
    // 验证流程状态
    BpmResponseResult validateResult;
    try {
        validateResult = this.getValidateResult(id);
        if (BpmConstant.SUCCESS_CODE.equals(validateResult.getCode())) {
            String state = validateResult.getResult().get(0) == null ? "" : validateResult.getResult().get(0).toString();
            switch (state) {
                //1 代表流程已经启动，并且节点处于第一节点，可以删除业务数据和流程数据
                case BpmConstant.SUCCESS_CODE:
                    // 删除业务数据
                    <#assign isSave = -1>
                    <#assign idType ="id">
                    <#assign getId ="Collections.singletonList(id)">
                    <#assign methodName = name + "UnStart" >
                    <#include "../../../saveordel/saveordel.ftl">
                    ${saveOrDel!}
                    // 删除流程数据
                    <#if isRemote>
                    return this.deleteProcessInstance(id);
                    <#else>
                     return this.deleteProcessInstance(id);
                    </#if>
                //2 代表流程已经启动，并且节点不处于第一节点，不可以删除业务数据和流程数据
                case "2":
                    throw new HussarException(validateResult.getMsg());
                //0 代表流程没有启动，可以删除业务数据，不需要删除流程数据
                case "0":
                    // 删除业务数据
                    <#assign isSave = -1>
                    <#assign idType ="id">
                    <#assign getId ="Collections.singletonList(id)">
                    <#assign methodName = name + "UnStart1" >
                    <#include "../../../saveordel/saveordel.ftl">
                    ${saveOrDel!}
                    return ApiResponse.success("");
                default:
                <#if table?? && table.transDisposition?? && table.transDisposition>
                    throw new HussarException(TfModelEnum.TF_DELETION_FAILED.getMessage());
                <#else>
                    throw new HussarException("删除失败！");
                </#if>
            }
        }
        <#if table?? && table.transDisposition?? && table.transDisposition>
        throw new HussarException(TfModelEnum.TF_DELETION_FAILED.getMessage());
        <#else>
        throw new HussarException("删除失败！");
        </#if>
    } catch(Exception e) {
        throw new HussarException(e.getMessage(),e);
    }
}

@Override
${ds!}
${dataSourceAnnotation!}
public BpmResponseResult getValidateResult(String id) {
    return InstanceEngineService.validateDeleteByBusinessKey(String.valueOf(id));
}

@Override
${ds!}
${dataSourceAnnotation!}
public ApiResponse<String> deleteProcessInstance(String id) {
    BpmResponseResult bpmResponseResult;
    try {
        bpmResponseResult =  InstanceEngineService.deleteProcessInstanceByBusinessKey(String.valueOf(id));
        if (BpmConstant.SUCCESS_CODE.equals(bpmResponseResult.getCode())){
            return ApiResponse.success("");
        }
        throw new HussarException(bpmResponseResult.getMsg());
    } catch(Exception e){
        throw new HussarException(e.getMessage(),e);
    }

}
