/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.util;

import com.jxdinfo.hussar.formdesign.back.factory.FunctionModelFactory;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlCustomOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlEnclosure;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlModelFunction;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class MysqlModelBeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(MysqlModelBeanUtil.class);

    public static MysqlOperationVisitor<MysqlDataModelBase, MysqlDataModelBaseDTO> getVisitorBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u65b9\u6cd5\u8bbf\u95ee\u8005\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u65b9\u6cd5\u8bbf\u95ee\u8005\u5931\u8d25");
        }
        return (MysqlOperationVisitor)fromObj;
    }

    public static MysqlModelFunction getFunctionModelVisitorBean(String functionModelName) throws LcdpException {
        Object fromObj;
        try {
            fromObj = FunctionModelFactory.obtainFunction((String)("MYSQL." + functionModelName)).newInstance();
            if (ObjectUtils.isEmpty(fromObj)) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, fromObj + "\uff1a\u529f\u80fd\u6a21\u578b\u672a\u6ce8\u518c");
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, functionModelName + "\uff1a\u83b7\u53d6\u529f\u80fd\u6a21\u578b\u5931\u8d25");
        }
        return (MysqlModelFunction)fromObj;
    }

    public static MysqlRender<MysqlDataModelBase, MysqlDataModelBaseDTO> getRenderBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (MysqlRender)fromObj;
    }

    public static MysqlEnclosure<MysqlDataModelBase> getEnclosureBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (MysqlEnclosure)fromObj;
    }

    public static MysqlCustomOperation getCustomOperationBean(String ... beanName) throws LcdpException {
        Object fromObj;
        String bean = String.join((CharSequence)"", beanName);
        if (ObjectUtils.isEmpty((Object[])beanName)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\u672a\u6ce8\u518c");
        }
        try {
            fromObj = SpringUtil.getBean((String)bean);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6bean({})\u5931\u8d25", (Object)bean, (Object)e);
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, bean + "\uff1a\u83b7\u53d6\u5931\u8d25");
        }
        return (MysqlCustomOperation)fromObj;
    }
}

