/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.task.masterslavetask.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.relationship.MysqlRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MysqlTaskMsUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";
    private static final String FLOW_INCREMENT_NAME = "FlowIncrementDTO";

    private MysqlTaskMsUtil() {
    }

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> backCtx) throws LcdpException {
        MysqlTaskMsUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> backCtx) {
        MysqlTaskMsUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        MysqlMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        MysqlMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        MysqlDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<MysqlRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        MysqlDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        if (params.get("logicallyDelete") != null) {
            for (MysqlRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.init();
            }
        } else {
            for (MysqlRelationshipDTO relationshipDTO : relationshipDtoList) {
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = MysqlTaskMsUtil.getDelStr(relationshipDtoList, masterDto);
        MysqlTaskMsUtil.renderTransaction(backCtx, params);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (MysqlRelationshipDTO mysqlRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            MysqlDataModelBaseDTO mysqlDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(mysqlRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, mysqlDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, mysqlDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, mysqlDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        MysqlMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        MysqlMsDataModelDTO mysqlMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<MysqlRelationshipDTO> relationshipDtoList = mysqlMsDataModelDTO.getRelationshipDtoList();
        MysqlDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, MysqlDataModelBaseDTO> dataModelDtoMap = mysqlMsDataModelDTO.getDataModelDtoMap();
        MysqlDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        MysqlTaskMsUtil.renderTransaction(backCtx, controllerParams);
        String masterFillCode = MysqlTaskMsUtil.renderFillCode(backCtx, mainDataModelDto, mysqlMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (MysqlRelationshipDTO mysqlRelationshipDTO : relationshipDtoList) {
                List<MysqlRelationshipFieldDTO> mysqlRelationshipFieldDTOS;
                String slaveTableId = mysqlRelationshipDTO.getSlaveTableId();
                String relateModelType = mysqlRelationshipDTO.getRelateModelType();
                MysqlDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = MysqlTaskMsUtil.renderFillCode(backCtx, slaveModelDto, mysqlMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    mysqlRelationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(mysqlRelationshipFieldDTOS = mysqlRelationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> backCtx, Map<String, Object> controllerParams) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> backCtx, MysqlDataModelBaseDTO dataModelBaseDTO, MysqlMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (MysqlDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("modelId", msDataModelDTO.getId());
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true);
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/taskbackcode/masterslavetaskbackcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<MysqlRelationshipDTO> relationshipDtoList, MysqlDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (MysqlRelationshipDTO relationtMap : relationshipDtoList) {
            List<MysqlRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            MysqlRelationshipFieldDTO mysqlRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(mysqlRelationshipFieldDTO.getSlaveFieldCap()).append(",idList));\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(mysqlRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                MysqlRelationshipFieldDTO mysqlRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(mysqlRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(mysqlRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(mysqlRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(MysqlTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(mysqlRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(mysqlRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(MysqlTaskMsUtil.lowercase(masterDto.getEntityName())).append(".get").append(mysqlRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void transferControllerCode(MysqlDataModelBaseDTO fromDataModelBaseDTO, MysqlDataModelBaseDTO toDataModelBaseDTO) {
        ControllerGenerateInfo businessController = fromDataModelBaseDTO.getControllerGenerateInfo();
        ControllerGenerateInfo taskController = toDataModelBaseDTO.getControllerGenerateInfo();
        if (HussarUtils.isEmpty((Object)taskController)) {
            taskController = new ControllerGenerateInfo();
            toDataModelBaseDTO.setControllerGenerateInfo(taskController);
        }
        if (HussarUtils.isNotEmpty((Object)businessController)) {
            if (HussarUtils.isNotEmpty(businessController.getImports())) {
                if (HussarUtils.isEmpty(taskController.getImports())) {
                    taskController.setImports(new HashSet<String>());
                }
                taskController.getImports().addAll(businessController.getImports());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversions())) {
                if (HussarUtils.isEmpty(taskController.getInversions())) {
                    taskController.setInversions(new HashSet<String>());
                }
                taskController.getInversions().addAll(businessController.getInversions());
            }
            if (HussarUtils.isNotEmpty(businessController.getInversionsWithName())) {
                if (HussarUtils.isEmpty(taskController.getInversionsWithName())) {
                    taskController.setInversionsWithName(new HashMap<String, String>());
                }
                taskController.getInversionsWithName().putAll(businessController.getInversionsWithName());
            }
            if (HussarUtils.isNotEmpty(businessController.getCodes())) {
                if (HussarUtils.isEmpty(taskController.getCodes())) {
                    taskController.setCodes(new ArrayList<String>());
                }
                taskController.getCodes().addAll(businessController.getCodes());
            }
        }
        if (HussarUtils.isNotEmpty(fromDataModelBaseDTO.getApis())) {
            if (HussarUtils.isEmpty(toDataModelBaseDTO.getApis())) {
                toDataModelBaseDTO.setApis(new ArrayList<String>());
            }
            toDataModelBaseDTO.getApis().addAll(fromDataModelBaseDTO.getApis());
        }
    }

    public static void generateIncrementDTO(MysqlMsDataModelDTO mysqlFlowDataModelDTO, MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) {
        Map<String, Object> params = dataModelOperation.getParams();
        Map slaveTablePlusSave = (Map)params.get("slaveTablePlusSave");
        boolean plusFlag = false;
        if (HussarUtils.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        params.put("ifPlusSave", plusFlag);
        if (!plusFlag) {
            return;
        }
        MysqlMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        MysqlTaskMsUtil.addIncrementTable(mysqlFlowDataModelDTO, slaveTablePlusSave, dataModelBase);
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        block1: for (MysqlDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            String slaveModelName = modelBase.getName();
            for (MysqlDataModelField field : modelBase.getFields()) {
                if (!"primary".equals(field.getUsage())) continue;
                primaryKeys.put(slaveModelName, field.getName());
                break;
            }
            for (MysqlDataModelField field : modelBase.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                foreignKeys.put(slaveModelName, field.getName());
                continue block1;
            }
        }
        params.put("primaryKeys", primaryKeys);
        params.put("foreignKeys", foreignKeys);
        params.put("slaveTablePlusSave", slaveTablePlusSave);
        params.put("slaveTable", dataModelBase.getSlaveTables());
        String modelId = backCtx.getUseDataModelBase().getId();
        if (HussarUtils.isEmpty((Object)mysqlFlowDataModelDTO.getQueryDtoMap().get(mysqlFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME))) {
            MysqlQueryDTO oldDTO = mysqlFlowDataModelDTO.getQueryDtoMap().get(mysqlFlowDataModelDTO.getName());
            MysqlQueryDTO mysqlQueryDTO = (MysqlQueryDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDTO), MysqlQueryDTO.class);
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("queryDto", mysqlQueryDTO);
            HashMap<String, Boolean> table = new HashMap<String, Boolean>();
            table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
            newParams.put("table", table);
            mysqlQueryDTO.setParams(newParams);
            String plusDtoName = mysqlFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME;
            String plusTableName = mysqlFlowDataModelDTO.getEntityName() + "IncrementTable";
            for (MysqlQueryFieldDTO dto : mysqlQueryDTO.getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                dto.getDbColumnType().setType(plusTableName);
                dto.getDbColumnType().setImportT(mysqlQueryDTO.getPackageInfo() + "." + plusTableName);
                params.put("incrementTable", dto.getDbColumnType());
                backCtx.addServiceImplImport(modelId, dto.getDbColumnType().getImportT());
                break;
            }
            mysqlQueryDTO.setName(mysqlQueryDTO.getName() + FLOW_INCREMENT_NAME);
            mysqlQueryDTO.setEntityName(plusDtoName);
            mysqlQueryDTO.setImportInfo(mysqlQueryDTO.getPackageInfo() + "." + plusDtoName);
            mysqlQueryDTO.setWriteFilePath(FileUtil.systemPath((String[])new String[]{mysqlFlowDataModelDTO.getTablePath(), "dto", plusDtoName + ".java"}));
            mysqlFlowDataModelDTO.getQueryDtoMap().put(mysqlQueryDTO.getName(), mysqlQueryDTO);
            params.put("parameter", plusDtoName);
            backCtx.addControllerImport(modelId, mysqlQueryDTO.getImportInfo());
            backCtx.addServiceImport(modelId, mysqlQueryDTO.getImportInfo());
            backCtx.addServiceImplImport(modelId, mysqlQueryDTO.getImportInfo());
        } else {
            for (MysqlQueryFieldDTO dto : mysqlFlowDataModelDTO.getQueryDtoMap().get(mysqlFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME).getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                params.put("incrementTable", dto.getDbColumnType());
                break;
            }
            params.put("parameter", mysqlFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME);
        }
    }

    private static void addIncrementTable(MysqlMsDataModelDTO dataModelBaseDTO, Map<String, Boolean> slaveTablePlusSave, MysqlMsDataModel dataModelBase) {
        MysqlQueryDTO queryDTO = new MysqlQueryDTO();
        boolean containDate = false;
        String masterId = dataModelBase.getMasterTable().getId();
        for (MysqlDataModelField dataModelField : dataModelBase.getMasterTable().getFields()) {
            if (!"date".equals(dataModelField.getDataType())) continue;
            containDate = true;
            break;
        }
        queryDTO.setFtlPath("template/backcode/code/formPlusSave.ftl");
        HashMap<String, Boolean> table = new HashMap<String, Boolean>();
        table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelBaseDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", dataModelBase.getSlaveTables());
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("importInfo", dataModelBaseDTO.getPackageInfo().get("Entity"));
        params.put("containDate", containDate);
        params.put("queryDto", queryDTO);
        params.put("table", table);
        queryDTO.setParams(params);
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setName(dataModelBaseDTO.getName() + "IncrementTable");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "IncrementTable");
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }
}

