/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.task.masterslavetask;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.visitor.masterslave.MysqlMsExcelImportVisitor;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLTASK_MASTER_SLAVEExcelExport")
public class MysqlMsTaskExcelExportVisitor
implements MysqlOperationVisitor<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsExcelImportVisitor.class);
    public static final String OPERATION_NAME = "MYSQLTASK_MASTER_SLAVEExcelExport";

    @Override
    public void visit(MysqlBackCtx<MysqlTaskMsDataModel, MysqlTaskMsDataModelDTO> backCtx, MysqlDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        MysqlTaskMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        MysqlDataModelBase masterTable = dataModelBase.getMasterTable();
        MysqlTaskMsDataModelDTO mysqlFlowMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = mysqlFlowMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, MysqlDataModelBaseDTO> dataModelDtoMap = mysqlFlowMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", mysqlFlowMsDataModelDTO);
        controllerParams.put("returnValue", mysqlFlowMsDataModelDTO.getEntityName());
        controllerParams.put("url", url);
        controllerParams.put("operationName", controllerParams.get("name"));
        controllerParams.put("selectCondition", mysqlFlowMsDataModelDTO.getEntityName());
        MysqlDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Service"));
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        backCtx.addServiceImplImport(modelId, masterDTO.getImportInfo().get("Entity"));
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(mysqlFlowMsDataModelDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/masterslavebackcode/excelExport/controller.ftl";
        controllerParams.put("QueryObj", mysqlFlowMsDataModelDTO.getEntityName() + "SelectCondition");
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.GetMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelExportDto");
        backCtx.addControllerImport(modelId, "com.alibaba.fastjson.JSON");
        backCtx.addControllerImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, mysqlFlowMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerInversion(modelId, mysqlFlowMsDataModelDTO.getServiceName());
        if (ToolUtil.isNotEmpty((Object)mysqlFlowMsDataModelDTO.isHasTranslate()) && mysqlFlowMsDataModelDTO.isHasTranslate()) {
            for (MysqlDataModelFieldDto field : mysqlFlowMsDataModelDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = field.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                field.setDictTyeName(typeName);
            }
            mysqlFlowMsDataModelDTO.getDataModelDtoMap().entrySet().stream().filter(a -> !masterTable.getId().equals(a.getKey())).forEach(entry -> {
                for (MysqlDataModelFieldDto field : ((MysqlDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String servicePath = "template/masterslavebackcode/excelExport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImport(modelId, "java.util.List");
        String serviceImplPath = "template/masterslavebackcode/excelExport/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.annotations.QueryAlias");
        backCtx.addServiceImplImport(modelId, "javax.servlet.http.HttpServletResponse");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "java.util.LinkedHashMap");
        backCtx.addServiceImplImport(modelId, "java.util.Set");
        backCtx.addServiceImplImport(modelId, "java.util.Objects");
        backCtx.addServiceImplInversion(modelId, mysqlFlowMsDataModelDTO.getMapperName());
        String mapperPath = "template/masterslavebackcode/excelExport/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "java.util.LinkedHashMap");
        String xmlPath = "template/masterslavebackcode/excelExport/xml.ftl";
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "downloadResource", url, "\u4e3b\u5b50\u8868Excel\u5bfc\u51fa");
        backCtx.addApi(modelId, MysqlBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }
}

