/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.task.basetask;

import com.jxdinfo.hussar.formdesign.back.common.constant.QueryType;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.base.MysqlBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.task.MysqlTaskDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlBaseRender;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.SqlReturnUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLTASKConditionFilter")
public class MysqlTaskConditionFilterVisitor
implements MysqlOperationVisitor<MysqlTaskDataModel, MysqlTaskDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlTaskConditionFilterVisitor.class);
    public static final String OPERATION_NAME = "MYSQLTASKConditionFilter";

    @Override
    public void visit(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> taskBackCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        boolean queryTypeIsTask;
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = taskBackCtx.getUseDataModelBase().getId();
        boolean bl = queryTypeIsTask = !QueryType.isTask((String)((String)dataModelOperation.getParams().get("queryType")));
        if (queryTypeIsTask) {
            this.publishTaskQueryMethod(taskBackCtx, dataModelOperation);
            return;
        }
        MysqlFlowDataModelDTO dataModelBaseDTO = (MysqlFlowDataModelDTO)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelDtoMap().get(modelId);
        MysqlFlowDataModel mysqlBaseDataModel = (MysqlFlowDataModel)taskBackCtx.getUseDataModelDtoMap().get(modelId).getDataModelBaseMap().get(modelId);
        MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx = new MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO>();
        backCtx.setUseDataModelBase(mysqlBaseDataModel);
        HashMap<String, MysqlFlowDataModelDTO> map = new HashMap<String, MysqlFlowDataModelDTO>();
        map.put(modelId, dataModelBaseDTO);
        backCtx.setUseDataModelDtoMap(map);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO, mysqlBaseDataModel);
        MysqlDataModelFieldDto fieldDto = dataModelBaseDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto.getPropertyName());
            hasSecurityLevel = true;
        }
        boolean isSortCondition = this.renderSort(dataModelOperation, controllerParams, mysqlBaseDataModel);
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        this.renderFilter(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        String controllerPath = "template/taskbackcode/basetaskbackcode/conditionFilter/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/taskbackcode/basetaskbackcode/conditionFilter/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        controllerParams.put("queryTypeIsTask", queryTypeIsTask);
        String serviceImplPath = "template/taskbackcode/basetaskbackcode/conditionFilter/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSortOverall, isSortCondition, hasSecurityLevel);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void publishTaskQueryMethod(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException, IOException, CloneNotSupportedException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        boolean queryTypeIsTask = !QueryType.isTask((String)((String)dataModelOperation.getParams().get("queryType")));
        MysqlTaskDataModel useDataModelBase = backCtx.getUseDataModelBase();
        MysqlTaskDataModelDTO useDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        boolean isLogicallyDelete = useDataModelBase.getLogicallyDelete();
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, useDataModelDTO, useDataModelBase);
        MysqlDataModelFieldDto fieldDto = useDataModelDTO.getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto.getPropertyName());
            hasSecurityLevel = true;
        }
        boolean isSortCondition = this.renderSort(dataModelOperation, controllerParams, useDataModelBase);
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        this.renderFilter(backCtx, dataModelOperation, modelId, useDataModelDTO, controllerParams);
        boolean isSortOverall = true;
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, useDataModelDTO, controllerParams);
        String controllerPath = "template/taskbackcode/basetaskbackcode/conditionFilter/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, useDataModelDTO.getServiceName());
        String servicePath = "template/taskbackcode/basetaskbackcode/conditionFilter/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        controllerParams.put("queryTypeIsTask", queryTypeIsTask);
        String serviceImplPath = "template/taskbackcode/basetaskbackcode/conditionFilter/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        if (queryTypeIsTask) {
            backCtx.addServiceImplInversion(modelId, useDataModelDTO.getMapperName());
            String mapperPath = "template/taskbackcode/basetaskbackcode/conditionFilter/mapper.ftl";
            backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
            String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName());
            controllerParams.put("return", finalReturn);
            String finalRelation = QueryType.isFlowTotals((String)((String)dataModelOperation.getParams().get("queryType"))) ? SqlReturnUtil.renderFlowTotalsRelation(backCtx.getUseDataModelBase(), useDataModelDTO.getDataModelBaseMap()) : SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), useDataModelDTO.getDataModelBaseMap());
            controllerParams.put("relation", finalRelation);
            if (isLogicallyDelete) {
                String logicallyFlag = backCtx.getUseDataModelBase().getModelAliasName().get(backCtx.getUseDataModelBase().getId()) + "." + backCtx.getUseDataModelBase().getDeleteFlag().getSourceFieldName();
                controllerParams.put("logicallyFlag", logicallyFlag);
            }
            String xmlPath = "template/taskbackcode/basetaskbackcode/conditionFilter/xml.ftl";
            backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        }
        this.renderTaskImport(backCtx, modelId, useDataModelDTO, isPagination, isSortOverall, isSortCondition, hasSecurityLevel);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), useDataModelDTO);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", useDataModelDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlBaseDataModelDTO dataModelBaseDTO, MysqlBaseDataModel mysqlBaseDataModel) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        boolean isLogicallyDelete = mysqlBaseDataModel.getLogicallyDelete();
        controllerParams.put("logicallyDelete", isLogicallyDelete);
        if (isLogicallyDelete) {
            MysqlDataModelField logicallyField = mysqlBaseDataModel.getDeleteFlag();
            controllerParams.put("logicallyFlag", logicallyField.getSourceFieldName());
            String logicallyFieldName = logicallyField.getName();
            char[] chars = logicallyFieldName.toCharArray();
            chars[0] = (char)(chars[0] - 32);
            controllerParams.put("getLogicallyFlag", String.valueOf(chars));
            controllerParams.put("deleteFlagName", logicallyField.getSourceFieldName());
        }
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u81ea\u5b9a\u4e49\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private void renderImport(MysqlBackCtx<MysqlFlowDataModel, MysqlFlowDataModelDTO> backCtx, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSortOverall, boolean isSortCondition, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty(dataModelBaseDTO.getTranslateShowFields())) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        if (backCtx.getUseDataModelBase().getLogicallyDelete()) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        }
        if (isSortCondition) {
            if (isPagination) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
    }

    private void renderTaskImport(MysqlBackCtx<MysqlTaskDataModel, MysqlTaskDataModelDTO> backCtx, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSortOverall, boolean isSortCondition, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "java.util.List");
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.Map");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto");
        backCtx.addServiceImplImport(modelId, "java.util.HashMap");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
        backCtx.addServiceImplImport(modelId, "com.alibaba.fastjson.JSON");
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (backCtx.getUseDataModelBase().getLogicallyDelete()) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
        }
        if (isSortCondition) {
            if (isPagination) {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            } else {
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            }
        }
        if (isPagination) {
            backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
        backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.metadata.IPage");
    }

    private boolean renderSort(MysqlDataModelOperation dataModelOperation, Map<String, Object> templateParams, MysqlBaseDataModel useDataModelBase) throws LcdpException {
        MysqlSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(MysqlSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            List<MysqlSortConditionField> sortConditionFields = sortCondition.getFields();
            for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                sortConditionField.replaceFieldName();
            }
            templateParams.put("sortConditionObj", sortCondition);
            templateParams.put("isSortCondition", true);
            return true;
        }
        return false;
    }

    private boolean renderFilter(MysqlBackCtx backCtx, MysqlDataModelOperation dataModelOperation, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("showFilter"));
        if (!StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{selectConditionName})) {
            return false;
        }
        controllerParams.put("showFilter", true);
        MysqlQueryDTO queryDTO = MysqlDataModelUtil.getFilterDto(dataModelBaseDTO);
        dataModelBaseDTO.addQueryDto(queryDTO);
        controllerParams.put("QueryObj", queryDTO.getEntityName());
        controllerParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private void renderPageVo(MysqlBackCtx backCtx, String modelId, MysqlBaseDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        MysqlDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + MysqlDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }
}

