/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.masterslave;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBase;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLMASTER_SLAVEExcelImport")
public class MysqlMsExcelImportVisitor
implements MysqlOperationVisitor<MysqlMsDataModel, MysqlMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsExcelImportVisitor.class);
    public static final String OPERATION_NAME = "MYSQLMASTER_SLAVEExcelImport";

    @Override
    public void visit(MysqlBackCtx<MysqlMsDataModel, MysqlMsDataModelDTO> backCtx, MysqlDataModelOperation operation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        MysqlMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        MysqlDataModelBase masterTable = dataModelBase.getMasterTable();
        MysqlMsDataModelDTO mysqlMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        String url = mysqlMsDataModelDTO.getApiPrefix() + "/" + operation.getName();
        Map<String, MysqlDataModelBaseDTO> dataModelDtoMap = mysqlMsDataModelDTO.getDataModelDtoMap();
        Map<String, Object> controllerParams = operation.getParams();
        controllerParams.put("table", mysqlMsDataModelDTO);
        controllerParams.put("operationName", controllerParams.get("name"));
        controllerParams.put("slaveTable", MysqlMsExcelImportVisitor.getSlaveTables(mysqlMsDataModelDTO, dataModelBase));
        controllerParams.put("primaryField", mysqlMsDataModelDTO.getKeyPropertyName());
        MysqlDataModelBaseDTO masterDTO = dataModelDtoMap.get(masterTable.getId());
        controllerParams.put("masterServiceName", masterDTO.getServiceName());
        for (MysqlDataModelBaseDTO dataModelBaseDTO : dataModelDtoMap.values()) {
            backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        }
        backCtx.addServiceImplInversion(modelId, masterDTO.getServiceName());
        if (HussarUtils.isEmpty((Object)operation.getExegesis())) {
            operation.setExegesis(mysqlMsDataModelDTO.getComment() + "\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
            controllerParams.put("exegesis", operation.getExegesis());
        }
        String controllerPath = "template/masterslavebackcode/excelImport/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addControllerImport(modelId, mysqlMsDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, mysqlMsDataModelDTO.getImportInfo().get("Entity"));
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addControllerInversion(modelId, mysqlMsDataModelDTO.getServiceName());
        String servicePath = "template/masterslavebackcode/excelImport/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        if (ToolUtil.isNotEmpty((Object)mysqlMsDataModelDTO.isHasTranslate()) && mysqlMsDataModelDTO.isHasTranslate()) {
            for (MysqlDataModelFieldDto mysqlDataModelFieldDto : mysqlMsDataModelDTO.getFields()) {
                String typeName = "";
                String fieldAnnotation = mysqlDataModelFieldDto.getFieldAnnotation();
                if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                    int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                    int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                    if (startIndex != -1 && endIndex != -1) {
                        typeName = fieldAnnotation.substring(startIndex, endIndex);
                    }
                }
                mysqlDataModelFieldDto.setDictTyeName(typeName);
            }
            mysqlMsDataModelDTO.getDataModelDtoMap().entrySet().stream().skip(1L).forEach(entry -> {
                for (MysqlDataModelFieldDto field : ((MysqlDataModelBaseDTO)entry.getValue()).getFields()) {
                    String typeName = "";
                    String fieldAnnotation = field.getFieldAnnotation();
                    if (HussarUtils.isNotEmpty((Object)fieldAnnotation) && fieldAnnotation.startsWith("@Trans")) {
                        int startIndex = fieldAnnotation.indexOf("key = \"") + 7;
                        int endIndex = fieldAnnotation.indexOf("\"", startIndex);
                        if (startIndex != -1 && endIndex != -1) {
                            typeName = fieldAnnotation.substring(startIndex, endIndex);
                        }
                    }
                    field.setDictTyeName(typeName);
                }
            });
            backCtx.addServiceImplInversion(modelId, "ISysDicRefService");
        }
        String serviceImplPath = "template/masterslavebackcode/excelImport/service_impl.ftl";
        controllerParams.put("mainName", masterTable.getSourceDataModelName());
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "org.springframework.web.multipart.MultipartFile");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.dto.ExcelCommonDto");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.vo.DictVo");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.service.ISysDicRefService");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.general.dict.model.DicSingle");
        backCtx.addServiceImplImport(modelId, "java.util.stream.Collectors");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.utils.HussarUtils");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.excel.util.ExcelUtils");
        backCtx.addServiceImplImport(modelId, "java.lang.reflect.Field");
        backCtx.addServiceImplImport(modelId, "java.util.function.Function");
        backCtx.addServiceImplImport(modelId, "java.util.Arrays");
        backCtx.addServiceImplImport(modelId, "java.util.Collections");
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.annotation.TableId");
        backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.annotation.TableField");
        backCtx.addServiceImplImport(modelId, "java.lang.reflect.Method;");
        backCtx.addServiceImplInversion(modelId, mysqlMsDataModelDTO.getMapperName());
        backCtx.addServiceImplInversion(modelId, mysqlMsDataModelDTO.getServiceName());
        for (MysqlDataModelBaseDTO dataModelBaseDTO : mysqlMsDataModelDTO.getDataModelDtoMap().values()) {
            backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getServiceName());
        }
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(operation.getName(), "data", "postJson", url, "\u4e3b\u5b50\u8868Excel\u5bfc\u5165");
        backCtx.addApi(modelId, MysqlBackRenderUtil.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private static List<MysqlDataModelBase> getSlaveTables(MysqlMsDataModelDTO dataModelBaseDTO, MysqlMsDataModel dataModelBase) {
        CopyOnWriteArrayList<MysqlDataModelBase> slaveArrayTables = new CopyOnWriteArrayList<MysqlDataModelBase>(dataModelBase.getSlaveTables());
        block0: for (MysqlDataModelBase slaveArrayTable : slaveArrayTables) {
            for (MysqlDataModelField field : slaveArrayTable.getFields()) {
                if (!"foreign".equals(field.getUsage())) continue;
                slaveArrayTable.setForeignField(field.getName());
                continue block0;
            }
        }
        return slaveArrayTables;
    }
}

