/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.visitor.flow.masterslaveflow;

import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.back.constant.SqlConnectEnum;
import com.jxdinfo.hussar.formdesign.back.model.dataset.DataSet;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlOperationVisitor;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.flow.MysqlFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.element.masterslave.MysqlMsDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.mysql.function.model.field.MysqlQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.operation.MysqlDataModelOperation;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.querycondition.MysqlQueryConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortCondition;
import com.jxdinfo.hussar.formdesign.mysql.function.model.sortcondition.MysqlSortConditionField;
import com.jxdinfo.hussar.formdesign.mysql.function.render.MysqlBaseRender;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataModelUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.PrimaryFieldUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.SqlReturnUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.datamodel.QueryConditionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLFLOW_MASTER_SLAVETableQuery")
public class MysqlMsFlowTableQueryVisitor
implements MysqlOperationVisitor<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlMsFlowTableQueryVisitor.class);
    public static final String OPERATION_NAME = "MYSQLFLOW_MASTER_SLAVETableQuery";

    @Override
    public void visit(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation) throws LcdpException {
        logger.debug("\u65b9\u6cd5\u5f00\u59cb");
        String modelId = backCtx.getUseDataModelBase().getId();
        MysqlFlowMsDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        Map<String, Object> controllerParams = this.initParams(dataModelOperation, dataModelBaseDTO);
        MysqlMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        String mastId = useDataModelBase.getMasterTable().getId();
        MysqlDataModelFieldDto fieldDto = dataModelBaseDTO.getDataModelDtoMap().get(mastId).getFields().stream().filter(filed -> "securityLevel".equals(filed.getFill())).findFirst().orElse(null);
        boolean hasSecurityLevel = false;
        if (fieldDto != null) {
            controllerParams.put("securityLevel", fieldDto);
            String securityLevelSql = useDataModelBase.getModelAliasName().get(mastId) + "." + fieldDto.getName() + " &lt;= #{securityLevel}";
            controllerParams.put("securityLevelSql", securityLevelSql);
            hasSecurityLevel = true;
        }
        boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
        controllerParams.put("isPagination", isPagination);
        boolean isSortOverall = true;
        boolean isSortCondition = this.renderSort(backCtx, dataModelOperation, modelId, controllerParams, backCtx.getUseDataModelBase(), isPagination);
        boolean isSelectCondition = this.renderSelect(backCtx, dataModelOperation, modelId, dataModelBaseDTO, controllerParams);
        controllerParams.put("isSortOverall", isSortOverall);
        this.renderPageVo(backCtx, modelId, dataModelBaseDTO, controllerParams);
        SqlReturnUtil.renderAlias(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName(), dataModelBaseDTO);
        String controllerPath = "template/masterslavebackcode/query/controller.ftl";
        backCtx.addControllerCode(modelId, RenderUtil.renderTemplate((String)controllerPath, controllerParams));
        backCtx.addControllerInversion(modelId, dataModelBaseDTO.getServiceName());
        String servicePath = "template/masterslavebackcode/query/service.ftl";
        backCtx.addServiceCode(modelId, RenderUtil.renderTemplate((String)servicePath, controllerParams));
        String serviceImplPath = "template/masterslavebackcode/query/service_impl.ftl";
        backCtx.addServiceImplCode(modelId, RenderUtil.renderTemplate((String)serviceImplPath, controllerParams));
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String finalReturn = SqlReturnUtil.renderReturn(backCtx.getUseDataModelBase(), backCtx.getUseDataModelBase().getModelAliasName());
        controllerParams.put("return", finalReturn);
        backCtx.addServiceImplInversion(modelId, dataModelBaseDTO.getMapperName());
        String mapperPath = "template/masterslavebackcode/query/mapper.ftl";
        backCtx.addMapperCode(modelId, RenderUtil.renderTemplate((String)mapperPath, controllerParams));
        String xmlPath = "template/masterslavebackcode/query/xml.ftl";
        String finalRelation = SqlReturnUtil.renderRelation(backCtx.getUseDataModelBase(), dataModelBaseDTO.getDataModelBaseMap());
        controllerParams.put("relation", finalRelation);
        backCtx.addXmlCode(modelId, RenderUtil.renderTemplate((String)xmlPath, controllerParams));
        this.renderImport(backCtx, modelId, dataModelBaseDTO, isPagination, isSelectCondition, isSortCondition, isSortOverall, hasSecurityLevel);
        ApiGenerateInfo apiGenerateInfo = new ApiGenerateInfo(dataModelOperation.getName(), "data", "postJson", dataModelBaseDTO.getApiPrefix() + "/" + dataModelOperation.getName(), "\u67e5\u8be2");
        backCtx.addApi(modelId, MysqlBaseRender.renderTemplate("template/backcode/api/api-part.ftl", apiGenerateInfo));
        logger.debug("\u65b9\u6cd5\u7ed3\u675f");
    }

    private void renderImport(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, String modelId, MysqlFlowMsDataModelDTO dataModelBaseDTO, boolean isPagination, boolean isSelectCondition, boolean isSortCondition, boolean isSortOverall, boolean hasSecurityLevel) {
        backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addServiceImplImport(modelId, "java.util.List");
        backCtx.addServiceImplImport(modelId, "java.util.ArrayList");
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Mapper"));
        backCtx.addServiceImplImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (hasSecurityLevel) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
        }
        if (ToolUtil.isNotEmpty((Object)dataModelBaseDTO.isHasTranslate()) && dataModelBaseDTO.isHasTranslate()) {
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil");
        }
        backCtx.addMapperImport(modelId, "java.util.List");
        backCtx.addMapperImport(modelId, dataModelBaseDTO.getImportInfo().get("Entity"));
        if (isPagination) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            if (!isSelectCondition) {
                backCtx.addControllerImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
                backCtx.addServiceImport(modelId, "com.baomidou.mybatisplus.extension.plugins.pagination.Page");
            }
        } else if (isSelectCondition) {
            backCtx.addControllerImport(modelId, "org.springframework.web.bind.annotation.RequestBody");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        }
        if (isSortOverall) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "java.util.Map");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addServiceImplImport(modelId, "java.util.HashMap");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.metadata.OrderItem");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator");
            backCtx.addServiceImplImport(modelId, "com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator");
        }
        if (isSortCondition) {
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.toolkit.Constants");
            backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
            backCtx.addMapperImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
        }
    }

    private Map<String, Object> initParams(MysqlDataModelOperation dataModelOperation, MysqlFlowMsDataModelDTO dataModelBaseDTO) {
        Map<String, Object> controllerParams = dataModelOperation.getParams();
        controllerParams.put("table", dataModelBaseDTO);
        controllerParams.put("returnValue", dataModelBaseDTO.getEntityName());
        if (HussarUtils.isEmpty((Object)dataModelOperation.getExegesis())) {
            boolean isPagination = Boolean.parseBoolean(String.valueOf(dataModelOperation.getParams().get("isPagination")));
            if (HussarUtils.isNotEmpty((Object)dataModelBaseDTO.getComment())) {
                dataModelOperation.setExegesis(dataModelBaseDTO.getComment() + "\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            } else {
                dataModelOperation.setExegesis("\u8868\u683c\u67e5\u8be2" + (isPagination ? "\uff08\u5e26\u5206\u9875\uff09" : ""));
            }
            controllerParams.put("exegesis", dataModelOperation.getExegesis());
        }
        return controllerParams;
    }

    private boolean renderSelect(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, MysqlFlowMsDataModelDTO dataModelBaseDTO, Map<String, Object> templateParams) {
        String selectConditionName = String.valueOf(dataModelOperation.getParams().get("selectCondition"));
        Map<String, String> aliasMap = backCtx.getUseDataModelBase().getModelAliasName();
        String inValuesSql = this.getInValuesSql(backCtx.getUseDataModelBase(), dataModelOperation, aliasMap, selectConditionName);
        MysqlMsDataModel msDataModel = backCtx.getUseDataModelBase();
        MysqlDataModelField deleteField = msDataModel.getDeleteFlag();
        boolean isLogicallyDelete = msDataModel.isLogicallyDelete();
        if (!StringUtil.isNotBlank((CharSequence)selectConditionName)) {
            if (isLogicallyDelete) {
                templateParams.put("addLogicallyCondition", true);
                String logicallyFlag = msDataModel.getModelAliasName().get(msDataModel.getMasterTable().getId()) + "." + deleteField.getSourceFieldName();
                templateParams.put("logicallyFlag", logicallyFlag);
            }
            return false;
        }
        MysqlQueryCondition queryCondition = backCtx.getUseDataModelBase().getQuConBaseByName(selectConditionName);
        if (HussarUtils.isNotEmpty((Object)templateParams.get("securityLevel"))) {
            MysqlDataModelFieldDto fieldDto = (MysqlDataModelFieldDto)templateParams.get("securityLevel");
            MysqlQueryConditionField field = new MysqlQueryConditionField();
            field.setConnect("and");
            field.setFromModelField(fieldDto.getId());
            field.setQueryAttrName(fieldDto.getPropertyName());
            field.setFromModelId(backCtx.getUseDataModelBase().getMasterTable().getId());
            field.setType("row");
            field.setSymbol("<=");
            queryCondition.getFields().add(field);
        }
        ArrayList<String> likeQueryFields = new ArrayList<String>();
        for (MysqlQueryConditionField queryConditionField : queryCondition.getFields()) {
            String fromModelField = queryConditionField.getFromModelField();
            List<MysqlDataModelField> fields = backCtx.getUseDataModelBase().getFields();
            boolean isStringType = true;
            for (MysqlDataModelField field : fields) {
                if (!fromModelField.equals(field.getId()) || "string".equals(field.getDataType())) continue;
                isStringType = false;
                break;
            }
            if (!isStringType) continue;
            String symbol = queryConditionField.getSymbol();
            if (!HussarUtils.equals((Object)SqlConnectEnum._LEFT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._RIGHT_LIKE.getKey(), (Object)symbol) && !HussarUtils.equals((Object)SqlConnectEnum._FULL_LIKE.getKey(), (Object)symbol)) continue;
            likeQueryFields.add(PrimaryFieldUtil.getLikeQueryField(queryConditionField.getQueryAttrName()));
        }
        templateParams.put("likeQueryFields", likeQueryFields);
        if (!Optional.ofNullable(queryCondition).map(MysqlQueryCondition::getFields).isPresent() || queryCondition.getFields().isEmpty()) {
            return false;
        }
        templateParams.put("isSelectCondition", true);
        DataSet dataSet = backCtx.getUseDataModelBase().getDataSetById(queryCondition.getFromDataSet());
        if (isLogicallyDelete) {
            QueryConditionUtil.addLogicallyFlag(queryCondition, deleteField.getName(), msDataModel.getMasterTable().getId());
        }
        MysqlQueryDTO queryDTO = MysqlDataModelUtil.getQueryDto(dataSet, dataModelBaseDTO);
        if (HussarUtils.isNotEmpty((Object)templateParams.get("securityLevel"))) {
            MysqlDataModelFieldDto fieldDto = (MysqlDataModelFieldDto)templateParams.get("securityLevel");
            MysqlQueryFieldDTO field = new MysqlQueryFieldDTO();
            field.setPropertyName(fieldDto.getPropertyName());
            field.setDbColumnType(fieldDto.getColumnType());
            field.setType(fieldDto.getType());
            field.setComment(fieldDto.getComment());
            queryDTO.getQueryFields().add(field);
        }
        dataModelBaseDTO.addQueryDto(queryDTO);
        String finalWhereSql = QueryConditionUtil.renderQueryCon(queryCondition.getFields(), queryDTO, queryDTO.getQueryFields(), false, ConnectEnum._AND.getType(), inValuesSql, dataModelBaseDTO, aliasMap, backCtx.getUseDataModelBase(), deleteField == null ? "" : deleteField.getSourceFieldName());
        if (isLogicallyDelete) {
            QueryConditionUtil.deleteLogicallyFlag(queryCondition);
        }
        templateParams.put("whereSql", finalWhereSql);
        templateParams.put("QueryObj", queryDTO.getEntityName());
        templateParams.put("queryObj", queryDTO.getName());
        String importInfo = queryDTO.getImportInfo();
        backCtx.addControllerImport(modelId, importInfo);
        backCtx.addServiceImport(modelId, importInfo);
        backCtx.addServiceImplImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, importInfo);
        backCtx.addMapperImport(modelId, "org.apache.ibatis.annotations.Param");
        return true;
    }

    private boolean renderSort(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, MysqlDataModelOperation dataModelOperation, String modelId, Map<String, Object> controllerParams, MysqlFlowMsDataModel useDataModelBase, boolean isPagination) throws LcdpException {
        MysqlSortCondition sortCondition;
        String sortConditionName = String.valueOf(dataModelOperation.getParams().get("sortCondition"));
        if (StringUtil.isNotBlank((CharSequence)sortConditionName) && Optional.ofNullable(sortCondition = useDataModelBase.getSortConBaseByName(sortConditionName)).map(MysqlSortCondition::getFields).isPresent() && !sortCondition.getFields().isEmpty()) {
            if (!isPagination) {
                List<MysqlSortConditionField> sortConditionFields = sortCondition.getFields();
                for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldNameWithOutSortOverAll(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            } else {
                List<MysqlSortConditionField> sortConditionFields = sortCondition.getFields();
                for (MysqlSortConditionField sortConditionField : sortConditionFields) {
                    sortConditionField.replaceFieldName(useDataModelBase.getMasterTable(), useDataModelBase.getSlaveTables());
                }
            }
            controllerParams.put("sortConditionObj", sortCondition);
            controllerParams.put("isSortCondition", true);
            backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.QueryWrapper");
            return true;
        }
        return false;
    }

    private void renderPageVo(MysqlBackCtx<MysqlFlowMsDataModel, MysqlFlowMsDataModelDTO> backCtx, String modelId, MysqlFlowMsDataModelDTO dataModelBaseDTO, Map<String, Object> controllerParams) {
        MysqlDataModelUtil.addQueryPageVo(dataModelBaseDTO);
        String voEntityName = dataModelBaseDTO.getEntityName() + MysqlDataModelUtil.PAGE_VO;
        String voImportPath = dataModelBaseDTO.getPackageInfo().get("VO") + "." + voEntityName;
        controllerParams.put("vo", voEntityName);
        backCtx.addControllerImport(modelId, voImportPath);
        backCtx.addServiceImport(modelId, voImportPath);
        backCtx.addServiceImplImport(modelId, voImportPath);
    }

    private String getInValuesSql(MysqlMsDataModel useDataModelBase, MysqlDataModelOperation dataModelOperation, Map<String, String> aliasMap, String selectConditionName) {
        MysqlDataModelField realFieldBase;
        String template = "<if test=\"inValues != null and inValues.size > 0\">\n ${T_ALIAS}.${REAL_FIELD} in\n    <foreach collection=\"inValues\" item=\"item\" open=\"(\" separator=\",\" close=\")\">\n        #{item}\n    </foreach>\n</if>\n";
        String entityAttr = (String)dataModelOperation.getParams().get("relateField");
        if (ToolUtil.isNotEmpty((Object)entityAttr) && ToolUtil.isNotEmpty((Object)((Object)(realFieldBase = useDataModelBase.getFields().stream().filter(field -> entityAttr.equals(field.getName())).findAny().orElseGet(MysqlDataModelField::new))))) {
            String alias = aliasMap.get(realFieldBase.getSourceDataModelId());
            String sourceFieldName = realFieldBase.getSourceFieldName();
            if (useDataModelBase.isLogicallyDelete() && !StringUtil.isNotBlank((CharSequence)selectConditionName)) {
                String logicallyFlag = useDataModelBase.getModelAliasName().get(useDataModelBase.getMasterTable().getId()) + "." + useDataModelBase.getDeleteFlag().getSourceFieldName();
                template = template + "AND (" + logicallyFlag + " != '1' or " + logicallyFlag + " IS NULL)";
            }
            return template.replace("${T_ALIAS}", alias).replace("${REAL_FIELD}", sourceFieldName);
        }
        return "";
    }
}

