/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.mysql.function.render;

import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.NamingStrategy;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.common.util.PrefixUtil;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.mysql.code.MysqlCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ApiGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.AspectGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ControllerGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.EntityGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.MapperGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.ServiceImplGenerateInfo;
import com.jxdinfo.hussar.formdesign.mysql.code.info.VoGeneratorInfo;
import com.jxdinfo.hussar.formdesign.mysql.ctx.MysqlBackCtx;
import com.jxdinfo.hussar.formdesign.mysql.function.MysqlRender;
import com.jxdinfo.hussar.formdesign.mysql.function.element.view.MysqlViewDataModel;
import com.jxdinfo.hussar.formdesign.mysql.function.element.view.MysqlViewDataModelDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.mysql.function.model.MysqlQueryDTO;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlBackRenderUtil;
import com.jxdinfo.hussar.formdesign.mysql.util.MysqlDataSourceUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="MYSQLVIEWRENDER")
public class MysqlViewRender
implements MysqlRender<MysqlViewDataModel, MysqlViewDataModelDTO> {
    private static final Logger logger = LoggerFactory.getLogger(MysqlViewRender.class);
    public static final String RENDER = "MYSQLVIEWRENDER";

    @Override
    public List<MysqlCodeGenerateInfo> renderCode(MysqlBackCtx<MysqlViewDataModel, MysqlViewDataModelDTO> backCtx) throws LcdpException, IOException {
        logger.info("\u5904\u7406\u4ee3\u7801\u6e32\u67d3\uff0capi\u4ee5\u53ca\u540e\u7aef\u6240\u6709\u4ee3\u7801");
        ArrayList<MysqlCodeGenerateInfo> mysqlCodeGenerateInfos = new ArrayList<MysqlCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        BaseFile baseFile = backCtx.getBaseFile();
        MysqlViewDataModelDTO mysqlDataModelViewDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        mysqlCodeGenerateInfos.add(this.genEntityCode(mysqlDataModelViewDTO));
        mysqlCodeGenerateInfos.add(this.genVoCode(mysqlDataModelViewDTO));
        mysqlCodeGenerateInfos.add(this.genControllerCode(mysqlDataModelViewDTO));
        mysqlCodeGenerateInfos.add(this.genServiceCode(mysqlDataModelViewDTO));
        mysqlCodeGenerateInfos.add(this.genServiceImplCode(mysqlDataModelViewDTO));
        mysqlCodeGenerateInfos.add(this.genMapperCode(mysqlDataModelViewDTO));
        mysqlCodeGenerateInfos.add(this.genXmlCode(mysqlDataModelViewDTO));
        mysqlCodeGenerateInfos.add(this.genApiCode(mysqlDataModelViewDTO, baseFile));
        Map<String, MysqlQueryDTO> queryDtoMap = mysqlDataModelViewDTO.getQueryDtoMap();
        if (ToolUtil.isNotEmpty(queryDtoMap)) {
            for (Map.Entry<String, MysqlQueryDTO> queryDTOEntry : queryDtoMap.entrySet()) {
                MysqlQueryDTO queryDTO = queryDTOEntry.getValue();
                MysqlCodeGenerateInfo queryCodeGenerateInfo = this.dynamicModelCode(queryDTO, mysqlDataModelViewDTO);
                if (null == queryCodeGenerateInfo) continue;
                mysqlCodeGenerateInfos.add(queryCodeGenerateInfo);
            }
        }
        Map<String, AspectGenerateInfo> aspectGenerateInfoMap = mysqlDataModelViewDTO.getAspectGenerateInfoMap();
        if (ToolUtil.isNotEmpty(mysqlDataModelViewDTO.getAnnotationNames()) && ToolUtil.isNotEmpty(aspectGenerateInfoMap)) {
            for (String annotationName : mysqlDataModelViewDTO.getAnnotationNames()) {
                mysqlCodeGenerateInfos.add(this.genAnnotationCode(mysqlDataModelViewDTO, annotationName));
                AspectGenerateInfo aspectGenerateInfo = Optional.ofNullable(aspectGenerateInfoMap.get(aspectGenerateInfoMap.keySet().stream().filter(key -> HussarUtils.equals((Object)key, (Object)annotationName)).findFirst().orElse(""))).orElseGet(AspectGenerateInfo::new);
                mysqlCodeGenerateInfos.add(this.genAspectCode(mysqlDataModelViewDTO, annotationName, aspectGenerateInfo));
            }
        }
        return mysqlCodeGenerateInfos;
    }

    private MysqlCodeGenerateInfo genEntityCode(MysqlViewDataModelDTO dataModelViewDTO) throws LcdpException {
        String modulePath = dataModelViewDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "model" + File.separator + dataModelViewDTO.getEntityName() + ".java";
        String filePath = "/template/backcode/code/entity.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelViewDTO.getEntityName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelViewDTO.getEntityGenerateInfo())) {
            EntityGenerateInfo entityGenerateInfo = new EntityGenerateInfo();
            entityGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelViewDTO.setEntityGenerateInfo(entityGenerateInfo);
        } else {
            dataModelViewDTO.getEntityGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelViewDTO);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("entity");
        codeGenerateInfo.setFileId(dataModelViewDTO.getId());
        codeGenerateInfo.setFileName(dataModelViewDTO.getEntityName() + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genVoCode(MysqlViewDataModelDTO dataModelBaseDTO) throws LcdpException {
        String modulePath = dataModelBaseDTO.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "VO".toLowerCase() + File.separator + dataModelBaseDTO.getVoName() + ".java";
        String filePath = "template/backcode/code/vo.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelBaseDTO.getVoName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelBaseDTO.getVoGeneratorInfo())) {
            VoGeneratorInfo info = new VoGeneratorInfo();
            info.setQualifyBeanName(qualifyBeanName);
            dataModelBaseDTO.setVoGeneratorInfo(info);
        } else {
            dataModelBaseDTO.getVoGeneratorInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelBaseDTO);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("queryEntity");
        codeGenerateInfo.setFileId(dataModelBaseDTO.getId());
        codeGenerateInfo.setFileName(dataModelBaseDTO.getVoName() + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genControllerCode(MysqlViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Controller".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Controller" + ".java";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getControllerName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getControllerGenerateInfo())) {
            ControllerGenerateInfo controllerGenerateInfo = new ControllerGenerateInfo();
            controllerGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setControllerGenerateInfo(controllerGenerateInfo);
        } else {
            dataModelDto.getControllerGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String filePath = "/template/backcode/code/controller.ftl";
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(PrefixUtil.replacePrefix((String)newCode));
        codeGenerateInfo.setFileType("controller");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getControllerName() + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genServiceCode(MysqlViewDataModelDTO dataModelDto) throws LcdpException, IOException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + dataModelDto.getEntityName() + "Service" + ".java";
        String filePath = "/template/backcode/code/service.ftl";
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("service");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Service" + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genServiceImplCode(MysqlViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "Service".toLowerCase() + File.separator + "impl" + File.separator + dataModelDto.getEntityName() + "ServiceImpl" + ".java";
        String filePath = "/template/backcode/code/service_impl.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getServiceImplName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getServiceImplGenerateInfo())) {
            ServiceImplGenerateInfo serviceImplGenerateInfo = new ServiceImplGenerateInfo();
            serviceImplGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setServiceImplGenerateInfo(serviceImplGenerateInfo);
        } else {
            dataModelDto.getServiceImplGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        Set imports = Optional.ofNullable(dataModelDto.getServiceImplGenerateInfo().getImports()).orElseGet(HashSet::new);
        imports.add(MysqlDataSourceUtil.getDataSourceServiceImpl(dataModelDto.getDataSourceName()));
        imports.add("java.util.List");
        imports.add("java.util.Map");
        imports.add("com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
        imports.add("com.jxdinfo.hussar.platform.core.utils.BeanUtil");
        dataModelDto.getServiceImplGenerateInfo().setImports(imports);
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("serviceImpl");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "ServiceImpl" + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genMapperCode(MysqlViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".java";
        String filePath = "/template/backcode/code/mapper.ftl";
        String qualifyBeanName = DataModelUtil.getQualifyBeanName((String)dataModelDto.getMapperName(), (String)modulePath);
        if (ToolUtil.isEmpty((Object)dataModelDto.getMapperGenerateInfo())) {
            MapperGenerateInfo mapperGenerateInfo = new MapperGenerateInfo();
            mapperGenerateInfo.setQualifyBeanName(qualifyBeanName);
            dataModelDto.setMapperGenerateInfo(mapperGenerateInfo);
        } else {
            dataModelDto.getMapperGenerateInfo().setQualifyBeanName(qualifyBeanName);
        }
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("mapper");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".java");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genXmlCode(MysqlViewDataModelDTO dataModelDto) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "dao" + File.separator + "mapping" + File.separator + dataModelDto.getEntityName() + "Mapper" + ".xml";
        String filePath = "/template/backcode/code/xml.ftl";
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("xml");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getEntityName() + "Mapper" + ".xml");
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo dynamicModelCode(MysqlQueryDTO queryDTO, MysqlDataModelBaseDTO dataModelDto) throws LcdpException {
        if (ToolUtil.isNotEmpty((Object)queryDTO)) {
            String writePath = queryDTO.getWriteFilePath();
            String filePath = queryDTO.getFtlPath();
            String newCode = RenderUtil.renderTemplate((String)filePath, queryDTO.getParams());
            MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
            codeGenerateInfo.setFileWriteRelativePath(writePath);
            codeGenerateInfo.setFileContent(newCode);
            codeGenerateInfo.setFileType("queryEntity");
            codeGenerateInfo.setFileName(queryDTO.getEntityName());
            codeGenerateInfo.setFileId(dataModelDto.getId());
            return codeGenerateInfo;
        }
        return null;
    }

    private MysqlCodeGenerateInfo genAnnotationCode(MysqlViewDataModelDTO dataModelDto, String annotationName) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "annotation" + File.separator + annotationName + ".java";
        String filePath = "/template/backcode/code/annotation.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("annotation");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(annotationName);
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genApiCode(MysqlViewDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "template/preview/api/api-${pageType}-file.ftl".replace("${pageType}", ToolUtil.isNotEmpty((Object)baseFile) ? baseFile.getType() : "WebPage");
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(dataModelDto.getName().toLowerCase() + ".js");
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genPreviewApiCode(MysqlViewDataModelDTO dataModelDto, BaseFile baseFile) throws LcdpException {
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + ".js";
        String filePath = "/template/preview/api/api-file.ftl";
        String newCode = MysqlBackRenderUtil.renderTemplate(filePath, dataModelDto);
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("js");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        if (ToolUtil.isNotEmpty((Object)baseFile) && ToolUtil.isNotEmpty((Object)baseFile.getType())) {
            codeGenerateInfo.setPageType(baseFile.getType());
        }
        return codeGenerateInfo;
    }

    private MysqlCodeGenerateInfo genAspectCode(MysqlViewDataModelDTO dataModelDto, String annotationName, AspectGenerateInfo aspectGenerateInfo) throws LcdpException {
        String aspectName = annotationName + NamingStrategy.capitalFirst((String)"aspect");
        String modulePath = dataModelDto.getTablePath().toLowerCase();
        String writePath = modulePath + File.separator + "aop" + File.separator + "aspect" + File.separator + aspectName + ".java";
        String filePath = "/template/backcode/code/aspect.ftl";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("aspectName", aspectName);
        params.put("annotationName", annotationName);
        params.put("table", dataModelDto);
        params.put("aspect", aspectGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(filePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        String newCode = "";
        if (renderResult.isStatus()) {
            newCode = renderResult.getRenderString();
        }
        MysqlCodeGenerateInfo codeGenerateInfo = new MysqlCodeGenerateInfo();
        codeGenerateInfo.setFileWriteRelativePath(writePath);
        codeGenerateInfo.setFileContent(newCode);
        codeGenerateInfo.setFileType("aspect");
        codeGenerateInfo.setFileId(dataModelDto.getId());
        codeGenerateInfo.setFileName(aspectName);
        return codeGenerateInfo;
    }

    public static String renderTemplate(String templatePath, ApiGenerateInfo apiGenerateInfo) throws LcdpException {
        HashMap<String, ApiGenerateInfo> params = new HashMap<String, ApiGenerateInfo>();
        params.put("api", apiGenerateInfo);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }
}

