/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionConfig;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionMethodInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionSlaveTableInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class RuntimeYamlOperator {
    public static <T> T readYaml(String filePath, Class<T> valueType) throws IOException {
        File configFile = new File(filePath);
        TableExpansionConfig emptyConfig = new TableExpansionConfig();
        emptyConfig.setTableExpansionColumnInfo(new LinkedHashMap<String, List<TableExpansionInfo>>());
        emptyConfig.setTableExpansionMethodInfos(new LinkedHashMap<String, List<TableExpansionMethodInfo>>());
        emptyConfig.setTableExpansionSlaveTableInfos(new LinkedHashMap<String, List<TableExpansionSlaveTableInfo>>());
        if (!configFile.exists()) {
            if (valueType.isAssignableFrom(emptyConfig.getClass())) {
                return valueType.cast(emptyConfig);
            }
            throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u7a7a\u914d\u7f6e\u8f6c\u6362\u4e3a\u6307\u5b9a\u7684\u7c7b\u578b: " + valueType.getName());
        }
        try {
            ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            return (T)yamlMapper.readValue(new File(filePath), valueType);
        }
        catch (MismatchedInputException e) {
            if (valueType.isAssignableFrom(emptyConfig.getClass())) {
                return valueType.cast(emptyConfig);
            }
            throw new IllegalArgumentException("\u65e0\u6cd5\u5c06\u7a7a\u914d\u7f6e\u8f6c\u6362\u4e3a\u6307\u5b9a\u7684\u7c7b\u578b: " + valueType.getName());
        }
    }

    public static void writeYaml(String filePath, Object data) throws IOException {
        File configFile = new File(filePath);
        configFile.getParentFile().mkdirs();
        YAMLFactory yamlFactory = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)yamlFactory);
        yamlMapper.writeValue(new File(filePath), data);
    }

    public void updateYamlConfig(String filePath, TableExpansionConfig config) throws IOException {
        Map<String, List<TableExpansionSlaveTableInfo>> tableExpansionSlaveTableInfos;
        Map<String, List<TableExpansionMethodInfo>> tableExpansionMethodInfos;
        TableExpansionConfig currentFile = RuntimeYamlOperator.readYaml(filePath, TableExpansionConfig.class);
        Map<String, List<TableExpansionInfo>> configMap = currentFile.getTableExpansionColumnInfo();
        Map<String, List<TableExpansionMethodInfo>> methodInfoMap = currentFile.getTableExpansionMethodInfos();
        Map<String, List<TableExpansionSlaveTableInfo>> slaveTableInfoMap = currentFile.getTableExpansionSlaveTableInfos();
        Map<String, List<TableExpansionInfo>> tableExpansionColumnInfo = config.getTableExpansionColumnInfo();
        if (HussarUtils.isNotEmpty(tableExpansionColumnInfo)) {
            Iterator<Map.Entry<String, List<TableExpansionInfo>>> iterator = tableExpansionColumnInfo.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<TableExpansionInfo>> entry = iterator.next();
                List<TableExpansionInfo> tableExpansionInfoList = entry.getValue();
                if (!HussarUtils.isEmpty(tableExpansionInfoList)) continue;
                iterator.remove();
                if (!HussarUtils.isNotEmpty(configMap)) continue;
                configMap.remove(entry.getKey());
            }
            if (HussarUtils.isNotEmpty(tableExpansionColumnInfo)) {
                configMap.putAll(tableExpansionColumnInfo);
            }
        }
        if (HussarUtils.isNotEmpty(tableExpansionMethodInfos = config.getTableExpansionMethodInfos())) {
            Iterator<Map.Entry<String, List<TableExpansionMethodInfo>>> iterator = tableExpansionMethodInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<TableExpansionMethodInfo>> entry = iterator.next();
                List<TableExpansionMethodInfo> methodInfos = entry.getValue();
                if (!HussarUtils.isEmpty(methodInfos)) continue;
                iterator.remove();
                if (!HussarUtils.isNotEmpty(methodInfoMap)) continue;
                methodInfoMap.remove(entry.getKey());
            }
            if (HussarUtils.isNotEmpty(tableExpansionMethodInfos)) {
                methodInfoMap.putAll(tableExpansionMethodInfos);
            }
        }
        if (HussarUtils.isNotEmpty(tableExpansionSlaveTableInfos = config.getTableExpansionSlaveTableInfos())) {
            Iterator<Map.Entry<String, List<TableExpansionSlaveTableInfo>>> iterator = tableExpansionSlaveTableInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<TableExpansionSlaveTableInfo>> entry = iterator.next();
                List<TableExpansionSlaveTableInfo> slaveTableInfos = entry.getValue();
                if (!HussarUtils.isEmpty(slaveTableInfos)) continue;
                iterator.remove();
                if (!HussarUtils.isNotEmpty(slaveTableInfoMap)) continue;
                slaveTableInfoMap.remove(entry.getKey());
            }
            if (HussarUtils.isNotEmpty(tableExpansionSlaveTableInfos)) {
                slaveTableInfoMap.putAll(tableExpansionSlaveTableInfos);
            }
        }
        RuntimeYamlOperator.writeYaml(filePath, currentFile);
    }
}

