/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.function.enclosure;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.app.FormDesignAppInfo;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ModelStrategyFactory;
import com.jxdinfo.hussar.formdesign.back.processor.ModelStrategy;
import com.jxdinfo.hussar.formdesign.common.constant.StrategyType;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.ext.function.ExtEnclosure;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModel;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.ExcludePositionType;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionColumnInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.field.ExtDataModelField;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.operation.ExtDataModelOperation;
import com.jxdinfo.hussar.formdesign.ext.result.ExtCodeResult;
import com.jxdinfo.hussar.formdesign.ext.util.ExtColumnTypeConvertUtil;
import com.jxdinfo.hussar.formdesign.ext.util.ExtMethodInfoUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.expansion.core.enums.ExpansionPositionTypeEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component(value="EXT.BASE.ENCLOSURE")
public class ExtBaseEnclosure
implements ExtEnclosure {
    public static final String ENCLOSURE = "EXT.BASE.ENCLOSURE";
    public static final String MODEL_NAME = "name";
    public static final String MODEL_OPERATIONS = "operations";
    public static final String MODEL_PATH = "modelPath";
    public static final String QUERY_CONDITIONS = "queryConditions";
    public static final String QUERY_OBJECT = "queryObject";
    public static final String SORT_CONDITIONS = "sortCondition";
    public static final String DATASET = "dataSets";
    public static final String FIELDS = "fields";
    public static final String ID = "id";
    public static final String FUNCTION_TYPE = "functionType";
    public static final String EXTDB_METHOD = "serialNumber";

    @Override
    public ExtBaseDataModelDTO enclosure(PublishCtx<ExtCodeResult> publishCtx, ExtBaseDataModel dataModelBase) throws CloneNotSupportedException, LcdpException, IOException {
        ExtBaseDataModelDTO extBaseDataModelDTO = this.enclosureYml(publishCtx, dataModelBase);
        String sourceId = dataModelBase.getSourceId();
        JSONObject dataModel = DataModelUtil.getDataModelJson((String)sourceId);
        this.addBasic(dataModel, dataModelBase);
        this.enclosureSerialNumber(dataModel, dataModelBase, extBaseDataModelDTO);
        this.publishAndMergeStandard(publishCtx, sourceId, dataModel);
        return extBaseDataModelDTO;
    }

    public void addBasic(JSONObject dataModel, ExtBaseDataModel dataModelBase) {
        dataModel.put(MODEL_PATH, (Object)dataModelBase.getModelPath());
        dataModel.put(MODEL_OPERATIONS, dataModelBase.getOperations());
        dataModel.put(QUERY_CONDITIONS, (Object)this.getMergeJsonArray(dataModel.getJSONArray(QUERY_CONDITIONS), dataModelBase.getQueryConditions()));
        dataModel.put(QUERY_OBJECT, (Object)dataModelBase.getQueryObject());
        dataModel.put(SORT_CONDITIONS, (Object)dataModelBase.getSortCondition());
        dataModel.put(DATASET, (Object)this.getMergeJsonArray(dataModel.getJSONArray(DATASET), JSON.parseArray((String)JSON.toJSONString((Object)dataModelBase.getDataSets()))));
        this.addFields(dataModel, dataModelBase);
    }

    public void addFields(JSONObject dataModel, ExtBaseDataModel dataModelBase) {
        List<ExtDataModelField> extDataModelFields;
        JSONArray fields = dataModel.getJSONArray(FIELDS);
        if (HussarUtils.isNotEmpty(dataModelBase.getExtFields()) && HussarUtils.isNotEmpty(extDataModelFields = dataModelBase.getExtFields().get(dataModel.getString(ID)))) {
            fields.addAll(extDataModelFields);
        }
        dataModel.put(FIELDS, (Object)fields);
    }

    public PublishCtx<CodeResult> reNewExtCtx(String sourceId, PublishCtx<ExtCodeResult> publishCtx) {
        PublishCtx context = new PublishCtx();
        if (publishCtx.getParams() != null) {
            context.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            context.setBaseFile(publishCtx.getBaseFile());
        } else {
            BaseFile baseFile = new BaseFile();
            baseFile.setId(sourceId);
            context.setBaseFile(baseFile);
        }
        if (publishCtx.getPublishDTO() != null) {
            context.setPublishDTO(publishCtx.getPublishDTO());
        }
        return context;
    }

    public void publishAndMergeStandard(PublishCtx<ExtCodeResult> publishCtx, String sourceId, JSONObject dataModel) throws LcdpException, IOException, CloneNotSupportedException {
        PublishCtx<CodeResult> context = this.reNewExtCtx(sourceId, publishCtx);
        context.addParam("fromExt", (Object)true);
        ModelStrategy strategy = ModelStrategyFactory.strategy((String)StrategyType.analyse());
        strategy.init(DataModelUtil.getDataSourceType((String)sourceId));
        strategy.processor().generateForExt(context, dataModel);
        strategy.clear();
        List genCodeResults = context.getGenCodeResults();
        ArrayList extCodeResults = new ArrayList();
        genCodeResults.forEach(codeResult -> {
            ExtCodeResult extCodeResult = new ExtCodeResult();
            BeanUtil.copyProperties((Object)codeResult, (Object)((Object)extCodeResult));
            extCodeResults.add(extCodeResult);
        });
        publishCtx.addCodeResults(extCodeResults);
    }

    public ExtBaseDataModelDTO enclosureYml(PublishCtx<ExtCodeResult> publishCtx, ExtBaseDataModel dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        ExtBaseDataModelDTO dataModelBaseDTO = new ExtBaseDataModelDTO();
        dataModelBaseDTO.setId(dataModelBase.getSourceId());
        dataModelBaseDTO.setName(dataModelBase.getName());
        String taskTablePah = dataModelBase.getModelPath() + "/" + String.format("%sTask", dataModelBase.getName());
        dataModelBaseDTO.setTablePath(taskTablePah);
        if (HussarUtils.isEmpty((Object)AppContextUtil.getStandardAppInfo())) {
            throw new RuntimeException("\u6269\u5c55\u6a21\u578b\u7ec4\u88c5\u53c2\u6570dto\u65f6\uff0c\u672a\u83b7\u53d6\u5230\u6807\u51c6\u5e94\u7528\uff01");
        }
        dataModelBaseDTO.setTableExpansionColumnInfo(this.tableExpansionInfos(dataModelBase, "", type -> true));
        dataModelBaseDTO.addAllExpansionColumnInfos(this.addTotalYml(dataModelBase));
        return dataModelBaseDTO;
    }

    @NotNull
    private static TableExpansionColumnInfo getTableExpansionColumnInfo(ExtDataModelField field, Object name, Object sourceDataModelName, String suffix) {
        TableExpansionColumnInfo expansionColumnInfo = new TableExpansionColumnInfo();
        expansionColumnInfo.setColumnName(field.getSourceFieldName());
        expansionColumnInfo.setModelName(String.valueOf(name));
        expansionColumnInfo.setPropertyName(field.getName());
        String positionType = HussarUtils.equals((Object)suffix, (Object)"Total") ? ExpansionPositionTypeEnum.SELECT_WHERE.getType() : ExpansionPositionTypeEnum.ALL.getType();
        expansionColumnInfo.setPositionType(positionType);
        expansionColumnInfo.setTableName(String.valueOf(sourceDataModelName));
        expansionColumnInfo.setColumnType(ExtColumnTypeConvertUtil.getColumnType(field.getSourceDataType()));
        expansionColumnInfo.setPropertyType(DataModelFieldTypeConvert.getDbColumnType((String)field.getDataType()).getlType());
        if (HussarUtils.isEmpty((Object)suffix)) {
            expansionColumnInfo.setExcludeInfos(ExtBaseEnclosure.dealExcludeInfos());
        }
        return expansionColumnInfo;
    }

    private static List<ExcludePositionType> dealExcludeInfos() {
        ArrayList<ExcludePositionType> excludeInfos = new ArrayList<ExcludePositionType>();
        ExcludePositionType updateExclude = new ExcludePositionType();
        updateExclude.setExcludePositionType("update_where");
        updateExclude.setExcludeMappersPattern(new ArrayList<String>());
        excludeInfos.add(updateExclude);
        ExcludePositionType selectExclude = new ExcludePositionType();
        selectExclude.setExcludePositionType("select_where");
        ArrayList<String> excludeMappersPattern = new ArrayList<String>();
        excludeMappersPattern.add("**.selectById");
        selectExclude.setExcludeMappersPattern(excludeMappersPattern);
        excludeInfos.add(selectExclude);
        return excludeInfos;
    }

    private void enclosureSerialNumber(JSONObject dataModel, ExtBaseDataModel extBaseDataModel, ExtBaseDataModelDTO extBaseDataModelDTO) throws LcdpException, IOException, CloneNotSupportedException {
        Map<String, List<ExtDataModelField>> extFields = extBaseDataModel.getExtFields();
        if (HussarUtils.isEmpty(extFields)) {
            return;
        }
        List<ExtDataModelField> masterFields = extFields.get(dataModel.getString(ID));
        if (HussarUtils.isEmpty(masterFields)) {
            return;
        }
        Optional<ExtDataModelField> serialFieldOpt = masterFields.stream().filter(m -> HussarUtils.equals((Object)EXTDB_METHOD, (Object)m.getUsage())).findFirst();
        if (!serialFieldOpt.isPresent()) {
            return;
        }
        JSONArray ops = dataModel.getJSONArray(MODEL_OPERATIONS);
        if (HussarUtils.isEmpty((Object)ops)) {
            dataModel.put(MODEL_OPERATIONS, Collections.singletonList(this.ofSerialNumber()));
        } else {
            ops.add((Object)this.ofSerialNumber());
            dataModel.put(MODEL_OPERATIONS, (Object)ops);
        }
        extBaseDataModelDTO.addTableExpansionMethodInfos(this.noTaskExpansionModelId(extBaseDataModel), ExtMethodInfoUtil.tableExpansionMethodInfo(dataModel, EXTDB_METHOD));
    }

    public String noTaskExpansionModelId(ExtBaseDataModel extBaseDataModel) {
        String appName = AppContextUtil.getStandardAppInfo().getEnglishName();
        String noTaskModePath = extBaseDataModel.getModelPath() + "/" + extBaseDataModel.getName();
        noTaskModePath = FileUtil.systemPath((String[])new String[]{noTaskModePath.replace("/", "").replace("\\", "").replace("//", "").replace("\\\\", "")});
        return appName + noTaskModePath;
    }

    public String taskExpansionModelId(String taskTablePah) {
        String appName = AppContextUtil.getStandardAppInfo().getEnglishName();
        String modulePath = FileUtil.systemPath((String[])new String[]{taskTablePah}).replace("/", "").replace("\\", "").replace("//", "").replace("\\\\", "");
        return appName + modulePath;
    }

    private ExtDataModelOperation ofSerialNumber() {
        ExtDataModelOperation operation = new ExtDataModelOperation();
        operation.setId(RandomUtil.randomString((int)36));
        operation.setName(EXTDB_METHOD);
        operation.setType("SerialNumber");
        return operation;
    }

    public String replaceStandard(String impl) {
        FormDesignAppInfo appInfo = AppContextUtil.getAppInfo();
        if (HussarUtils.isEmpty((Object)appInfo)) {
            throw new RuntimeException("\u5f53\u524d\u5e94\u7528\u83b7\u53d6\u5931\u8d25");
        }
        String tcode = AppContextUtil.asIdentifier((String)appInfo.getTenantCode());
        String appCode = AppContextUtil.asIdentifier((String)appInfo.getEnglishName());
        FormDesignAppInfo standardAppInfo = AppContextUtil.getStandardAppInfo();
        if (HussarUtils.isEmpty((Object)standardAppInfo)) {
            throw new RuntimeException("\u6807\u51c6\u5e94\u7528\u83b7\u53d6\u5931\u8d25");
        }
        String stTcode = AppContextUtil.asIdentifier((String)standardAppInfo.getTenantCode());
        String stAppCode = AppContextUtil.asIdentifier((String)standardAppInfo.getEnglishName());
        impl = impl.replaceAll(tcode, stTcode).replaceAll(appCode, stAppCode);
        return impl;
    }

    public Map<String, List<TableExpansionInfo>> addTotalYml(ExtBaseDataModel dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        String sourceId = dataModelBase.getSourceId();
        JSONObject dataModel = DataModelUtil.getDataModelJson((String)sourceId);
        JSONArray ops = dataModel.getJSONArray(MODEL_OPERATIONS);
        if (HussarUtils.isNotEmpty((Object)ops)) {
            if (ops.stream().noneMatch(o -> HussarUtils.equals((Object)"totalCalculate", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)o)).get((Object)MODEL_NAME)))) {
                return new HashMap<String, List<TableExpansionInfo>>();
            }
            return this.tableExpansionInfos(dataModelBase, "Total", type -> HussarUtils.equals((Object)"association", (Object)type) || HussarUtils.equals((Object)"master", (Object)type) || HussarUtils.equals((Object)"collection", (Object)type));
        }
        return new HashMap<String, List<TableExpansionInfo>>();
    }

    public Map<String, List<TableExpansionInfo>> tableExpansionInfos(ExtBaseDataModel dataModelBase, String suffix, Predicate<String> predicate) throws LcdpException, IOException, CloneNotSupportedException {
        String taskTablePah = dataModelBase.getModelPath() + "/" + String.format("%sTask", dataModelBase.getName());
        String expansionModelId = this.taskExpansionModelId(taskTablePah);
        String noTaskExpansionModelId = this.noTaskExpansionModelId(dataModelBase);
        Map<String, List<ExtDataModelField>> extFields = dataModelBase.getExtFields();
        String sourceId = dataModelBase.getSourceId();
        Map slaveModelInfos = ModelProvideAdapter.adaptor((String)sourceId).getSlaveModelInfos(sourceId);
        Map alias = ModelProvideAdapter.adaptor((String)sourceId).getModelAliasName(sourceId);
        HashMap<String, List<TableExpansionInfo>> tableExpansionInfos = new HashMap<String, List<TableExpansionInfo>>();
        for (String key : alias.keySet()) {
            Map modelAliasName = (Map)alias.get(key);
            if (HussarUtils.equals((Object)suffix, (Object)"Total") && alias.containsKey("task") && HussarUtils.equals((Object)"noTask", (Object)key)) continue;
            ArrayList tableExpansionInfoList = new ArrayList();
            if (HussarUtils.isNotEmpty(extFields)) {
                extFields.forEach((modelId, fields) -> {
                    TableExpansionInfo tableExpansionInfo = new TableExpansionInfo();
                    slaveModelInfos.forEach((k, v) -> {
                        if (k.equals(modelId) && predicate.test(String.valueOf(v.get("type")))) {
                            Object name = v.get(MODEL_NAME);
                            Object sourceDataModelName = v.get("sourceDataModelName");
                            if (HussarUtils.isEmpty(name) || HussarUtils.isEmpty(sourceDataModelName)) {
                                throw new RuntimeException("\u6269\u5c55\u6a21\u578b\u53d1\u5e03\uff0c\u6784\u9020\u6269\u5c55\u5b57\u6bb5\u4fe1\u606f\u65f6\uff0c\u672a\u5339\u914d\u5230\u4e3b\u8868\u6216\u5b50\u8868\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u4e2d\u95f4\u6587\u4ef6");
                            }
                            tableExpansionInfo.setTableName(String.valueOf(sourceDataModelName));
                            tableExpansionInfo.setModelName(String.valueOf(name));
                            tableExpansionInfo.setAlias((String)modelAliasName.get(modelId));
                            tableExpansionInfo.setType(String.valueOf(v.get("type")));
                            ArrayList<TableExpansionColumnInfo> columnInfos = new ArrayList<TableExpansionColumnInfo>();
                            for (ExtDataModelField field : fields) {
                                columnInfos.add(ExtBaseEnclosure.getTableExpansionColumnInfo(field, name, sourceDataModelName, suffix));
                            }
                            tableExpansionInfo.setFields(columnInfos);
                        }
                    });
                    tableExpansionInfoList.add(tableExpansionInfo);
                });
            }
            String expansionKey = HussarUtils.equals((Object)"task", (Object)key) && !HussarUtils.equals((Object)suffix, (Object)"Total") ? String.format("%s_task", expansionModelId) : (dataModelBase.getFunctionType().equals("TASK_MASTER_SLAVE") ? String.format("%s_task%s", noTaskExpansionModelId, suffix) : String.format("%s%s", noTaskExpansionModelId, suffix));
            tableExpansionInfos.put(expansionKey, tableExpansionInfoList);
        }
        return tableExpansionInfos;
    }

    private JSONArray getMergeJsonArray(JSONArray jsonArray, JSONArray extJsonArray) {
        int i;
        jsonArray = HussarUtils.isNotEmpty((Object)jsonArray) ? jsonArray : new JSONArray();
        extJsonArray = HussarUtils.isNotEmpty((Object)extJsonArray) ? extJsonArray : new JSONArray();
        HashMap<String, Integer> nameIndexMap = new HashMap<String, Integer>();
        for (i = 0; i < jsonArray.size(); ++i) {
            String name = jsonArray.getJSONObject(i).getString(MODEL_NAME);
            if (!HussarUtils.isNotEmpty((Object)name)) continue;
            nameIndexMap.put(name, i);
        }
        for (i = 0; i < extJsonArray.size(); ++i) {
            JSONObject extObj = extJsonArray.getJSONObject(i);
            String extName = extObj.getString(MODEL_NAME);
            if (!HussarUtils.isNotEmpty((Object)extName)) continue;
            if (nameIndexMap.containsKey(extName)) {
                int index = (Integer)nameIndexMap.get(extName);
                jsonArray.set(index, (Object)extObj);
                continue;
            }
            jsonArray.add((Object)extObj);
        }
        return jsonArray;
    }
}

