/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.util;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.ExtDataModelBaseDTO;
import java.util.HashMap;
import java.util.Optional;

public class ExtBackRenderUtil {
    public static final String DATASOURCE_ANNOTATION = "dataSourceAnnotation";

    public static String renderTemplate(String templatePath, ExtDataModelBaseDTO dataModelDto) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("table", dataModelDto);
        params.put(DATASOURCE_ANNOTATION, ExtBackRenderUtil.getServiceImplDataSourceAnnotation(dataModelDto.getDataSourceName()));
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(templatePath);
        renderCore.registerParam(params);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            String renderString = renderResult.getRenderString();
            return CodeSplitUtil.removeEmptyLines((String)renderString);
        }
        return "";
    }

    public static String getDefaultDataSourceName() {
        return Optional.ofNullable(((DynamicDataSourceProperties)SpringUtil.getBean(DynamicDataSourceProperties.class)).getPrimary()).orElse("");
    }

    public static String getMethodDataSourceAnnotation() {
        return "@HussarTokenDs";
    }

    public static String getServiceImplDataSourceAnnotation(String dataSourceName) {
        if (ExtBackRenderUtil.getDefaultDataSourceName().equals(dataSourceName)) {
            return "@HussarTokenDs";
        }
        return "@HussarDs(\"" + dataSourceName + "\")";
    }

    public static String getDataSourceServiceImpl(String dataSourceName) {
        if (ExtBackRenderUtil.getDefaultDataSourceName().equals(dataSourceName)) {
            return "com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs";
        }
        return "com.jxdinfo.hussar.support.datasource.annotations.HussarDs";
    }
}

