/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.processor;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.factory.ProcessorFactory;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.back.processor.DataModelProcessor;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.ext.code.ExtCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.ext.ctx.ExtBackCtx;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModel;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.ext.function.render.ExtBaseRender;
import com.jxdinfo.hussar.formdesign.ext.result.ExtCodeResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class ExtModelProcessor
implements DataModelProcessor<ExtCodeResult> {
    public static final String TYPE = "dbExtension";

    @PostConstruct
    public void register() {
        ProcessorFactory.register((String)TYPE, (String)ToolUtil.firstToLower((String)this.getClass().getSimpleName()));
    }

    public void generate(PublishCtx<ExtCodeResult> publishCtx, DataModelBase dataModelBase) throws LcdpException, IOException, CloneNotSupportedException {
        ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO> backCtx = this.getExtBackCtx(publishCtx);
        ExtModelProcessor.init(publishCtx, backCtx, dataModelBase);
        ExtModelProcessor.render(backCtx, publishCtx);
        publishCtx.setPublishDTO(backCtx.getPublishDTO());
    }

    private ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO> getExtBackCtx(PublishCtx<ExtCodeResult> publishCtx) {
        ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO> backCtx = new ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO>();
        if (publishCtx.getParams() != null) {
            backCtx.addParams(publishCtx.getParams());
        }
        if (publishCtx.getBaseFile() != null) {
            backCtx.setBaseFile(publishCtx.getBaseFile());
        }
        if (publishCtx.getPublishDTO() != null) {
            backCtx.setPublishDTO(publishCtx.getPublishDTO());
        }
        return backCtx;
    }

    public static void init(PublishCtx<ExtCodeResult> publishCtx, ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO> backCtx, DataModelBase dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        String modelId = dataModelBase.getId();
        JSONObject dataModelJsonExt = DataModelUtil.getDataModelJsonExt((String)modelId);
        ExtBaseDataModel extBaseDataModel = new ExtBaseDataModel().parseDataModel(dataModelJsonExt);
        backCtx.setUseDataModelBase(extBaseDataModel);
        HashMap<String, ExtBaseDataModelDTO> useDtoMap = new HashMap<String, ExtBaseDataModelDTO>();
        useDtoMap.put(modelId, extBaseDataModel.enclosure().enclosure(publishCtx, extBaseDataModel));
        backCtx.setUseDataModelDtoMap(useDtoMap);
        backCtx.setModelFunctionTye(extBaseDataModel.getFunctionType());
    }

    public static void render(ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO> backCtx, PublishCtx<ExtCodeResult> publishCtx) throws LcdpException, IOException, CloneNotSupportedException {
        List<ExtCodeGenerateInfo> codeGenerateInfos = new ExtBaseRender().renderCode(backCtx);
        if (HussarUtils.isNotEmpty((Object)backCtx.getParams())) {
            backCtx.getParams().keySet().forEach(key -> {
                if (ToolUtil.isEmpty((Object)publishCtx.getParams())) {
                    publishCtx.addParams(new HashMap());
                }
                publishCtx.getParams().putIfAbsent(key, backCtx.getParam((String)key));
            });
        }
    }
}

