/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.function.render;

import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.ext.code.ExtCodeGenerateInfo;
import com.jxdinfo.hussar.formdesign.ext.ctx.ExtBackCtx;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModel;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionConfig;
import com.jxdinfo.hussar.formdesign.ext.service.RuntimeYamlOperator;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExtBaseRender {
    public List<ExtCodeGenerateInfo> renderCode(ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        ArrayList<ExtCodeGenerateInfo> extCodeGenerateInfos = new ArrayList<ExtCodeGenerateInfo>();
        String modelId = backCtx.getUseDataModelBase().getId();
        ExtBaseDataModelDTO dataModelBaseDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        this.writeExpansionColumns(dataModelBaseDTO, backCtx);
        return extCodeGenerateInfos;
    }

    private void writeExpansionColumns(ExtBaseDataModelDTO dataModelBaseDTO, ExtBackCtx<ExtBaseDataModel, ExtBaseDataModelDTO> backCtx) throws LcdpException, IOException {
        if (HussarUtils.isEmpty((Object)AppContextUtil.getStandardAppInfo())) {
            return;
        }
        String fileDevPath = ((PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class)).javaPathService().backProject(new String[]{"src", "main", "resources", "expansion-columninfo-dev.yml"}).getLocalPath();
        String fileProdPath = ((PathStrategyService)SpringContextUtil.getBean(PathStrategyService.class)).javaPathService().backProject(new String[]{"src", "main", "resources", "expansion-columninfo-prod.yml"}).getLocalPath();
        RuntimeYamlOperator operator = (RuntimeYamlOperator)SpringContextUtil.getBean(RuntimeYamlOperator.class);
        TableExpansionConfig config = new TableExpansionConfig();
        HussarUtils.copy((Object)dataModelBaseDTO, (Object)config);
        operator.updateYamlConfig(fileDevPath, config);
        operator.updateYamlConfig(fileProdPath, config);
        backCtx.addParam("extPublish", true);
    }
}

