/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.function.enclosure;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.converts.DataModelFieldTypeConvert;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModel;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.ext.function.enclosure.ExtBaseEnclosure;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionMaster;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionSlaveColumnInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionSlaveTableInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.operation.ExtDataModelOperation;
import com.jxdinfo.hussar.formdesign.ext.result.ExtCodeResult;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.random.RandomUtil;
import com.jxdinfo.hussar.support.expansion.core.enums.ExpansionPositionTypeEnum;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="EXT.MASTER_SLAVE.ENCLOSURE")
public class ExtMsEnclosure
extends ExtBaseEnclosure {
    public static final String ENCLOSURE = "EXT.MASTER_SLAVE.ENCLOSURE";
    private static final String MODEL_OPERATIONS = "operations";
    private static final String MODEL_MASTER_TABLE = "masterTable";
    private static final String MODEL_SLAVE_TABLES = "slaveTables";
    private static final String MODEL_RELATIONSHIPS = "relationships";
    private static final String MODEL_PATH = "modelPath";
    private static final String MODEL_ISPUBLISHRESOURCE = "isPublishResource";
    private static final String MODEL_OPERATIONS_CONDITIONFILTER = "ConditionFilter";
    private static final String MODEL_OPERATIONS_HUSSARQUERY = "TableQuery";
    private static final String MODEL_OPERATIONS_TYPE = "type";
    public static final String FUNCTION_TYPE = "functionType";
    public static final List<String> MASTER_BASE_METHODS = Collections.singletonList("insertOrUpdatePlus");
    public static final List<String> MASTER_FLOW_TASK_METHODS = Collections.unmodifiableList(Arrays.asList("insertOrUpdatePlus", "flowFormSaveStartPlus", "flowFormSubmitPlus", "anyNodeRejectPlus"));

    @Override
    public ExtBaseDataModelDTO enclosure(PublishCtx<ExtCodeResult> publishCtx, ExtBaseDataModel dataModelBase) throws LcdpException, CloneNotSupportedException, IOException {
        ExtBaseDataModelDTO dataModelBaseDTO = super.enclosureYml(publishCtx, dataModelBase);
        String sourceId = dataModelBase.getSourceId();
        JSONObject dataModel = this.combined(publishCtx, dataModelBase, dataModelBaseDTO);
        super.publishAndMergeStandard(publishCtx, sourceId, dataModel);
        return dataModelBaseDTO;
    }

    public JSONObject combined(PublishCtx<ExtCodeResult> publishCtx, ExtBaseDataModel dataModelBase, ExtBaseDataModelDTO dataModelDTO) throws LcdpException, IOException, CloneNotSupportedException {
        JSONArray relationships;
        JSONObject slave;
        String sourceId = dataModelBase.getSourceId();
        JSONArray slaves = dataModelBase.getSlaveTables();
        JSONObject dataModel = DataModelUtil.getDataModelJson((String)sourceId);
        List<ExtDataModelOperation> cuntomOperationList = dataModelBase.assemblyModelOptions(dataModel, dataModelDTO);
        super.addBasic(dataModel, dataModelBase);
        this.enclosureExpansionSlaveTables(dataModel, dataModelBase, dataModelDTO, "");
        this.enclosureExpansionSlaveTablesTotal(dataModel, dataModelBase, dataModelDTO, "Total");
        JSONArray slaveTables = dataModel.getJSONArray(MODEL_SLAVE_TABLES);
        JSONObject masterTable = dataModel.getJSONObject(MODEL_MASTER_TABLE);
        if (HussarUtils.isNotEmpty((Object)masterTable)) {
            super.addFields(masterTable, dataModelBase);
        }
        JSONArray lastSlaveTables = new JSONArray();
        for (Object slaveTable : slaveTables) {
            slave = JSONObject.parseObject((String)JSON.toJSONString(slaveTable));
            super.addFields(slave, dataModelBase);
            lastSlaveTables.add((Object)slave);
        }
        dataModel.put(MODEL_MASTER_TABLE, (Object)masterTable);
        dataModel.put(MODEL_SLAVE_TABLES, (Object)lastSlaveTables);
        if (HussarUtils.isNotEmpty((Object)slaves)) {
            for (Object o : slaves) {
                slave = JSONObject.parseObject((String)JSON.toJSONString(o));
                JSONArray operations = slave.getJSONArray(MODEL_OPERATIONS);
                if (HussarUtils.isNotEmpty((Object)operations)) {
                    operations.add((Object)this.ofIncrement());
                } else {
                    operations = new JSONArray();
                    operations.add((Object)this.ofIncrement());
                }
                slave.put(MODEL_OPERATIONS, (Object)operations);
                slave.put(MODEL_ISPUBLISHRESOURCE, (Object)false);
            }
            lastSlaveTables.addAll((Collection)slaves);
            dataModel.put(MODEL_SLAVE_TABLES, (Object)lastSlaveTables);
        }
        if (HussarUtils.isNotEmpty((Object)(relationships = dataModelBase.getRelationships()))) {
            JSONArray standardRelations = dataModel.getJSONArray(MODEL_RELATIONSHIPS);
            standardRelations.addAll((Collection)JSONArray.parseArray((String)JSONArray.toJSONString((Object)relationships)));
            dataModel.put(MODEL_RELATIONSHIPS, (Object)standardRelations);
        }
        if (HussarUtils.isNotEmpty(cuntomOperationList)) {
            JSONArray opsArr = dataModel.getJSONArray(MODEL_OPERATIONS);
            if (HussarUtils.isNotEmpty((Object)opsArr)) {
                opsArr.addAll(cuntomOperationList);
                dataModel.put(MODEL_OPERATIONS, (Object)opsArr);
            } else {
                dataModel.put(MODEL_OPERATIONS, cuntomOperationList);
            }
        }
        return dataModel;
    }

    private void enclosureExpansionSlaveTablesTotal(JSONObject dataModel, ExtBaseDataModel dataModelBase, ExtBaseDataModelDTO dataModelDTO, String total) throws IOException, LcdpException, CloneNotSupportedException {
        JSONArray ops = dataModel.getJSONArray(MODEL_OPERATIONS);
        if (HussarUtils.isNotEmpty((Object)ops) && ops.stream().anyMatch(o -> HussarUtils.equals((Object)"totalCalculate", (Object)JSONObject.parseObject((String)JSON.toJSONString((Object)o)).get((Object)"name")))) {
            this.enclosureExpansionSlaveTables(dataModel, dataModelBase, dataModelDTO, total);
        }
    }

    private void exclude(JSONObject dataModel) {
        JSONArray operations = dataModel.getJSONArray(MODEL_OPERATIONS);
        if (HussarUtils.isEmpty((Object)operations)) {
            return;
        }
        JSONArray needOps = new JSONArray();
        for (Object operation : operations) {
            JSONObject op = JSONObject.parseObject((String)JSON.toJSONString(operation));
            String type = op.getString(MODEL_OPERATIONS_TYPE);
            if (!HussarUtils.equals((Object)type, (Object)MODEL_OPERATIONS_CONDITIONFILTER) && !HussarUtils.equals((Object)type, (Object)MODEL_OPERATIONS_HUSSARQUERY)) continue;
            needOps.add((Object)op);
        }
        dataModel.put(MODEL_OPERATIONS, (Object)needOps);
    }

    private ExtDataModelOperation ofIncrement() {
        ExtDataModelOperation operation = new ExtDataModelOperation();
        operation.setId(RandomUtil.randomString((int)36));
        operation.setName("slaveFormSave");
        operation.setType("SlaveFormSave");
        return operation;
    }

    private ExtDataModelOperation ofSerialNumber(JSONObject dataModel) {
        ExtDataModelOperation operation = new ExtDataModelOperation();
        operation.setId(RandomUtil.randomString((int)36));
        operation.setName("serialNumber");
        operation.setType("SerialNumber");
        HashMap<String, Object> params = new HashMap<String, Object>();
        JSONArray opsArr = dataModel.getJSONArray(MODEL_OPERATIONS);
        if (HussarUtils.isEmpty((Object)opsArr)) {
            params.put("isPlus", false);
            operation.setParams(params);
            return operation;
        }
        boolean anyMatch = opsArr.stream().anyMatch(o -> {
            ExtDataModelOperation op = (ExtDataModelOperation)JSONObject.parseObject((String)JSON.toJSONString((Object)o), ExtDataModelOperation.class);
            Map slaveTablePlusSave = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)op.getParams().get("slaveTablePlusSave")), (TypeReference)new TypeReference<Map<String, Boolean>>(){}, (Feature[])new Feature[0]);
            params.put("slaveTablePlusSave", slaveTablePlusSave);
            return ToolUtil.isNotEmpty((Object)slaveTablePlusSave) && slaveTablePlusSave.containsValue(Boolean.TRUE);
        });
        params.put("isPlus", anyMatch);
        operation.setParams(params);
        return operation;
    }

    private void enclosureExpansionSlaveTables(JSONObject dataModel, ExtBaseDataModel extBaseDataModel, ExtBaseDataModelDTO dataModelDTO, String suffix) throws LcdpException, IOException, CloneNotSupportedException {
        JSONArray slaveTables = extBaseDataModel.getSlaveTables();
        if (HussarUtils.isEmpty((Object)slaveTables)) {
            slaveTables = new JSONArray();
        }
        String sourceId = extBaseDataModel.getSourceId();
        Map alias = ModelProvideAdapter.adaptor((String)sourceId).getModelAliasName(sourceId);
        JSONObject masterTable = dataModel.getJSONObject(MODEL_MASTER_TABLE);
        for (String key : alias.keySet()) {
            if (HussarUtils.equals((Object)suffix, (Object)"Total") && alias.containsKey("task") && HussarUtils.equals((Object)"noTask", (Object)key)) continue;
            ArrayList<TableExpansionSlaveTableInfo> tableExpansionSlaveTableInfos = new ArrayList<TableExpansionSlaveTableInfo>();
            for (int i = 0; i < slaveTables.size(); ++i) {
                TableExpansionMaster masterTableInfo = this.dealMasterTable(masterTable, (Map)alias.get(key));
                JSONObject slaveTable = (JSONObject)slaveTables.get(i);
                String type = String.valueOf(slaveTable.get((Object)"relateModelType"));
                if (HussarUtils.equals((Object)type, (Object)"collection")) continue;
                String modelName = String.valueOf(slaveTable.get((Object)"name"));
                String tableName = String.valueOf(slaveTable.get((Object)"sourceDataModelName"));
                if (HussarUtils.isEmpty((Object)modelName) || HussarUtils.isEmpty((Object)tableName)) {
                    throw new RuntimeException("\u6269\u5c55\u6a21\u578b\u53d1\u5e03\uff0c\u6784\u9020\u6269\u5c55\u5b50\u8868\u4fe1\u606f\u65f6\uff0c\u672a\u5339\u914d\u5230\u6269\u5c55\u5b50\u8868\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u4e2d\u95f4\u6587\u4ef6");
                }
                masterTableInfo.setSlaveTableName(tableName);
                String slavaTableAlias = "E" + i;
                List<TableExpansionSlaveColumnInfo> fields = this.dealSlaveFields(slaveTable, tableName, modelName, masterTableInfo, suffix);
                TableExpansionSlaveTableInfo tableExpansionSlaveTableInfo = new TableExpansionSlaveTableInfo();
                tableExpansionSlaveTableInfo.setTableName(tableName);
                tableExpansionSlaveTableInfo.setAlias(slavaTableAlias);
                tableExpansionSlaveTableInfo.setFields(fields);
                tableExpansionSlaveTableInfo.setModelName(modelName);
                tableExpansionSlaveTableInfo.setType(type);
                tableExpansionSlaveTableInfo.setMasterTable(masterTableInfo);
                tableExpansionSlaveTableInfos.add(tableExpansionSlaveTableInfo);
            }
            String expansionKey = null;
            String expansionModelId = this.taskExpansionModelId(dataModelDTO.getTablePath());
            String noTaskModelId = this.noTaskExpansionModelId(extBaseDataModel);
            expansionKey = HussarUtils.equals((Object)"task", (Object)key) && !HussarUtils.equals((Object)suffix, (Object)"Total") ? String.format("%s_task", expansionModelId) : (extBaseDataModel.getFunctionType().equals("TASK_MASTER_SLAVE") ? String.format("%s_task%s", noTaskModelId, suffix) : String.format("%s%s", noTaskModelId, suffix));
            dataModelDTO.addAllTableExpansionSlaveTableInfos(expansionKey, tableExpansionSlaveTableInfos);
        }
    }

    private List<TableExpansionSlaveColumnInfo> dealSlaveFields(JSONObject slaveTable, String tableName, String modelName, TableExpansionMaster masterTableInfo, String suffix) {
        ArrayList<TableExpansionSlaveColumnInfo> fields = new ArrayList<TableExpansionSlaveColumnInfo>();
        slaveTable.getJSONArray("fields").forEach(item -> {
            JSONObject field = (JSONObject)item;
            String usage = field.getString("usage");
            if (HussarUtils.isEmpty((Object)usage)) {
                usage = "normal";
            }
            TableExpansionSlaveColumnInfo tableExpansionSlaveColumnInfo = new TableExpansionSlaveColumnInfo();
            tableExpansionSlaveColumnInfo.setTableName(tableName);
            tableExpansionSlaveColumnInfo.setModelName(modelName);
            tableExpansionSlaveColumnInfo.setColumnName(field.getString("sourceFieldName"));
            tableExpansionSlaveColumnInfo.setColumnType(field.getString("sourceDataType"));
            tableExpansionSlaveColumnInfo.setPropertyName(field.getString("name"));
            tableExpansionSlaveColumnInfo.setPropertyType(DataModelFieldTypeConvert.getDbColumnType((String)field.getString("dataType")).getlType());
            tableExpansionSlaveColumnInfo.setPositionType(HussarUtils.isEmpty((Object)suffix) ? ExpansionPositionTypeEnum.ALL.getType() : ExpansionPositionTypeEnum.SELECT_WHERE.getType());
            tableExpansionSlaveColumnInfo.setUsage(usage);
            if (HussarUtils.equals((Object)"foreign", (Object)usage)) {
                masterTableInfo.setForeignColumnName(field.getString("sourceFieldName"));
            }
            fields.add(tableExpansionSlaveColumnInfo);
        });
        return fields;
    }

    private TableExpansionMaster dealMasterTable(JSONObject masterTable, Map<String, String> alias) {
        TableExpansionMaster tableExpansionMaster = new TableExpansionMaster();
        tableExpansionMaster.setTableName(masterTable.getString("sourceDataModelName"));
        masterTable.getJSONArray("fields").forEach(item -> {
            JSONObject field = (JSONObject)item;
            if (HussarUtils.isNotEmpty((Object)field.get((Object)"usage")) && HussarUtils.equals((Object)field.get((Object)"usage"), (Object)"primary")) {
                tableExpansionMaster.setPrimaryPropertyName(field.getString("name"));
                tableExpansionMaster.setPrimaryColumnName(field.getString("sourceFieldName"));
            }
        });
        String masterAlias = alias.get(masterTable.getString("id"));
        tableExpansionMaster.setTableAlias(masterAlias);
        return tableExpansionMaster;
    }
}

