/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.function.element.base;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.ext.function.ExtCustomOperation;
import com.jxdinfo.hussar.formdesign.ext.function.ExtEnclosure;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModelDTO;
import com.jxdinfo.hussar.formdesign.ext.function.extendoperation.method.ExtModelMethodCategories;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.ExtDataModelBase;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.field.ExtDataModelField;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.operation.ExtDataModelOperation;
import com.jxdinfo.hussar.formdesign.ext.util.ExtModelBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtBaseDataModel
extends ExtDataModelBase {
    public static final Logger LOGGER = LoggerFactory.getLogger(ExtBaseDataModel.class);
    private String[] FUNCTION_BASE = new String[]{"BASE", "FLOW", "VIEW", "TASK", "CUSTOM_SQL"};
    private String[] FUNCTION_MS = new String[]{"MASTER_SLAVE", "FLOW_MASTER_SLAVE", "TASK_MASTER_SLAVE"};
    private String sourceId;
    private Map<String, List<ExtDataModelField>> extFields;
    private JSONArray slaveTables;
    private JSONArray relationships;
    private JSONArray queryConditions;
    private JSONArray queryObject;
    private JSONArray sortCondition;

    public ExtBaseDataModel parseDataModel(JSONObject jsonObject) throws LcdpException {
        ExtBaseDataModel oscarBaseDataModel;
        try {
            oscarBaseDataModel = (ExtBaseDataModel)((Object)JSONObject.parseObject((String)jsonObject.toString(), ExtBaseDataModel.class));
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            throw new LcdpException(LcdpExceptionEnum.ERROR, "\u89e3\u6790\u6a21\u578b\u5bf9\u8c61\u5f02\u5e38");
        }
        return oscarBaseDataModel;
    }

    public ExtEnclosure enclosure() throws LcdpException {
        ExtEnclosure enclosure;
        boolean anyMatchBase = Arrays.stream(this.FUNCTION_BASE).anyMatch(v -> {
            try {
                return v.equals(this.getFunctionType());
            }
            catch (LcdpException e) {
                throw new RuntimeException(e);
            }
        });
        String bean = anyMatchBase ? String.format("EXT.BASE.%s", "ENCLOSURE") : String.format("EXT.MASTER_SLAVE.%s", "ENCLOSURE");
        try {
            enclosure = (ExtEnclosure)SpringContextHolder.getBean((String)bean);
        }
        catch (Exception e) {
            throw new RuntimeException("\u901a\u8fc7SpringContextHolder.getBean()\u83b7\u53d6enclosure\u5931\u8d25\uff1a" + bean);
        }
        return enclosure;
    }

    public List<ExtDataModelOperation> assemblyModelOptions(JSONObject dataModel, ExtBaseDataModelDTO dataModelDTO) throws LcdpException, IOException, CloneNotSupportedException {
        ArrayList<ExtDataModelOperation> extOperationList = new ArrayList<ExtDataModelOperation>();
        List allCustomOperation = Arrays.stream(ExtModelMethodCategories.class.getDeclaredFields()).filter(f -> String.class.equals(f.getType())).filter(f -> Modifier.isPublic(f.getModifiers())).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> Modifier.isFinal(f.getModifiers())).map(f -> {
            try {
                return (String)f.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        for (String operationType : allCustomOperation) {
            ExtDataModelOperation extDataModelOperation;
            ExtCustomOperation<ExtBaseDataModel, ExtBaseDataModelDTO> assemble = null;
            assemble = ExtModelBeanUtil.getCusOperation("Ext", "Assemble", operationType);
            if (assemble == null || !HussarUtils.isNotEmpty((Object)(extDataModelOperation = assemble.assembleOperation(dataModel, this, dataModelDTO)))) continue;
            extOperationList.add(extDataModelOperation);
        }
        return extOperationList;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Map<String, List<ExtDataModelField>> getExtFields() {
        return this.extFields;
    }

    public void setExtFields(Map<String, List<ExtDataModelField>> extFields) {
        this.extFields = extFields;
    }

    public JSONArray getSlaveTables() {
        return this.slaveTables;
    }

    public void setSlaveTables(JSONArray slaveTables) {
        this.slaveTables = slaveTables;
    }

    public JSONArray getRelationships() {
        return this.relationships;
    }

    public void setRelationships(JSONArray relationships) {
        this.relationships = relationships;
    }

    public JSONArray getQueryConditions() {
        return this.queryConditions;
    }

    public void setQueryConditions(JSONArray queryConditions) {
        this.queryConditions = queryConditions;
    }

    public JSONArray getQueryObject() {
        return this.queryObject;
    }

    public void setQueryObject(JSONArray queryObject) {
        this.queryObject = queryObject;
    }

    public JSONArray getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(JSONArray sortCondition) {
        this.sortCondition = sortCondition;
    }

    public String getFunctionType() throws LcdpException {
        DataModelBase dataModelBase = DataModelUtil.getDataModelBase((String)this.sourceId);
        if (HussarUtils.isEmpty((Object)dataModelBase)) {
            throw new RuntimeException("\u539f\u6a21\u578b\u4e0d\u5b58\u5728\uff1a" + this.sourceId);
        }
        return dataModelBase.getFunctionType();
    }
}

