/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.ext.function.element.base.ExtBaseDataModel;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.ExtDataModelBase;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.operation.ExtDataModelOperation;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtModelPathUtil {
    public static String taskExpansionModelId(String taskTablePah) {
        String appName = AppContextUtil.getStandardAppInfo().getEnglishName();
        String modulePath = FileUtil.systemPath((String[])new String[]{taskTablePah}).replace("/", "").replace("\\", "").replace("//", "").replace("\\\\", "");
        return appName + modulePath;
    }

    public static String noTaskExpansionModelId(ExtBaseDataModel extBaseDataModel) {
        String appName = AppContextUtil.getStandardAppInfo().getEnglishName();
        String noTaskModePath = extBaseDataModel.getModelPath() + "/" + extBaseDataModel.getName();
        noTaskModePath = FileUtil.systemPath((String[])new String[]{noTaskModePath.replace("/", "").replace("\\", "").replace("//", "").replace("\\\\", "")});
        return appName + noTaskModePath;
    }

    public static JSONObject getOperationByType(String operationType, JSONObject dataModel, ExtDataModelBase extDataModelBase) {
        JSONArray operations;
        if (HussarUtils.isNotEmpty((Object)operationType) && HussarUtils.isNotEmpty((Object)(operations = (JSONArray)dataModel.get((Object)"operations")))) {
            for (Object operation : operations) {
                JSONObject operationJson = (JSONObject)JSONObject.toJSON(operation);
                if (!HussarUtils.isNotEmpty((Object)operationJson) || !operationType.equals(operationJson.get((Object)"type").toString())) continue;
                return operationJson;
            }
        }
        return null;
    }

    public static List<JSONObject> getOperationsByType(String operationType, JSONObject dataModel, ExtDataModelBase extDataModelBase) {
        JSONArray operations;
        ArrayList<JSONObject> operationsList = new ArrayList<JSONObject>();
        if (HussarUtils.isNotEmpty((Object)operationType) && HussarUtils.isNotEmpty((Object)(operations = (JSONArray)dataModel.get((Object)"operations")))) {
            for (Object operation : operations) {
                JSONObject operationJson = (JSONObject)JSONObject.toJSON(operation);
                if (!HussarUtils.isNotEmpty((Object)operationJson) || !operationType.equals(operationJson.get((Object)"type").toString())) continue;
                operationsList.add(operationJson);
            }
        }
        return operationsList;
    }

    public static Map<String, Object> getPlusParams(JSONObject dataModel, ExtBaseDataModel extDataModelBase) {
        JSONArray opsArr;
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<String> slaveIds = ExtModelPathUtil.getSlaveIds(extDataModelBase);
        if (HussarUtils.isNotEmpty(slaveIds)) {
            params.put("extendSlaveId", slaveIds);
        }
        if (HussarUtils.isEmpty((Object)(opsArr = dataModel.getJSONArray("operations")))) {
            params.put("isPlus", false);
            return params;
        }
        boolean anyMatch = opsArr.stream().anyMatch(o -> {
            ExtDataModelOperation op = (ExtDataModelOperation)JSONObject.parseObject((String)JSON.toJSONString((Object)o), ExtDataModelOperation.class);
            Map slaveTablePlusSave = (Map)JSONObject.parseObject((String)JSON.toJSONString((Object)op.getParams().get("slaveTablePlusSave")), (TypeReference)new TypeReference<Map<String, Boolean>>(){}, (Feature[])new Feature[0]);
            params.put("slaveTablePlusSave", slaveTablePlusSave);
            return ToolUtil.isNotEmpty((Object)slaveTablePlusSave) && slaveTablePlusSave.containsValue(Boolean.TRUE);
        });
        params.put("isPlus", anyMatch);
        return params;
    }

    public static List<String> getSlaveIds(ExtBaseDataModel extDataModelBase) {
        ArrayList<String> slaveIds = new ArrayList<String>();
        JSONArray slaveTables = extDataModelBase.getSlaveTables();
        if (HussarUtils.isNotEmpty((Object)slaveTables)) {
            for (Object slaveTable : slaveTables) {
                JSONObject slaveJson = (JSONObject)JSONObject.toJSON(slaveTable);
                if (!HussarUtils.isNotEmpty((Object)slaveJson.get((Object)"id"))) continue;
                slaveIds.add(slaveJson.get((Object)"id").toString());
            }
        }
        return slaveIds;
    }
}

