/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.ext.service;

import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionConfig;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionMethodInfo;
import com.jxdinfo.hussar.formdesign.ext.function.modelentity.TableExpansionSlaveTableInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

@Service
public class RuntimeYamlOperator {
    private final Yaml yaml;

    public RuntimeYamlOperator() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        Representer representer = new Representer(options);
        representer.getPropertyUtils().setSkipMissingProperties(true);
        representer.addClassTag(TableExpansionConfig.class, Tag.MAP);
        representer.addClassTag(TableExpansionInfo.class, Tag.MAP);
        representer.addClassTag(TableExpansionMethodInfo.class, Tag.MAP);
        representer.addClassTag(TableExpansionSlaveTableInfo.class, Tag.MAP);
        LoaderOptions loaderOptions = new LoaderOptions();
        this.yaml = new Yaml((BaseConstructor)new Constructor(TableExpansionConfig.class, loaderOptions), representer, options);
    }

    public TableExpansionConfig loadYaml(String filePath) throws IOException {
        File configFile = new File(filePath);
        if (!configFile.exists()) {
            TableExpansionConfig emptyConfig = new TableExpansionConfig();
            emptyConfig.setTableExpansionColumnInfo(new LinkedHashMap<String, List<TableExpansionInfo>>());
            emptyConfig.setTableExpansionMethodInfos(new LinkedHashMap<String, List<TableExpansionMethodInfo>>());
            emptyConfig.setTableExpansionSlaveTableInfos(new LinkedHashMap<String, List<TableExpansionSlaveTableInfo>>());
            return emptyConfig;
        }
        try (FileInputStream inputStream = new FileInputStream(configFile);){
            TableExpansionConfig loaded = (TableExpansionConfig)this.yaml.loadAs((InputStream)inputStream, TableExpansionConfig.class);
            if (loaded == null) {
                loaded = new TableExpansionConfig();
            }
            if (loaded.getTableExpansionColumnInfo() == null) {
                loaded.setTableExpansionColumnInfo(new LinkedHashMap<String, List<TableExpansionInfo>>());
            }
            if (loaded.getTableExpansionMethodInfos() == null) {
                loaded.setTableExpansionMethodInfos(new LinkedHashMap<String, List<TableExpansionMethodInfo>>());
            }
            if (loaded.getTableExpansionSlaveTableInfos() == null) {
                loaded.setTableExpansionSlaveTableInfos(new LinkedHashMap<String, List<TableExpansionSlaveTableInfo>>());
            }
            TableExpansionConfig tableExpansionConfig = loaded;
            return tableExpansionConfig;
        }
    }

    public void saveYaml(String filePath, TableExpansionConfig config) throws IOException {
        File configFile = new File(filePath);
        configFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFile);){
            this.yaml.dump((Object)config, (Writer)writer);
        }
    }

    public void updateYamlConfig(String filePath, TableExpansionConfig config) throws IOException {
        Map<String, List<TableExpansionSlaveTableInfo>> tableExpansionSlaveTableInfos;
        Map<String, List<TableExpansionMethodInfo>> tableExpansionMethodInfos;
        TableExpansionConfig currentFile = this.loadYaml(filePath);
        Map<String, List<TableExpansionInfo>> configMap = currentFile.getTableExpansionColumnInfo();
        Map<String, List<TableExpansionMethodInfo>> methodInfoMap = currentFile.getTableExpansionMethodInfos();
        Map<String, List<TableExpansionSlaveTableInfo>> slaveTableInfoMap = currentFile.getTableExpansionSlaveTableInfos();
        Map<String, List<TableExpansionInfo>> tableExpansionColumnInfo = config.getTableExpansionColumnInfo();
        if (HussarUtils.isNotEmpty(tableExpansionColumnInfo)) {
            Iterator<Map.Entry<String, List<TableExpansionInfo>>> iterator = tableExpansionColumnInfo.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<TableExpansionInfo>> entry = iterator.next();
                List<TableExpansionInfo> tableExpansionInfoList = entry.getValue();
                if (!HussarUtils.isEmpty(tableExpansionInfoList)) continue;
                iterator.remove();
                if (!HussarUtils.isNotEmpty(configMap)) continue;
                configMap.remove(entry.getKey());
            }
            if (HussarUtils.isNotEmpty(tableExpansionColumnInfo)) {
                configMap.putAll(tableExpansionColumnInfo);
            }
        }
        if (HussarUtils.isNotEmpty(tableExpansionMethodInfos = config.getTableExpansionMethodInfos())) {
            Iterator<Map.Entry<String, List<TableExpansionMethodInfo>>> iterator = tableExpansionMethodInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<TableExpansionMethodInfo>> entry = iterator.next();
                List<TableExpansionMethodInfo> methodInfos = entry.getValue();
                if (!HussarUtils.isEmpty(methodInfos)) continue;
                iterator.remove();
                if (!HussarUtils.isNotEmpty(methodInfoMap)) continue;
                methodInfoMap.remove(entry.getKey());
            }
            if (HussarUtils.isNotEmpty(tableExpansionMethodInfos)) {
                methodInfoMap.putAll(tableExpansionMethodInfos);
            }
        }
        if (HussarUtils.isNotEmpty(tableExpansionSlaveTableInfos = config.getTableExpansionSlaveTableInfos())) {
            Iterator<Map.Entry<String, List<TableExpansionSlaveTableInfo>>> iterator = tableExpansionSlaveTableInfos.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<TableExpansionSlaveTableInfo>> entry = iterator.next();
                List<TableExpansionSlaveTableInfo> slaveTableInfos = entry.getValue();
                if (!HussarUtils.isEmpty(slaveTableInfos)) continue;
                iterator.remove();
                if (!HussarUtils.isNotEmpty(slaveTableInfoMap)) continue;
                slaveTableInfoMap.remove(entry.getKey());
            }
            if (HussarUtils.isNotEmpty(tableExpansionSlaveTableInfos)) {
                slaveTableInfoMap.putAll(tableExpansionSlaveTableInfos);
            }
        }
        this.saveYaml(filePath, currentFile);
    }

    public void updateMethodYamlConfig(String filePath, List<TableExpansionMethodInfo> newInfo) throws IOException {
        File configFile = new File(filePath);
        configFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFile);){
            this.yaml.dump(newInfo, (Writer)writer);
        }
    }

    public List<TableExpansionInfo> getConfigByKey(String filePath, String dynamicKey) throws IOException {
        TableExpansionConfig config = this.loadYaml(filePath);
        return config.getTableExpansionColumnInfo().getOrDefault(dynamicKey, Collections.emptyList());
    }
}

