package ${table.packageInfo.Controller!};

<#if table.useMybatisPlus>
</#if>
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.expansion.core.annotations.ExpansionModelId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
<#assign controller = table.controllerGenerateInfo!>
<#include "../../swagger/swagger.ftl">
<#if controller.codes?? && controller.codes?size gt 0>
    import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
    import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
</#if>
<#list controller.imports! as import>
import ${import};
</#list>

/**
 * ${table.comment!}控制器
 */
@RestController(value = "${controller.qualifyBeanName!}")
@RequestMapping(value = "${table.controllerPrefix}")
@AuditLog(moduleName = "${table.comment!}")
<#if !table.extensionApp>
@ExpansionModelId(modelId = "${controller.expansionModelId!}")
</#if>
${api!}
<#if table.useMybatisPlus>
public class ${table.controllerName}{
<#else>
public class ${table.controllerName} {
</#if>
private static final Logger logger = LoggerFactory.getLogger(${table.controllerName}.class);
    <#list controller.inversions! as inversion>
    @Autowired
    private ${inversion} ${inversion?uncap_first};
    </#list>

    <#if controller.inversionsWithName??>
    <#assign keys=controller.inversionsWithName?keys/>
    <#list keys! as key>
    @Autowired
    private ${key} ${controller.inversionsWithName[key]?uncap_first};
    </#list>
    </#if>
/* @begin Autowired #自定义注入 */
/* @end Autowired */

    <#list controller.codes! as code>
${code}

    </#list>

/* @begin method #自定义方法 */
/* @end method */
}
