/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.kingbase.function.visitor.flow.masterslaveflow.extension;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.constant.ConnectEnum;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.kingbase.ctx.KingBaseBackCtx;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.base.KingBaseBaseDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.flow.KingBaseFlowMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModel;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.KingBaseMsDataModelDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.element.masterslave.relationship.KingBaseRelationshipFieldDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBase;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseDataModelBaseDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.KingBaseQueryDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelField;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseDataModelFieldDto;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.field.KingBaseQueryFieldDTO;
import com.jxdinfo.hussar.formdesign.kingbase.function.modelentity.operation.KingBaseDataModelOperation;
import com.jxdinfo.hussar.formdesign.kingbase.function.visitor.masterslave.util.KingBaseMasterSlaveUtil;
import com.jxdinfo.hussar.formdesign.kingbase.util.SerialNumberUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KingBaseFlowMsExtensionUtil {
    private static final String INSERT_FILL = "insertFill";
    private static final String UPDATE_FILL = "updateFill";
    private static final String DELGETSTR = "::get";
    private static final String FLOW_INCREMENT_NAME = "FlowIncrementDTO";

    public static void renderMsInsertOrUpdate(Map<String, Object> controllerParams, KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx) throws LcdpException {
        KingBaseFlowMsExtensionUtil.masterSlaveCode(backCtx, controllerParams);
    }

    public static void renderMsDelete(Map<String, Object> controllerParams, KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx) throws LcdpException {
        KingBaseFlowMsExtensionUtil.masterSlaveCodeDel(backCtx, controllerParams);
    }

    private static void masterSlaveCodeDel(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Object> params) {
        String currentModelId = backCtx.getUseDataModelBase().getId();
        KingBaseMsDataModel useDataModelBase = backCtx.getUseDataModelBase();
        KingBaseMsDataModelDTO baseDataModelDTO = backCtx.getUseDataModelDtoMap().get(currentModelId);
        KingBaseDataModelBaseDTO masterDto = baseDataModelDTO.getDataModelDtoMap().get(useDataModelBase.getMasterTable().getId());
        List<KingBaseRelationshipDTO> relationshipDtoList = baseDataModelDTO.getRelationshipDtoList();
        if (ToolUtil.isEmpty(relationshipDtoList) || ToolUtil.isEmpty((Object)masterDto)) {
            return;
        }
        KingBaseDataModelFieldDto keyFieldDto = masterDto.getKeyField();
        if (ToolUtil.isEmpty((Object)keyFieldDto)) {
            return;
        }
        ArrayList<KingBaseRelationshipDTO> kingbaseRelationshipDTOList = new ArrayList<KingBaseRelationshipDTO>(relationshipDtoList);
        if (params.get("logicallyDelete") != null) {
            for (KingBaseRelationshipDTO relationshipDTO : kingbaseRelationshipDTOList) {
                if (!relationshipDTO.getSlaveTableDto().isExtension()) {
                    relationshipDtoList.remove(relationshipDTO);
                    continue;
                }
                relationshipDTO.init();
            }
        } else {
            for (KingBaseRelationshipDTO relationshipDTO : kingbaseRelationshipDTOList) {
                if (!relationshipDTO.getSlaveTableDto().isExtension()) {
                    relationshipDtoList.remove(relationshipDTO);
                    continue;
                }
                relationshipDTO.setLogicallyDelete(false);
            }
        }
        StringBuilder relationStr = new StringBuilder();
        if (HussarUtils.isNotEmpty(relationshipDtoList)) {
            relationStr = KingBaseFlowMsExtensionUtil.getDelStr(relationshipDtoList, masterDto);
        }
        KingBaseFlowMsExtensionUtil.renderTransaction(backCtx, params, currentModelId);
        params.put("masterTable", masterDto);
        params.put("relationshipDtoList", relationshipDtoList);
        params.put("relationStr", String.valueOf(relationStr));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.PostMapping");
        backCtx.addControllerImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        backCtx.addControllerImport(currentModelId, baseDataModelDTO.getImportInfo().get("Service"));
        backCtx.addControllerImport(currentModelId, "org.springframework.web.bind.annotation.RequestParam");
        backCtx.addServiceImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
        boolean delFlag = true;
        for (KingBaseRelationshipDTO kingbaseRelationshipDTO : relationshipDtoList) {
            if (delFlag) {
                backCtx.addServiceImplImport(currentModelId, "com.baomidou.mybatisplus.core.toolkit.Wrappers");
                backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
                delFlag = false;
            }
            KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = baseDataModelDTO.getDataModelDtoMap().get(kingbaseRelationshipDTO.getSlaveTableId());
            backCtx.addServiceImplImport(currentModelId, kingbaseDataModelBaseDTO.getImportInfo().get("Entity"));
            backCtx.addServiceImplImport(currentModelId, kingbaseDataModelBaseDTO.getImportInfo().get("Service"));
            backCtx.addServiceImplInversion(currentModelId, kingbaseDataModelBaseDTO.getServiceName());
        }
        if (delFlag) {
            backCtx.addServiceImplInversion(currentModelId, masterDto.getServiceName());
            backCtx.addServiceImplImport(currentModelId, masterDto.getImportInfo().get("Service"));
        }
        backCtx.addServiceImplImport(currentModelId, "java.util.List");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.utils.StringUtil");
        backCtx.addServiceImplImport(currentModelId, "com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse");
    }

    private static void masterSlaveCode(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams) throws LcdpException {
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        String modelId = dataModelBase.getId();
        KingBaseMsDataModelDTO kingbaseMsDataModelDTO = backCtx.getUseDataModelDtoMap().get(modelId);
        List<KingBaseRelationshipDTO> relationshipDtoList = kingbaseMsDataModelDTO.getRelationshipDtoList();
        KingBaseDataModelBase masterTable = dataModelBase.getMasterTable();
        String masterId = masterTable.getId();
        Map<String, KingBaseDataModelBaseDTO> dataModelDtoMap = kingbaseMsDataModelDTO.getDataModelDtoMap();
        KingBaseDataModelBaseDTO mainDataModelDto = dataModelDtoMap.get(masterId);
        controllerParams.put("masterTable", mainDataModelDto);
        KingBaseFlowMsExtensionUtil.renderTransaction(backCtx, controllerParams, modelId);
        String masterFillCode = KingBaseFlowMsExtensionUtil.renderFillCode(backCtx, mainDataModelDto, kingbaseMsDataModelDTO);
        if (masterFillCode != null) {
            controllerParams.put("masterFillCode", masterFillCode);
        }
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Service"));
        backCtx.addServiceImplImport(modelId, mainDataModelDto.getImportInfo().get("Entity"));
        backCtx.addServiceImplInversion(modelId, mainDataModelDto.getServiceName());
        if (ToolUtil.isNotEmpty((Object)dataModelBase) && ToolUtil.isNotEmpty(relationshipDtoList)) {
            HashMap<String, String> slaveFillCodeList = new HashMap<String, String>();
            for (KingBaseRelationshipDTO relationshipDTO : relationshipDtoList) {
                List<KingBaseRelationshipFieldDTO> kingbaseRelationshipFieldDTOS;
                String slaveTableId = relationshipDTO.getSlaveTableId();
                String relateModelType = relationshipDTO.getRelateModelType();
                KingBaseDataModelBaseDTO slaveModelDto = dataModelDtoMap.get(slaveTableId);
                String slaveFillCode = KingBaseFlowMsExtensionUtil.renderFillCode(backCtx, slaveModelDto, kingbaseMsDataModelDTO);
                slaveFillCodeList.put(slaveTableId, slaveFillCode);
                if (slaveFillCode != null) {
                    relationshipDTO.setSlaveTableFillCode(slaveFillCode);
                }
                if (!ToolUtil.isNotEmpty(kingbaseRelationshipFieldDTOS = relationshipDTO.getRelationshipDtoList())) continue;
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Service"));
                backCtx.addServiceImplImport(modelId, slaveModelDto.getImportInfo().get("Entity"));
                backCtx.addServiceImplInversion(modelId, slaveModelDto.getServiceName());
                if ("collection".equals(relateModelType)) {
                    backCtx.addServiceImplImport(modelId, "java.util.List");
                }
                backCtx.addServiceImplImport(modelId, "com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper");
            }
            controllerParams.put("slaveFillCodeList", slaveFillCodeList);
        }
    }

    private static void renderTransaction(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, Map<String, Object> controllerParams, String modelId) {
        if (backCtx.getOpenTransactional() != null && backCtx.getOpenTransactional().booleanValue()) {
            controllerParams.put("openTransactional", backCtx.getOpenTransactional());
        }
    }

    private static String renderFillCode(KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, KingBaseDataModelBaseDTO dataModelBaseDTO, KingBaseMsDataModelDTO msDataModelDTO) throws LcdpException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", dataModelBaseDTO);
        params.put("serviceEnName", dataModelBaseDTO.getServiceEnName());
        boolean insertFill = false;
        boolean updateFill = false;
        for (KingBaseDataModelFieldDto field : dataModelBaseDTO.getFields()) {
            if (field.getFill() == null) continue;
            switch (field.getFill()) {
                case "serialNumber": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService");
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.code.plus.dto.CodePlusDto");
                    backCtx.addServiceImplInversion(backCtx.getUseDataModelBase().getId(), "ISysCodeRuleService");
                    JSONObject jsonObject = (JSONObject)DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()).get((Object)"masterTable");
                    String commont = jsonObject.getString("commont");
                    String sourceDataModelName = jsonObject.getString("sourceDataModelName");
                    params.put("codeRule", SerialNumberUtil.structureCodeRule(field.getName(), field.getId()));
                    SerialNumberUtil.saveCodeRule(DataModelUtil.getDataModelJson((String)msDataModelDTO.getId()), commont, sourceDataModelName, field.getName(), params, true, field.getId());
                }
                case "createUser": 
                case "dataHolder": 
                case "dataOrgan": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "createTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "delDefFlag": {
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    break;
                }
                case "updateUser": {
                    msDataModelDTO.addServiceImplImport("com.jxdinfo.hussar.common.security.BaseSecurityUtil;");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
                case "updateTime": {
                    msDataModelDTO.addServiceImplImport("java.time.LocalDateTime");
                    insertFill = true;
                    params.put(INSERT_FILL, true);
                    updateFill = true;
                    params.put(UPDATE_FILL, true);
                    break;
                }
            }
        }
        if (!insertFill && !updateFill) {
            return null;
        }
        String fillPath = "template/kingbase/backcode/addorupdate/fill.ftl";
        return RenderUtil.renderTemplate((String)fillPath, params);
    }

    private static StringBuilder getDelStr(List<KingBaseRelationshipDTO> relationshipDtoList, KingBaseDataModelBaseDTO masterDto) {
        StringBuilder relationStr = new StringBuilder();
        for (KingBaseRelationshipDTO relationtMap : relationshipDtoList) {
            List<KingBaseRelationshipFieldDTO> relationShipsList = relationtMap.getRelationshipDtoList();
            KingBaseRelationshipFieldDTO kingbaseRelationshipFieldDTO = relationShipsList.get(0);
            if (relationtMap.isLogicallyDelete()) {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".update(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate().set(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(relationtMap.getDeleteFlag()).append(",\"1\")");
            } else {
                relationStr.append(relationtMap.getSlaveTableServiceName()).append(".remove(Wrappers.<").append(relationtMap.getSlaveTableName()).append(">lambdaUpdate()");
            }
            if (relationShipsList.size() == 1) {
                Optional<KingBaseDataModelFieldDto> relationTag;
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
                List<KingBaseDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    KingBaseDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            } else {
                relationStr.append(".in(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDTO.getSlaveFieldCap()).append(",idList)");
            }
            for (int i = 1; i < relationShipsList.size(); ++i) {
                Optional<KingBaseDataModelFieldDto> relationTag;
                KingBaseRelationshipFieldDTO kingbaseRelationshipFieldDtos = relationShipsList.get(i);
                if (ConnectEnum._OR.getType().equals(kingbaseRelationshipFieldDtos.getConnect())) {
                    relationStr.append(".").append(kingbaseRelationshipFieldDtos.getConnect()).append("().eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(KingBaseFlowMsExtensionUtil.lowercase(masterDto.getEntityName())).append(".get").append(kingbaseRelationshipFieldDtos.getMasterFieldCap()).append("())");
                } else {
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(kingbaseRelationshipFieldDtos.getSlaveFieldCap()).append(",").append(KingBaseFlowMsExtensionUtil.lowercase(masterDto.getEntityName())).append(".get").append(kingbaseRelationshipFieldDtos.getMasterFieldCap()).append("())");
                }
                if (i != relationShipsList.size() - 1) continue;
                List<KingBaseDataModelFieldDto> fields = relationtMap.getSlaveTableDto().getFields();
                if (HussarUtils.isNotEmpty(fields) && (relationTag = fields.stream().filter(filed -> HussarUtils.equals((Object)filed.getFill(), (Object)"relationTag")).findFirst()).isPresent()) {
                    KingBaseDataModelFieldDto fieldDto = relationTag.get();
                    relationStr.append(".eq(").append(relationtMap.getSlaveTableName()).append(DELGETSTR).append(fieldDto.getCapitalName()).append(",").append("\"").append(relationtMap.getSlaveTableAlias()).append("\")");
                }
                relationStr.append(");\n");
            }
        }
        return relationStr;
    }

    private static String lowercase(String name) {
        if (ToolUtil.isNotEmpty((Object)name)) {
            return name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return "";
    }

    public static void generateIncrementDTO(KingBaseMsDataModelDTO kingbaseFlowDataModelDTO, KingBaseBackCtx<KingBaseFlowMsDataModel, KingBaseFlowMsDataModelDTO> backCtx, KingBaseDataModelOperation dataModelOperation) {
        Map<String, Object> params = dataModelOperation.getParams();
        Map slaveTablePlusSave = (Map)params.get("slaveTablePlusSave");
        HashMap<String, Boolean> isLogicallyDelete = new HashMap<String, Boolean>();
        HashMap<String, String> logicallyDelField = new HashMap<String, String>();
        HashMap<String, String> capitalNameList = new HashMap<String, String>();
        HashMap<String, String> relationTagKeys = new HashMap<String, String>();
        KingBaseMsDataModel dataModelBase = backCtx.getUseDataModelBase();
        for (KingBaseDataModelBase kingBaseDataModelBase : dataModelBase.getSlaveTables()) {
            String slaveModelName = kingBaseDataModelBase.getName();
            KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = kingbaseFlowDataModelDTO.getDataModelDtoMap().get(kingBaseDataModelBase.getId());
            for (KingBaseDataModelFieldDto field : kingbaseDataModelBaseDTO.getFields()) {
                if (!"relationTag".equals(field.getFill())) continue;
                relationTagKeys.put(slaveModelName, field.getCapitalName());
            }
        }
        params.put("relationTagKeys", relationTagKeys);
        boolean plusFlag = false;
        if (HussarUtils.isNotEmpty((Object)slaveTablePlusSave)) {
            for (String key : slaveTablePlusSave.keySet()) {
                if (!((Boolean)slaveTablePlusSave.get(key)).booleanValue()) continue;
                plusFlag = true;
                break;
            }
        }
        params.put("ifPlusSave", plusFlag);
        if (!plusFlag) {
            return;
        }
        for (KingBaseRelationshipDTO relationshipDTO : kingbaseFlowDataModelDTO.getRelationshipDtoList()) {
            if (!HussarUtils.equals((Object)"collection", (Object)relationshipDTO.getRelateModelType())) continue;
            slaveTablePlusSave.put(relationshipDTO.getSlaveTableId(), true);
        }
        KingBaseFlowMsExtensionUtil.addIncrementTable(kingbaseFlowDataModelDTO, slaveTablePlusSave, dataModelBase);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> foreignKeys = new HashMap<String, String>();
        for (KingBaseDataModelBase modelBase : dataModelBase.getSlaveTables()) {
            isLogicallyDelete.put(modelBase.getId(), ((KingBaseBaseDataModel)modelBase).getLogicallyDelete());
            KingBaseDataModelBaseDTO kingbaseDataModelBaseDTO = kingbaseFlowDataModelDTO.getDataModelDtoMap().get(modelBase.getId());
            String slaveModelName = modelBase.getName();
            capitalNameList.put(slaveModelName, KingBaseMasterSlaveUtil.getCapitalName(slaveModelName));
            for (KingBaseDataModelField kingBaseDataModelField : modelBase.getFields()) {
                if (!"delDefFlag".equals(kingBaseDataModelField.getUsage())) continue;
                logicallyDelField.put(slaveModelName, kingBaseDataModelField.getName());
                break;
            }
            for (KingBaseDataModelFieldDto kingBaseDataModelFieldDto : kingbaseDataModelBaseDTO.getFields()) {
                if ("primary".equals(kingBaseDataModelFieldDto.getFill())) {
                    hashMap.put(slaveModelName, kingBaseDataModelFieldDto.getCapitalName());
                }
                if (!"foreign".equals(kingBaseDataModelFieldDto.getFill())) continue;
                foreignKeys.put(slaveModelName, kingBaseDataModelFieldDto.getCapitalName());
            }
        }
        params.put("primaryKeys", hashMap);
        params.put("foreignKeys", foreignKeys);
        params.put("slaveTablePlusSave", slaveTablePlusSave);
        params.put("slaveTable", KingBaseMasterSlaveUtil.ofSlaveParam(dataModelBase, kingbaseFlowDataModelDTO));
        params.put("isLogicallyDelete", isLogicallyDelete);
        params.put("logicallyDelField", logicallyDelField);
        params.put("capitalNameList", capitalNameList);
        String modelId = backCtx.getUseDataModelBase().getId();
        if (HussarUtils.isEmpty((Object)kingbaseFlowDataModelDTO.getQueryDtoMap().get(kingbaseFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME))) {
            KingBaseQueryDTO oldDTO = kingbaseFlowDataModelDTO.getQueryDtoMap().get(kingbaseFlowDataModelDTO.getName());
            KingBaseQueryDTO kingbaseQueryDTO = (KingBaseQueryDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oldDTO), KingBaseQueryDTO.class);
            HashMap<String, Object> newParams = new HashMap<String, Object>();
            newParams.put("queryDto", kingbaseQueryDTO);
            HashMap<String, Boolean> table = new HashMap<String, Boolean>();
            table.put("enableSwaggerRender", ((FormDesignProperties)SpringContextUtil.getBean(FormDesignProperties.class)).isEnableSwaggerRender());
            newParams.put("table", table);
            kingbaseQueryDTO.setParams(newParams);
            String string = kingbaseFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME;
            String plusTableName = kingbaseFlowDataModelDTO.getEntityName() + "IncrementTable";
            for (KingBaseQueryFieldDTO dto : kingbaseQueryDTO.getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                dto.getDbColumnType().setType(plusTableName);
                dto.getDbColumnType().setImportT(kingbaseQueryDTO.getPackageInfo() + "." + plusTableName);
                params.put("incrementTable", dto.getDbColumnType());
                backCtx.addServiceImplImport(modelId, dto.getDbColumnType().getImportT());
                break;
            }
            kingbaseQueryDTO.setName(kingbaseQueryDTO.getName() + FLOW_INCREMENT_NAME);
            kingbaseQueryDTO.setEntityName(string);
            kingbaseQueryDTO.setImportInfo(kingbaseQueryDTO.getPackageInfo() + "." + string);
            kingbaseQueryDTO.setWriteFilePath(FileUtil.systemPath((String[])new String[]{kingbaseFlowDataModelDTO.getTablePath(), "dto", string + ".java"}));
            kingbaseFlowDataModelDTO.getQueryDtoMap().put(kingbaseQueryDTO.getName(), kingbaseQueryDTO);
            params.put("parameter", string);
            backCtx.addControllerImport(modelId, kingbaseQueryDTO.getImportInfo());
            backCtx.addServiceImport(modelId, kingbaseQueryDTO.getImportInfo());
            backCtx.addServiceImplImport(modelId, kingbaseQueryDTO.getImportInfo());
        } else {
            for (KingBaseQueryFieldDTO dto : kingbaseFlowDataModelDTO.getQueryDtoMap().get(kingbaseFlowDataModelDTO.getName() + FLOW_INCREMENT_NAME).getQueryFields()) {
                if (!"formdata".equals(dto.getPropertyName())) continue;
                params.put("incrementTable", dto.getDbColumnType());
                break;
            }
            params.put("parameter", kingbaseFlowDataModelDTO.getEntityName() + FLOW_INCREMENT_NAME);
        }
    }

    private static void addIncrementTable(KingBaseMsDataModelDTO dataModelBaseDTO, Map<String, Boolean> slaveTablePlusSave, KingBaseMsDataModel dataModelBase) {
        KingBaseQueryDTO queryDTO = new KingBaseQueryDTO();
        String masterId = dataModelBase.getMasterTable().getId();
        queryDTO.setFtlPath("template/kingbase/backcode/code/formPlusSave.ftl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("masterTable", dataModelBaseDTO.getDataModelDtoMap().get(masterId));
        params.put("slaveTable", KingBaseMasterSlaveUtil.ofSlaveParam(dataModelBase, dataModelBaseDTO));
        params.put("ifPlusSave", slaveTablePlusSave);
        params.put("table", dataModelBaseDTO);
        params.put("queryDto", queryDTO);
        queryDTO.setParams(params);
        queryDTO.setPackageInfo(dataModelBaseDTO.getPackageInfo().get("dto"));
        queryDTO.setName(dataModelBaseDTO.getName() + "IncrementTable");
        queryDTO.setEntityName(dataModelBaseDTO.getEntityName() + "IncrementTable");
        queryDTO.setWriteFilePath(dataModelBaseDTO.getTablePath().toLowerCase() + File.separator + "dto".toLowerCase() + File.separator + queryDTO.getEntityName() + ".java");
        dataModelBaseDTO.addQueryDto(queryDTO);
    }
}

